/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.test;

import de.statspez.pleditor.generator.runtime.NumberValue;
import de.statspez.pleditor.generator.runtime.OperatorLib;
import de.statspez.pleditor.generator.runtime.Value;

public class MathTest {
    public static void main(String[] args) {
        MathTest test = new MathTest();
        test.test1();
        test.test2();
        test.test3();
    }

    public void test1() {
        System.out.println("###################          ########################");
        System.out.println("###################  Test 1  ########################");
        System.out.println("###################          ########################");
        NumberValue v1 = new NumberValue(2451234001L);
        NumberValue v2 = new NumberValue(2451234000L);
        boolean erg = v1.eq(v2);
        System.out.println("v1        :" + v1 + "(" + v1.asDouble() + ")");
        System.out.println("v2        :" + v2 + "(" + v2.asDouble() + ")");
        System.out.println("v1.eq(v2) : " + erg);
        NumberValue d3 = new NumberValue(2.45123400000001E9);
        NumberValue d4 = new NumberValue(2.451234E9);
        boolean erg2 = d3.eq(d4);
        System.out.println("d3        :" + d3 + "(" + d3.asDouble() + ")");
        System.out.println("d4        :" + d4 + "(" + d4.asDouble() + ")");
        System.out.println("d3.eq(d4) : " + erg2);
        NumberValue d5 = new NumberValue(2.45123400000001E9);
        NumberValue d6 = new NumberValue(2.451234E9);
        boolean erg3 = d5.eq(d6);
        System.out.println("d5        :" + d5 + "(" + d5.asDouble() + ")");
        System.out.println("d6        :" + d6 + "(" + d6.asDouble() + ")");
        System.out.println("d5.eq(d6) : " + erg3);
        NumberValue d7 = new NumberValue(2.451234000000001E9);
        NumberValue d8 = new NumberValue(2.451234E9);
        boolean erg4 = d7.eq(d8);
        System.out.println("d7        :" + d7 + "(" + d7.asDouble() + ")");
        System.out.println("d8        :" + d8 + "(" + d8.asDouble() + ")");
        System.out.println("d7.eq(d8) : " + erg4);
        NumberValue d9 = new NumberValue(3.9999999999999996E-4);
        NumberValue d10 = new NumberValue(4.0E-4);
        boolean erg5 = d9.eq(d10);
        System.out.println("d9        :" + d9 + "(" + d9.asDouble() + ")");
        System.out.println("d10       :" + d10 + "(" + d10.asDouble() + ")");
        System.out.println("d8.eq(d10): " + erg5 + "(" + (d9.asDouble() == d10.asDouble()) + ")");
        double double1 = 4.000000000001102E12;
        double double2 = 4.0000000000033027E12;
        double double3 = 8.000000000004405E12;
        NumberValue d11 = new NumberValue(double1 + double2);
        NumberValue d12 = new NumberValue(double3);
        boolean erg6 = d11.eq(d12);
        System.out.println("d11        :" + d11 + "(" + d11.asDouble() + ")");
        System.out.println("d12        :" + d12 + "(" + d12.asDouble() + ")");
        System.out.println("d11.eq(d12): " + erg6);
        System.out.println("max double: 1.7976931348623157E308");
        System.out.println("min double: 4.9E-324");
        System.out.println("max long: 9223372036854775807");
        System.out.println("min long: -9223372036854775808");
        double double_t1 = 4.0E10;
        double double_t2 = 4.0000000001E10;
        System.out.println("double_t1: " + double_t1);
        System.out.println("double_t2: " + double_t2);
        long long_t1 = 40000000000L;
        long long_t2 = 40000000001L;
        System.out.println("long_t1 als double: " + (double)long_t1);
        System.out.println("long_t2 als double: " + (double)long_t2);
    }

    public void subTest2(double t1, double t2) {
        NumberValue nvt1 = new NumberValue(t1);
        NumberValue nvt2 = new NumberValue(t2);
        boolean erg = nvt1.eq(nvt2);
        System.out.println(" Zahl 1.  : " + nvt1 + "(" + nvt1.asDouble() + ")");
        System.out.println(" Zahl 2.  : " + nvt2 + "(" + nvt2.asDouble() + ")");
        System.out.println("       eq : " + erg);
        System.out.println();
    }

    public void test2() {
        System.out.println("###################          ########################");
        System.out.println("###################  Test 2  ########################");
        System.out.println("###################          ########################");
        this.subTest2(4.0E9, 4.000000001E9);
        this.subTest2(4.0E8, 4.00000001E8);
        this.subTest2(4.0E7, 4.0000001E7);
        this.subTest2(4000000.0, 4000001.0);
        this.subTest2(400000.0, 400001.0);
        this.subTest2(40000.0, 40001.0);
        this.subTest2(4000.0, 4001.0);
        this.subTest2(400.0, 401.0);
        this.subTest2(40.0, 41.0);
        this.subTest2(4.0, 1.0);
        this.subTest2(0.4, 0.41);
        this.subTest2(0.04, 0.041);
        this.subTest2(0.004, 0.0041);
        this.subTest2(4.0E-4, 4.1E-4);
        this.subTest2(4.0E-5, 4.1E-5);
        this.subTest2(4.0E-6, 4.1E-6);
        this.subTest2(4.0E-7, 4.1E-7);
        this.subTest2(4.0E-8, 4.1E-8);
        this.subTest2(4.0E-9, 4.1E-9);
        this.subTest2(4.0E-10, 4.1E-10);
    }

    public void test_minus(long l1, long l2, long l3, boolean sollErg) {
        NumberValue nvt1 = new NumberValue(l1);
        NumberValue nvt2 = new NumberValue(l2);
        NumberValue nvt3 = new NumberValue(l3);
        Value nvt_minus = OperatorLib.minus(null, nvt1, nvt2);
        boolean erg = nvt_minus.eq(nvt3);
        System.out.println(" Zahl 1.  : " + nvt1 + "(" + nvt1.asDouble() + ")");
        System.out.println(" Zahl 2.  : " + nvt2 + "(" + nvt2.asDouble() + ")");
        System.out.println(" Zahl 3.  : " + nvt3 + "(" + nvt2.asDouble() + ")");
        System.out.println("  1 - 2.  : " + nvt_minus + "(" + nvt_minus.asDouble() + ")");
        System.out.println("       eq : " + erg + " -> " + sollErg + (erg == sollErg ? "" : " !!!"));
        System.out.println();
    }

    public void test_plus(long l1, long l2, long l3, boolean sollErg) {
        NumberValue nvt1 = new NumberValue(l1);
        NumberValue nvt2 = new NumberValue(l2);
        NumberValue nvt3 = new NumberValue(l3);
        Value nvt_plus = OperatorLib.plus(null, nvt1, nvt2);
        boolean erg = nvt_plus.eq(nvt3);
        System.out.println(" Zahl 1.  : " + nvt1 + "(" + nvt1.asDouble() + ")");
        System.out.println(" Zahl 2.  : " + nvt2 + "(" + nvt2.asDouble() + ")");
        System.out.println(" Zahl 3.  : " + nvt3 + "(" + nvt2.asDouble() + ")");
        System.out.println("  1 + 2.  : " + nvt_plus + "(" + nvt_plus.asDouble() + ")");
        System.out.println("       eq : " + erg + " -> " + sollErg + (erg == sollErg ? "" : " !!!"));
        System.out.println();
    }

    public void test_plus_halb(long l1, long l2, long l3, boolean sollErg) {
        NumberValue nvt1 = new NumberValue(l1);
        NumberValue nvt2 = new NumberValue(l2);
        NumberValue nvt3 = new NumberValue(l3);
        Value nvt_plus = OperatorLib.plus(null, OperatorLib.div(null, nvt1, new NumberValue(3)), nvt2);
        boolean erg = nvt_plus.eq(nvt3);
        System.out.println(" Zahl 1.  : " + nvt1 + "(" + nvt1.asDouble() + ")");
        System.out.println(" Zahl 2.  : " + nvt2 + "(" + nvt2.asDouble() + ")");
        System.out.println(" Zahl 3.  : " + nvt3 + "(" + nvt2.asDouble() + ")");
        System.out.println("  1 + 2.  : " + nvt_plus + "(" + nvt_plus.asDouble() + ")");
        System.out.println("       eq : " + erg + " -> " + sollErg + (erg == sollErg ? "" : " !!!"));
        System.out.println();
    }

    public void test3() {
        System.out.println("###################          ########################");
        System.out.println("###################  Test 3  ########################");
        System.out.println("###################          ########################");
        this.test_minus(80000000000L, 40000000000L, 40000000000L, true);
        this.test_minus(80000000000L, 40000000001L, 40000000000L, false);
        this.test_minus(80000000000L, 40000000000L, 40000000001L, false);
        this.test_minus(80000000001L, 40000000000L, 40000000001L, true);
        this.test_minus(80000000000L, 40000000001L, 39999999999L, true);
        this.test_minus(80000000003L, 40000000004L, 39999999999L, true);
        this.test_plus(40000000000L, 40000000000L, 80000000000L, true);
        this.test_plus(40000000000L, 40000000001L, 80000000000L, false);
        this.test_plus(40000000000L, 40000000000L, 80000000001L, false);
        this.test_plus(40000000001L, 40000000000L, 80000000001L, true);
        this.test_plus(39999999999L, 40000000001L, 80000000000L, true);
        this.test_plus(39999999999L, 40000000004L, 80000000003L, true);
        this.test_plus_halb(120000000000L, 40000000000L, 80000000000L, true);
        this.test_plus_halb(120000000001L, 40000000000L, 80000000000L, true);
        this.test_plus_halb(120000000003L, 40000000000L, 80000000000L, false);
    }
}

