/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.test;

import de.statspez.pleditor.generator.interpreter.InterpreterContext;
import de.statspez.pleditor.generator.interpreter.ProgramInterpreter;
import de.statspez.pleditor.generator.interpreter.SimpleDataset;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.parser.Helper;
import de.statspez.pleditor.generator.runtime.Value;
import java.util.HashMap;
import junit.framework.TestCase;

public class HierarchicalPlTest
extends TestCase {
    private HashMap values;
    private SimpleDataset dataset;
    private InterpreterContext context;
    private ProgramInterpreter interpreter;

    public void testRecognizingHierarchicalCode() throws Exception {
        HierarchicalPlTest.assertFalse((boolean)Helper.metaStructureFor("RUECKGABE ANZAHL VON a").containsHierarchicalFunction());
        HierarchicalPlTest.assertTrue((boolean)Helper.metaStructureFor("RUECKGABE ANZAHL VON a[ALLE]").containsHierarchicalFunction());
        HierarchicalPlTest.assertTrue((boolean)Helper.metaStructureFor("RUECKGABE ANZAHL VON a[MIT b > 10]").containsHierarchicalFunction());
        HierarchicalPlTest.assertTrue((boolean)Helper.metaStructureFor("RUECKGABE EXISTIERT a").containsHierarchicalFunction());
        HierarchicalPlTest.assertTrue((boolean)Helper.metaStructureFor("RUECKGABE IDENTISCH a[ALLE].c").containsHierarchicalFunction());
        HierarchicalPlTest.assertTrue((boolean)Helper.metaStructureFor("RUECKGABE MIN a[ALLE].b").containsHierarchicalFunction());
        HierarchicalPlTest.assertTrue((boolean)Helper.metaStructureFor("RUECKGABE MAX a[ALLE].b").containsHierarchicalFunction());
        HierarchicalPlTest.assertTrue((boolean)Helper.metaStructureFor("RUECKGABE SUMME a[ALLE].b").containsHierarchicalFunction());
        HierarchicalPlTest.assertTrue((boolean)Helper.metaStructureFor("RUECKGABE MITTEL a[ALLE].b").containsHierarchicalFunction());
        HierarchicalPlTest.assertTrue((boolean)Helper.metaStructureFor("RUECKGABE VARIANZ a[ALLE].b").containsHierarchicalFunction());
        HierarchicalPlTest.assertTrue((boolean)Helper.metaStructureFor("RUECKGABE STABW a[ALLE].b").containsHierarchicalFunction());
        HierarchicalPlTest.assertTrue((boolean)Helper.metaStructureFor("FUER a[ALLE] GIB b AUS ENDE").containsHierarchicalFunction());
    }

    public void testSizeOf() throws Exception {
        MetaProgram program = Helper.metaStructureFor("RUECKGABE ANZAHL VON a[ALLE] = 5");
        Value returnValue = this.interpreter.execute(program, this.context);
        HierarchicalPlTest.assertTrue((boolean)returnValue.asBoolean());
        program = Helper.metaStructureFor("RUECKGABE ANZAHL VON a[MIT b < 10] = 3");
        returnValue = this.interpreter.execute(program, this.context);
        HierarchicalPlTest.assertTrue((boolean)returnValue.asBoolean());
        program = Helper.metaStructureFor("RUECKGABE ANZAHL VON a[MIT b > 10] = 2");
        returnValue = this.interpreter.execute(program, this.context);
        HierarchicalPlTest.assertTrue((boolean)returnValue.asBoolean());
    }

    public void testSizeOfTesting() throws Exception {
        MetaProgram program = Helper.metaStructureFor("RUECKGABE EXISTIERT a[MIT b > 10]");
        Value returnValue = this.interpreter.execute(program, this.context);
        HierarchicalPlTest.assertTrue((boolean)returnValue.asBoolean());
        program = Helper.metaStructureFor("RUECKGABE EXISTIERT MINDESTENS 2 a[MIT b > 10]");
        returnValue = this.interpreter.execute(program, this.context);
        HierarchicalPlTest.assertTrue((boolean)returnValue.asBoolean());
        program = Helper.metaStructureFor("RUECKGABE EXISTIERT GENAU 2 a[MIT b > 10]");
        returnValue = this.interpreter.execute(program, this.context);
        HierarchicalPlTest.assertTrue((boolean)returnValue.asBoolean());
        program = Helper.metaStructureFor("RUECKGABE EXISTIERT HOECHSTENS 2 a[MIT b > 10]");
        returnValue = this.interpreter.execute(program, this.context);
        HierarchicalPlTest.assertTrue((boolean)returnValue.asBoolean());
        program = Helper.metaStructureFor("RUECKGABE EXISTIERT a[MIT b < 10]");
        returnValue = this.interpreter.execute(program, this.context);
        HierarchicalPlTest.assertTrue((boolean)returnValue.asBoolean());
        program = Helper.metaStructureFor("RUECKGABE EXISTIERT MINDESTENS 3 a[MIT b < 10]");
        returnValue = this.interpreter.execute(program, this.context);
        HierarchicalPlTest.assertTrue((boolean)returnValue.asBoolean());
        program = Helper.metaStructureFor("RUECKGABE EXISTIERT GENAU 3 a[MIT b < 10]");
        returnValue = this.interpreter.execute(program, this.context);
        HierarchicalPlTest.assertTrue((boolean)returnValue.asBoolean());
        program = Helper.metaStructureFor("RUECKGABE EXISTIERT HOECHSTENS 3 a[MIT b < 10]");
        returnValue = this.interpreter.execute(program, this.context);
        HierarchicalPlTest.assertTrue((boolean)returnValue.asBoolean());
    }

    public void testIdentity() throws Exception {
        MetaProgram program = Helper.metaStructureFor("RUECKGABE IDENTISCH a[MIT b > 10].c = 0");
        Value returnValue = this.interpreter.execute(program, this.context);
        HierarchicalPlTest.assertTrue((boolean)returnValue.asBoolean());
        program = Helper.metaStructureFor("RUECKGABE IDENTISCH a[MIT b < 10].c = 2");
        returnValue = this.interpreter.execute(program, this.context);
        HierarchicalPlTest.assertTrue((boolean)returnValue.asBoolean());
        program = Helper.metaStructureFor("RUECKGABE IDENTISCH a[ALLE].c = 5");
        returnValue = this.interpreter.execute(program, this.context);
        HierarchicalPlTest.assertTrue((boolean)returnValue.asBoolean());
        program = Helper.metaStructureFor("RUECKGABE IDENTISCH a[MIT c = 'a'].c = 3");
        returnValue = this.interpreter.execute(program, this.context);
        HierarchicalPlTest.assertTrue((boolean)returnValue.asBoolean());
        program = Helper.metaStructureFor("RUECKGABE IDENTISCH a[MIT c = 'b'].c = 2");
        returnValue = this.interpreter.execute(program, this.context);
        HierarchicalPlTest.assertTrue((boolean)returnValue.asBoolean());
    }

    public void testMin() throws Exception {
        MetaProgram program = Helper.metaStructureFor("RUECKGABE MIN a[MIT b > 10].b = 11");
        Value returnValue = this.interpreter.execute(program, this.context);
        HierarchicalPlTest.assertTrue((boolean)returnValue.asBoolean());
        program = Helper.metaStructureFor("RUECKGABE MIN a[MIT b < 10].b = 2");
        returnValue = this.interpreter.execute(program, this.context);
        HierarchicalPlTest.assertTrue((boolean)returnValue.asBoolean());
    }

    public void testMax() throws Exception {
        MetaProgram program = Helper.metaStructureFor("RUECKGABE MAX a[MIT b < 10].b = 7");
        Value returnValue = this.interpreter.execute(program, this.context);
        HierarchicalPlTest.assertTrue((boolean)returnValue.asBoolean());
        program = Helper.metaStructureFor("RUECKGABE MAX a[MIT b > 10].b = 15");
        returnValue = this.interpreter.execute(program, this.context);
        HierarchicalPlTest.assertTrue((boolean)returnValue.asBoolean());
    }

    public void testSum() throws Exception {
        MetaProgram program = Helper.metaStructureFor("RUECKGABE SUMME a[MIT b < 10].b = 14");
        Value returnValue = this.interpreter.execute(program, this.context);
        HierarchicalPlTest.assertTrue((boolean)returnValue.asBoolean());
        program = Helper.metaStructureFor("RUECKGABE SUMME a[MIT b > 10].b = 26");
        returnValue = this.interpreter.execute(program, this.context);
        HierarchicalPlTest.assertTrue((boolean)returnValue.asBoolean());
        program = Helper.metaStructureFor("RUECKGABE SUMME a[ALLE].b = 40");
        returnValue = this.interpreter.execute(program, this.context);
        HierarchicalPlTest.assertTrue((boolean)returnValue.asBoolean());
    }

    public void testMean() throws Exception {
        MetaProgram program = Helper.metaStructureFor("RUECKGABE MITTEL a[MIT b < 10].b = 14 / 3");
        Value returnValue = this.interpreter.execute(program, this.context);
        HierarchicalPlTest.assertTrue((boolean)returnValue.asBoolean());
        program = Helper.metaStructureFor("RUECKGABE MITTEL a[MIT b > 10].b = 13");
        returnValue = this.interpreter.execute(program, this.context);
        HierarchicalPlTest.assertTrue((boolean)returnValue.asBoolean());
        program = Helper.metaStructureFor("RUECKGABE MITTEL a[ALLE].b = 8");
        returnValue = this.interpreter.execute(program, this.context);
        HierarchicalPlTest.assertTrue((boolean)returnValue.asBoolean());
    }

    public void testVariance() throws Exception {
        MetaProgram program = Helper.metaStructureFor("RUECKGABE VARIANZ a[MIT b < 10].b = 4.2222222");
        Value returnValue = this.interpreter.execute(program, this.context);
        HierarchicalPlTest.assertTrue((boolean)returnValue.asBoolean());
        program = Helper.metaStructureFor("RUECKGABE VARIANZ a[MIT b > 10].b = 4");
        returnValue = this.interpreter.execute(program, this.context);
        HierarchicalPlTest.assertTrue((boolean)returnValue.asBoolean());
        program = Helper.metaStructureFor("RUECKGABE VARIANZ a[ALLE].b = 20.8");
        returnValue = this.interpreter.execute(program, this.context);
        HierarchicalPlTest.assertTrue((boolean)returnValue.asBoolean());
    }

    public void testDevation() throws Exception {
        MetaProgram program = Helper.metaStructureFor("RUECKGABE STABW a[MIT b > 10].b = 2");
        Value returnValue = this.interpreter.execute(program, this.context);
        HierarchicalPlTest.assertTrue((boolean)returnValue.asBoolean());
        program = Helper.metaStructureFor("RUECKGABE STABW a[ALLE].b = 4.5607017");
        returnValue = this.interpreter.execute(program, this.context);
        HierarchicalPlTest.assertTrue((boolean)returnValue.asBoolean());
    }

    public void testForEach() throws Exception {
        MetaProgram program = Helper.metaStructureFor("VAR x x := 0 FUER a[ALLE] x := x + b ENDE RUECKGABE x = SUMME a[ALLE].b");
        Value returnValue = this.interpreter.execute(program, this.context);
        HierarchicalPlTest.assertTrue((boolean)returnValue.asBoolean());
        program = Helper.metaStructureFor("VAR x x := 0 FUER a[MIT b < 10] x := x + b ENDE RUECKGABE x = SUMME a[MIT b < 10].b");
        returnValue = this.interpreter.execute(program, this.context);
        HierarchicalPlTest.assertTrue((boolean)returnValue.asBoolean());
        program = Helper.metaStructureFor("VAR x x := 0 FUER a[MIT b > 10] x := x + b ENDE RUECKGABE x = SUMME a[MIT b > 10].b");
        returnValue = this.interpreter.execute(program, this.context);
        HierarchicalPlTest.assertTrue((boolean)returnValue.asBoolean());
    }

    public void testGlobal() throws Exception {
        MetaProgram program = Helper.metaStructureFor("RUECKGABE SUMME a[MIT &ALS_GANZZAHL(b) > GLOBAL a[1].b].b = 38");
        Value returnValue = this.interpreter.execute(program, this.context);
        HierarchicalPlTest.assertTrue((boolean)returnValue.asBoolean());
        program = Helper.metaStructureFor("VAR x x := LEER FUER a[MIT b < 10] GIB c, GLOBAL a[1].b AUS NACH x ENDE RUECKGABE x = 'a2b2a2'");
        returnValue = this.interpreter.execute(program, this.context);
        HierarchicalPlTest.assertTrue((boolean)returnValue.asBoolean());
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.values = new HashMap();
        this.values.put("a#anzahl", new Integer(5));
        this.values.put("a#0#anzahl", new Integer(1));
        this.values.put("a#0.b", "2");
        this.values.put("a#0.c", "a");
        this.values.put("a#1#anzahl", new Integer(1));
        this.values.put("a#1.b", "5");
        this.values.put("a#1.c", "b");
        this.values.put("a#2#anzahl", new Integer(1));
        this.values.put("a#2.b", "7");
        this.values.put("a#2.c", "a");
        this.values.put("a#3#anzahl", new Integer(1));
        this.values.put("a#3.b", "11");
        this.values.put("a#3.c", "b");
        this.values.put("a#4#anzahl", new Integer(1));
        this.values.put("a#4.b", "15");
        this.values.put("a#4.c", "a");
        this.dataset = new SimpleDataset(this.values);
        this.context = new InterpreterContext();
        this.context.setSatz(this.dataset);
        this.interpreter = new ProgramInterpreter();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.values.clear();
        this.values = null;
        this.dataset = null;
        this.context = null;
        this.interpreter = null;
    }
}

