/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime;

import de.statspez.pleditor.generator.runtime.FeatureVariable;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorExt;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorImpl;
import de.statspez.pleditor.generator.runtime.PlausiDescriptor;
import de.statspez.pleditor.generator.runtime.PlausiDescriptorExt;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PlausiDescriptorSerializer
extends DefaultHandler {
    private static final String ELEMENT_PLAUSI_DESCRIPTOR = "plausiDescriptor";
    private static final String ELEMENT_DEFAULT_FLOW = "defaultFlow";
    private static final String ELEMENT_FLOW = "flow";
    private static final String ELEMENT_PARAMETER_TYPE = "parameterType";
    private static final String ELEMENT_MAPPING = "mapping";
    private static final String ELEMENT_FIELD_DESCRIPTOR = "fieldDescriptor";
    private static final String ELEMENT_SPECIFICATION_CODE = "specificationCode";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_DESCRIPTION = "description";
    private static final String ATTRIBUTE_VERSION = "version";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String ATTRIBUTE_DIMENSIONS = "dimensions";
    private static final String ATTRIBUTE_MASK = "mask";
    private static final String ATTRIBUTE_CHECK = "check";
    private PlausiDescriptorExt descriptor;
    private String flowName;
    private Vector paramTypes = new Vector();
    private String specificationCodeId;
    private Hashtable mappings = new Hashtable();
    private StringBuffer buffer = new StringBuffer();

    public void serialize(PlausiDescriptorExt plausiDescriptor, OutputStream stream) throws IOException {
        FeldDeskriptorImpl field;
        Hashtable mapping;
        DeflaterOutputStream fos = new DeflaterOutputStream(stream);
        PrintStream out = new PrintStream(fos);
        out.println("<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>");
        out.print('<');
        out.print(ELEMENT_PLAUSI_DESCRIPTOR);
        if (plausiDescriptor.name() != null) {
            out.print(' ');
            out.print(ATTRIBUTE_NAME);
            out.print("=\"");
            out.print(this.getXMLTextISO_8859_1(plausiDescriptor.name()));
            out.print('\"');
        }
        out.print(' ');
        out.print(ATTRIBUTE_VERSION);
        out.print("=\"");
        out.print(plausiDescriptor.version());
        out.println("\">");
        PlausiDescriptor.FlowInfo flow = plausiDescriptor.standardFlow();
        if (flow != null) {
            out.print("   <");
            out.print(ELEMENT_DEFAULT_FLOW);
            if (flow.name != null) {
                out.print(' ');
                out.print(ATTRIBUTE_NAME);
                out.print("=\"");
                out.print(this.getXMLTextISO_8859_1(flow.name));
                out.print('\"');
            }
            out.println('>');
            if (flow.paramTypes != null) {
                int i = 0;
                while (i < flow.paramTypes.length) {
                    out.print("      <");
                    out.print(ELEMENT_PARAMETER_TYPE);
                    out.print('>');
                    out.print(flow.paramTypes[i].getName());
                    out.print("</");
                    out.print(ELEMENT_PARAMETER_TYPE);
                    out.println('>');
                    ++i;
                }
            }
            out.print("   </");
            out.print(ELEMENT_DEFAULT_FLOW);
            out.println('>');
        }
        Iterator iter = plausiDescriptor.flows();
        while (iter.hasNext()) {
            flow = (PlausiDescriptor.FlowInfo)iter.next();
            out.print("   <");
            out.print(ELEMENT_FLOW);
            if (flow.name != null) {
                out.print(' ');
                out.print(ATTRIBUTE_NAME);
                out.print("=\"");
                out.print(this.getXMLTextISO_8859_1(flow.name));
                out.print('\"');
            }
            out.println('>');
            if (flow.paramTypes != null) {
                int i = 0;
                while (i < flow.paramTypes.length) {
                    out.print("      <");
                    out.print(ELEMENT_PARAMETER_TYPE);
                    out.print('>');
                    out.print(flow.paramTypes[i].getName());
                    out.print("</");
                    out.print(ELEMENT_PARAMETER_TYPE);
                    out.println('>');
                    ++i;
                }
            }
            out.print("   </");
            out.print(ELEMENT_FLOW);
            out.println('>');
        }
        iter = plausiDescriptor.fields();
        if (iter.hasNext() && (mapping = (field = (FeldDeskriptorImpl)iter.next()).getFeldDeskriptor().getMappings()) != null) {
            for (String key : mapping.keySet()) {
                String name = (String)mapping.get(key);
                out.print("   <");
                out.print(ELEMENT_MAPPING);
                out.print(' ');
                out.print(ATTRIBUTE_ID);
                out.print("=\"");
                out.print(this.getXMLTextISO_8859_1(key));
                out.print('\"');
                if (name != null) {
                    out.print(' ');
                    out.print(ATTRIBUTE_NAME);
                    out.print("=\"");
                    out.print(this.getXMLTextISO_8859_1(name));
                    out.print('\"');
                }
                out.println("/>");
            }
        }
        iter = plausiDescriptor.fields();
        while (iter.hasNext()) {
            String checkMethod;
            field = (FeldDeskriptorImpl)iter.next();
            String id = field.hierarchyAsString();
            out.print("   <");
            out.print(ELEMENT_FIELD_DESCRIPTOR);
            out.print(' ');
            out.print(ATTRIBUTE_ID);
            out.print("=\"");
            out.print(this.getXMLTextISO_8859_1(id));
            out.print('\"');
            if (field.getFeldDeskriptor().getFeldNameTB() != null) {
                out.print(' ');
                out.print(ATTRIBUTE_NAME);
                out.print("=\"");
                out.print(this.getXMLTextISO_8859_1(field.getFeldDeskriptor().getFeldNameTB()));
                out.print('\"');
            }
            if (((FeldDeskriptorExt)field.getFeldDeskriptor()).getFeldBezeichnung() != null) {
                out.print(' ');
                out.print(ATTRIBUTE_DESCRIPTION);
                out.print("=\"");
                out.print(this.getXMLTextISO_8859_1(((FeldDeskriptorExt)field.getFeldDeskriptor()).getFeldBezeichnung()));
                out.print('\"');
            }
            out.print(' ');
            out.print(ATTRIBUTE_TYPE);
            out.print("=\"");
            out.print(field.getFeldDeskriptor().getFeldTyp());
            out.print('\"');
            out.print(' ');
            out.print(ATTRIBUTE_DIMENSIONS);
            out.print("=\"");
            out.print(this.getDimensionsAsString((FeldDeskriptorExt)field.getFeldDeskriptor()));
            out.print('\"');
            if (field.getFeldDeskriptor().getMaske() != null) {
                out.print(' ');
                out.print(ATTRIBUTE_MASK);
                out.print("=\"");
                out.print(this.getXMLTextISO_8859_1(field.getFeldDeskriptor().getMaske()));
                out.print('\"');
            }
            if ((checkMethod = plausiDescriptor.getCheckMethod(id)) != null) {
                out.print(' ');
                out.print(ATTRIBUTE_CHECK);
                out.print("=\"");
                out.print(this.getXMLTextISO_8859_1(checkMethod));
                out.print('\"');
            }
            out.println("/>");
        }
        iter = plausiDescriptor.specifications();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String code = plausiDescriptor.getCode(key);
            if (code == null) continue;
            out.print("   <");
            out.print(ELEMENT_SPECIFICATION_CODE);
            out.print(' ');
            out.print(ATTRIBUTE_ID);
            out.print("=\"");
            out.print(this.getXMLTextISO_8859_1(key));
            out.print('\"');
            out.println('>');
            out.println("<![CDATA[");
            out.println(code);
            out.println("]]>");
            out.print("   </");
            out.print(ELEMENT_SPECIFICATION_CODE);
            out.println('>');
        }
        out.print("</");
        out.print(ELEMENT_PLAUSI_DESCRIPTOR);
        out.print('>');
        fos.finish();
    }

    public PlausiDescriptorExt deserialize(InputStream stream) throws IOException, ParserConfigurationException, SAXException, FactoryConfigurationError {
        this.descriptor = null;
        this.mappings.clear();
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        parser.parse((InputStream)new InflaterInputStream(stream), (DefaultHandler)this);
        return this.descriptor;
    }

    private String getXMLTextISO_8859_1(String text) {
        if (text == null) {
            return null;
        }
        StringBuffer escapedText = new StringBuffer();
        char[] chars = text.toCharArray();
        int i = 0;
        while (i < chars.length) {
            switch (chars[i]) {
                case '<': {
                    escapedText.append("&lt;");
                    break;
                }
                case '>': {
                    escapedText.append("&gt;");
                    break;
                }
                case '&': {
                    escapedText.append("&amp;");
                    break;
                }
                case '\"': {
                    escapedText.append("&quot;");
                    break;
                }
                default: {
                    escapedText.append(chars[i]);
                }
            }
            ++i;
        }
        return escapedText.toString();
    }

    private String getDimensionsAsString(FeldDeskriptorExt typeDescriptor) {
        StringBuffer dimension = new StringBuffer();
        Vector<FeldDeskriptorExt> vector = new Vector<FeldDeskriptorExt>();
        while (typeDescriptor != null) {
            vector.insertElementAt(typeDescriptor, 0);
            typeDescriptor = (FeldDeskriptorExt)typeDescriptor.getVorgaenger();
        }
        int i = 0;
        while (i < vector.size()) {
            typeDescriptor = (FeldDeskriptorExt)vector.get(i);
            if (typeDescriptor.getDimension() != null && typeDescriptor.getDimension().length > 0) {
                int j = 0;
                while (j < typeDescriptor.getDimension().length) {
                    dimension.append(typeDescriptor.getDimension()[j]);
                    if (j < typeDescriptor.getDimension().length - 1) {
                        dimension.append(',');
                    }
                    ++j;
                }
            } else {
                dimension.append('0');
            }
            if (i < vector.size() - 1) {
                dimension.append(';');
            }
            ++i;
        }
        return dimension.toString();
    }

    private int[][] getDimensionsAsIntArray(String dimensionsAsString) throws SAXException {
        String[] dimensionsAsStringArray = dimensionsAsString.split(";");
        int[][] dimensions = new int[dimensionsAsStringArray.length][];
        int i = 0;
        while (i < dimensionsAsStringArray.length) {
            if (!dimensionsAsStringArray[i].equals("0")) {
                String[] dimensionAsString = dimensionsAsStringArray[i].split(",");
                dimensions[i] = new int[dimensionAsString.length];
                int j = 0;
                while (j < dimensionAsString.length) {
                    try {
                        dimensions[i][j] = Integer.parseInt(dimensionAsString[j]);
                    }
                    catch (NumberFormatException e) {
                        throw new SAXException("Dimension ist ungueltig.", e);
                    }
                    ++j;
                }
            } else {
                dimensions[i] = new int[0];
            }
            ++i;
        }
        return dimensions;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.buffer.delete(0, this.buffer.length());
        if (ELEMENT_PLAUSI_DESCRIPTOR.equalsIgnoreCase(qName)) {
            this.descriptor = new PlausiDescriptorExt();
            this.descriptor.setName(attributes.getValue(ATTRIBUTE_NAME));
            try {
                this.descriptor.setVersion(Integer.parseInt(attributes.getValue(ATTRIBUTE_VERSION)));
            }
            catch (NumberFormatException e) {
                throw new SAXException("Versionsangabe ist ungueltig.", e);
            }
        }
        if (ELEMENT_DEFAULT_FLOW.equalsIgnoreCase(qName)) {
            this.flowName = attributes.getValue(ATTRIBUTE_NAME);
            this.paramTypes.clear();
        } else if (ELEMENT_FLOW.equalsIgnoreCase(qName)) {
            this.flowName = attributes.getValue(ATTRIBUTE_NAME);
            this.paramTypes.clear();
        } else if (ELEMENT_MAPPING.equalsIgnoreCase(qName)) {
            this.mappings.put(attributes.getValue(ATTRIBUTE_ID), attributes.getValue(ATTRIBUTE_NAME));
        } else if (ELEMENT_FIELD_DESCRIPTOR.equalsIgnoreCase(qName)) {
            int fieldDescriptorType;
            String fieldDescriptorId = attributes.getValue(ATTRIBUTE_ID);
            int[][] fieldDescriptorDimensions = this.getDimensionsAsIntArray(attributes.getValue(ATTRIBUTE_DIMENSIONS));
            FeldDeskriptorExt parentFieldTypeDescriptor = null;
            FeatureVariable parentFieldDescriptor = null;
            if (fieldDescriptorId != null && fieldDescriptorId.indexOf(46) > 0) {
                String[] hierarchy = fieldDescriptorId.split("\\.");
                int i = 0;
                while (i < hierarchy.length - 1) {
                    parentFieldTypeDescriptor = new FeldDeskriptorExt(this.mappings, hierarchy[i], parentFieldTypeDescriptor, 7, fieldDescriptorDimensions[i], null);
                    parentFieldDescriptor = new FeatureVariable(parentFieldDescriptor, parentFieldTypeDescriptor, new int[0]);
                    ++i;
                }
            }
            try {
                fieldDescriptorType = Integer.parseInt(attributes.getValue(ATTRIBUTE_TYPE));
            }
            catch (NumberFormatException e) {
                throw new SAXException("Feldtyp ist ungueltig.", e);
            }
            FeldDeskriptorExt fieldTypeDescriptor = new FeldDeskriptorExt(this.mappings, attributes.getValue(ATTRIBUTE_NAME), parentFieldTypeDescriptor, fieldDescriptorType, attributes.getValue(ATTRIBUTE_MASK), fieldDescriptorDimensions[fieldDescriptorDimensions.length - 1], attributes.getValue(ATTRIBUTE_DESCRIPTION));
            this.descriptor.setFeldDeskriptor(fieldDescriptorId, new FeatureVariable(parentFieldDescriptor, fieldTypeDescriptor, new int[0]));
            if (attributes.getIndex(ATTRIBUTE_CHECK) >= 0) {
                this.descriptor.setCheckMethod(fieldDescriptorId, attributes.getValue(ATTRIBUTE_CHECK));
            }
        } else if (ELEMENT_SPECIFICATION_CODE.equalsIgnoreCase(qName)) {
            this.specificationCodeId = attributes.getValue(ATTRIBUTE_ID);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (ELEMENT_DEFAULT_FLOW.equalsIgnoreCase(qName)) {
            PlausiDescriptor.FlowInfo flow = new PlausiDescriptor.FlowInfo(this.flowName, this.paramTypes.toArray(new Class[this.paramTypes.size()]));
            this.descriptor.addFlow(flow);
            this.descriptor.setStandardFlow(flow);
            this.paramTypes.clear();
        } else if (ELEMENT_FLOW.equalsIgnoreCase(qName)) {
            PlausiDescriptor.FlowInfo flow = new PlausiDescriptor.FlowInfo(this.flowName, this.paramTypes.toArray(new Class[this.paramTypes.size()]));
            this.descriptor.addFlow(flow);
            this.paramTypes.clear();
        } else if (ELEMENT_PARAMETER_TYPE.equalsIgnoreCase(qName)) {
            try {
                this.paramTypes.add(Class.forName(this.buffer.toString()));
            }
            catch (ClassNotFoundException e) {
                throw new SAXException("Parametertyp wird nicht unterstuetzt.", e);
            }
        } else if (ELEMENT_SPECIFICATION_CODE.equalsIgnoreCase(qName)) {
            this.descriptor.setCodeFor(this.specificationCodeId, this.buffer.toString());
        }
    }

    @Override
    public void characters(char[] chars, int offset, int length) throws SAXException {
        this.buffer.append(chars, offset, length);
    }
}

