/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.support;

import de.statspez.pleditor.generator.codegen.support.Scope;
import de.statspez.pleditor.generator.codegen.support.ScopeImpl;
import de.statspez.pleditor.generator.codegen.support.SymbolDescriptor;
import de.statspez.pleditor.generator.codegen.support.SymbolDescriptorFactory;
import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.InternalFunctions;
import de.statspez.pleditor.generator.meta.MetaCustomAblauf;
import de.statspez.pleditor.generator.meta.MetaCustomAuspraegung;
import de.statspez.pleditor.generator.meta.MetaCustomFunktion;
import de.statspez.pleditor.generator.meta.MetaCustomPruefung;
import de.statspez.pleditor.generator.meta.MetaCustomThemenbereich;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaElementVisitor;
import de.statspez.pleditor.generator.meta.MetaIdentifier;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegungsgruppe;
import de.statspez.pleditor.generator.meta.generated.MetaPLAblauf;
import de.statspez.pleditor.generator.meta.generated.MetaPLAuspraegung;
import de.statspez.pleditor.generator.meta.generated.MetaPLFunktion;
import de.statspez.pleditor.generator.meta.generated.MetaPLInitwert;
import de.statspez.pleditor.generator.meta.generated.MetaPLMaterial;
import de.statspez.pleditor.generator.meta.generated.MetaPLPruefung;
import de.statspez.pleditor.generator.meta.generated.MetaPLVariable;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaTBMaterialReferenz;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;

public class TbScopeBuilder
extends AbstractElementVisitor {
    public static final String ROOT_NAMESPACE = "Kontext";
    private Hashtable scopes;
    private Scope plausiScope;
    private Scope currentScope = null;
    private Stack namespace = new Stack();
    private SymbolDescriptorFactory descriptorFactory = null;
    private boolean metaElementsAsProperty = true;
    private boolean ignoreEmptyFields = false;
    private boolean weitereSubMaterialienAufnehmen = true;

    public TbScopeBuilder(SymbolDescriptorFactory descriptorFactory) {
        this.descriptorFactory = descriptorFactory;
    }

    public Scope createScopes(MetaPlausibilisierung plausi, Hashtable tbScopes) {
        return this.createScopes(plausi, tbScopes, false);
    }

    public Scope createScopes(MetaPlausibilisierung plausi, Hashtable tbScopes, boolean ignoreEmptyFields) {
        this.scopes = tbScopes;
        this.plausiScope = new ScopeImpl();
        this.ignoreEmptyFields = ignoreEmptyFields;
        this.includeInternalFunctionsIn(this.plausiScope);
        plausi.accept(this);
        return this.plausiScope;
    }

    @Override
    public void visitPlausibilisierung(MetaPlausibilisierung plausi) {
        this.currentScope = this.plausiScope;
        this.visitElements(plausi.getAuspraegungsgruppen());
        this.visitElements(plausi.getFunktionen());
        this.visitElements(plausi.getThemenbereiche());
    }

    @Override
    public void visitAuspraegungsgruppe(MetaAuspraegungsgruppe classificationGroup) {
        MetaIdentifier idCode = new MetaIdentifier("#" + classificationGroup.getName());
        SymbolDescriptor sd = this.descriptorFactory.createSymbolDescriptor(classificationGroup);
        this.plausiScope.define(idCode, ROOT_NAMESPACE, sd);
        this.setMetaElementFor(idCode, ROOT_NAMESPACE, this.plausiScope, classificationGroup);
        this.visitElements(classificationGroup.getAuspraegungsComps().getAuspraegungen());
    }

    @Override
    public void visitPLAuspraegung(MetaPLAuspraegung classification) {
        SymbolDescriptor sd = this.descriptorFactory.createSymbolDescriptor(classification);
        MetaIdentifier idValue = new MetaIdentifier(((MetaCustomAuspraegung)classification).getHierachicalValue());
        this.plausiScope.define(idValue, ROOT_NAMESPACE, sd);
        this.setMetaElementFor(idValue, ROOT_NAMESPACE, this.plausiScope, classification);
        int i = 0;
        while (i < classification.sizeOfAuspraegungen()) {
            classification.getFromAuspraegungen(i).accept(this);
            ++i;
        }
    }

    @Override
    public void visitPLMaterial(MetaPLMaterial material) {
        MetaIdentifier materialId = new MetaIdentifier(material.getName());
        SymbolDescriptor sd = this.descriptorFactory.createSymbolDescriptor(material);
        this.plausiScope.define(materialId, ROOT_NAMESPACE, sd);
        this.setMetaElementFor(materialId, ROOT_NAMESPACE, this.plausiScope, material);
        this.includeMaterialFieldsInScope(material, material.getName(), this.plausiScope);
    }

    @Override
    public void visitThemenbereich(MetaThemenbereich tb) {
        TbHierachyTraverser traverser = new TbHierachyTraverser();
        this.currentScope = new ScopeImpl(this.plausiScope);
        this.processThemenbereich(tb, this);
        Iterator it = tb.getFelder();
        while (it.hasNext()) {
            MetaTBFeld aField = (MetaTBFeld)it.next();
            traverser.setReferingField(aField);
            aField.accept(traverser);
        }
        this.scopes.put(tb.getName(), this.currentScope);
        this.currentScope = null;
    }

    @Override
    public void visitTBFeld(MetaTBFeld feld) {
        this.defineFeld(feld, this.currentScope);
    }

    @Override
    public void visitPLVariable(MetaPLVariable variable) {
        this.defineVariable(variable, this.currentScope);
    }

    @Override
    public void visitPLInitwert(MetaPLInitwert initwert) {
        this.defineInitwert(initwert, this.currentScope);
    }

    @Override
    public void visitPLPruefung(MetaPLPruefung pruefung) {
        this.defineCallableSection(pruefung.getPruefschluessel(), pruefung, ((MetaCustomPruefung)pruefung).getMetaSpezifikation(), this.currentScope);
    }

    @Override
    public void visitPLAblauf(MetaPLAblauf ablauf) {
        this.defineCallableSection(ablauf.getName(), ablauf, ((MetaCustomAblauf)ablauf).getMetaSpezifikation(), this.currentScope);
    }

    @Override
    public void visitPLFunktion(MetaPLFunktion funktion) {
        this.defineCallableSection(funktion.getName(), funktion, ((MetaCustomFunktion)funktion).getMetaSpezifikation(), this.currentScope);
    }

    @Override
    public void visitTBMaterialReferenz(MetaTBMaterialReferenz materialRef) {
        this.defineMaterialReferenz(materialRef, this.currentScope);
    }

    private void enterSubNamespace(String namespace) {
        this.namespace.push(namespace);
    }

    private String leaveSubNamespace() {
        return (String)this.namespace.pop();
    }

    public void includeInternalFunctionsIn(Scope aScope) {
        MetaCustomFunktion[] functions = InternalFunctions.instance().allFunctions();
        int i = 0;
        while (i < functions.length) {
            this.defineCallableSection(functions[i].getName(), functions[i], functions[i].getMetaSpezifikation(), aScope);
            ++i;
        }
    }

    private void defineFeld(MetaTBFeld feld, Scope aScope) {
        MetaIdentifier id = new MetaIdentifier(feld.getName());
        SymbolDescriptor sd = this.descriptorFactory.createSymbolDescriptor(feld);
        aScope.define(id, this.namespace(), sd);
        this.setMetaElementFor(id, this.namespace(), aScope, feld);
    }

    private void defineVariable(MetaPLVariable variable, Scope aScope) {
        MetaIdentifier id = new MetaIdentifier(variable.getName());
        SymbolDescriptor sd = this.descriptorFactory.createSymbolDescriptor(variable);
        aScope.define(id, this.namespace(), sd);
        this.setMetaElementFor(id, this.namespace(), aScope, variable);
    }

    private void defineInitwert(MetaPLInitwert initwert, Scope aScope) {
        MetaIdentifier id = new MetaIdentifier(initwert.getName());
        SymbolDescriptor sd = this.descriptorFactory.createSymbolDescriptor(initwert);
        aScope.define(id, this.namespace(), sd);
        this.setMetaElementFor(id, this.namespace(), aScope, initwert);
    }

    private void defineCallableSection(String sectionName, MetaElement section, MetaProgram calledProgram, Scope aScope) {
        MetaIdentifier id = new MetaIdentifier(sectionName);
        SymbolDescriptor sd = this.descriptorFactory.createSymbolDescriptor(section);
        aScope.define(id, this.namespace(), sd);
        this.setMetaElementFor(id, this.namespace(), aScope, section);
    }

    private void defineMaterialReferenz(MetaTBMaterialReferenz materialRef, Scope aScope) {
        MetaPLMaterial material = materialRef.getMaterialbeschreibung();
        MetaIdentifier id = new MetaIdentifier(materialRef.getName());
        MetaIdentifier materialId = new MetaIdentifier(material.getName());
        SymbolDescriptor sd = this.descriptorFactory.createSymbolDescriptor(materialRef);
        aScope.define(id, this.namespace(), sd);
        this.setMetaElementFor(id, this.namespace(), aScope, materialRef);
        if (this.weitereSubMaterialienAufnehmen) {
            this.weitereSubMaterialienAufnehmen = false;
            this.includeMaterialFieldsInScope(material, materialRef.getName(), aScope);
            this.weitereSubMaterialienAufnehmen = true;
        }
    }

    private String namespace() {
        StringBuffer ns = new StringBuffer(ROOT_NAMESPACE);
        Iterator it = this.namespace.iterator();
        while (it.hasNext()) {
            ns.append(".");
            ns.append((String)it.next());
        }
        return ns.toString();
    }

    private void processThemenbereich(MetaThemenbereich tb, MetaElementVisitor visitor) {
        Iterator it = tb.getInitialisierungswerte();
        while (it.hasNext()) {
            ((MetaPLInitwert)it.next()).accept(visitor);
        }
        it = tb.getVariablen();
        while (it.hasNext()) {
            ((MetaPLVariable)it.next()).accept(visitor);
        }
        it = tb.getPruefungen();
        while (it.hasNext()) {
            ((MetaPLPruefung)it.next()).accept(visitor);
        }
        it = tb.getAblaeufe();
        while (it.hasNext()) {
            ((MetaPLAblauf)it.next()).accept(visitor);
        }
        it = tb.getFunktionen();
        while (it.hasNext()) {
            ((MetaPLFunktion)it.next()).accept(visitor);
        }
        it = tb.getMaterialreferenzen();
        while (it.hasNext()) {
            ((MetaTBMaterialReferenz)it.next()).accept(visitor);
        }
    }

    private void includeMaterialFieldsInScope(MetaPLMaterial material, String subnamespace, Scope aScope) {
        this.currentScope = aScope;
        this.enterSubNamespace(subnamespace);
        RefMaterialTbHierachyTraverser traverser = new RefMaterialTbHierachyTraverser();
        Iterator it = material.getThemenbereich().getFelder();
        while (it.hasNext()) {
            MetaTBFeld aField = (MetaTBFeld)it.next();
            traverser.visitTBFeld(aField);
        }
        this.leaveSubNamespace();
    }

    private void setMetaElementFor(MetaIdentifier symbolId, String namespace, Scope aScope, MetaElement metaElement) {
        if (this.metaElementsAsProperty) {
            aScope.setProperty(symbolId, namespace, "MetaElement", metaElement);
        }
    }

    private class RefMaterialTbHierachyTraverser {
        private RefMaterialTbHierachyTraverser() {
        }

        public void visitThemenbereich(String referingName, MetaThemenbereich aTb) {
            MetaCustomThemenbereich tb = (MetaCustomThemenbereich)aTb;
            TbScopeBuilder.this.enterSubNamespace(referingName);
            Iterator it = tb.getFelder();
            while (it.hasNext()) {
                this.visitTBFeld((MetaTBFeld)it.next());
            }
            TbScopeBuilder.this.leaveSubNamespace();
        }

        public void visitTBFeld(MetaTBFeld feld) {
            TbScopeBuilder.this.defineFeld(feld, TbScopeBuilder.this.currentScope);
            if (feld.getKlasse() instanceof MetaThemenbereich) {
                this.visitThemenbereich(feld.getName(), (MetaCustomThemenbereich)feld.getKlasse());
            }
        }
    }

    private class TbHierachyTraverser
    extends AbstractElementVisitor {
        private MetaTBFeld referringField = null;

        private TbHierachyTraverser() {
        }

        public void setReferingField(MetaTBFeld aField) {
            this.referringField = aField;
        }

        @Override
        public void visitThemenbereich(MetaThemenbereich aTb) {
            MetaCustomThemenbereich tb = (MetaCustomThemenbereich)aTb;
            TbScopeBuilder.this.enterSubNamespace(this.referringField.getName());
            TbScopeBuilder.this.processThemenbereich(tb, this);
            Iterator it = tb.getFelder();
            while (it.hasNext()) {
                ((MetaTBFeld)it.next()).accept(this);
            }
            TbScopeBuilder.this.leaveSubNamespace();
        }

        @Override
        public void visitTBFeld(MetaTBFeld feld) {
            TbScopeBuilder.this.defineFeld(feld, TbScopeBuilder.this.currentScope);
            if (feld.getKlasse() instanceof MetaThemenbereich) {
                TbHierachyTraverser traverser = new TbHierachyTraverser();
                traverser.setReferingField(feld);
                feld.getKlasse().accept(traverser);
            } else if (feld.getKlasse() != null && !TbScopeBuilder.this.ignoreEmptyFields) {
                feld.getKlasse().accept(this);
            }
        }

        @Override
        public void visitPLVariable(MetaPLVariable variable) {
            TbScopeBuilder.this.defineVariable(variable, TbScopeBuilder.this.currentScope);
        }

        @Override
        public void visitPLInitwert(MetaPLInitwert initwert) {
            TbScopeBuilder.this.defineInitwert(initwert, TbScopeBuilder.this.currentScope);
        }

        @Override
        public void visitPLPruefung(MetaPLPruefung pruefung) {
            TbScopeBuilder.this.defineCallableSection(pruefung.getPruefschluessel(), pruefung, ((MetaCustomPruefung)pruefung).getMetaSpezifikation(), TbScopeBuilder.this.currentScope);
        }

        @Override
        public void visitPLAblauf(MetaPLAblauf ablauf) {
            TbScopeBuilder.this.defineCallableSection(ablauf.getName(), ablauf, ((MetaCustomAblauf)ablauf).getMetaSpezifikation(), TbScopeBuilder.this.currentScope);
        }

        @Override
        public void visitPLFunktion(MetaPLFunktion funktion) {
            TbScopeBuilder.this.defineCallableSection(funktion.getName(), funktion, ((MetaCustomFunktion)funktion).getMetaSpezifikation(), TbScopeBuilder.this.currentScope);
        }

        @Override
        public void visitTBMaterialReferenz(MetaTBMaterialReferenz materialRef) {
            TbScopeBuilder.this.defineMaterialReferenz(materialRef, TbScopeBuilder.this.currentScope);
        }
    }
}

