/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.support;

import de.statspez.pleditor.generator.codegen.support.GenericSymbolDescriptor;
import de.statspez.pleditor.generator.codegen.support.SymbolDescriptor;
import de.statspez.pleditor.generator.codegen.support.SymbolDescriptorFactory;
import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.MetaCustomAblauf;
import de.statspez.pleditor.generator.meta.MetaCustomAuspraegung;
import de.statspez.pleditor.generator.meta.MetaCustomFunktion;
import de.statspez.pleditor.generator.meta.MetaCustomInitwert;
import de.statspez.pleditor.generator.meta.MetaCustomMerkmal;
import de.statspez.pleditor.generator.meta.MetaCustomPruefung;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.MetaCustomThemenbereich;
import de.statspez.pleditor.generator.meta.MetaCustomVariable;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.MetaProgramParameter;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegungsgruppe;
import de.statspez.pleditor.generator.meta.generated.MetaPLAblauf;
import de.statspez.pleditor.generator.meta.generated.MetaPLAuspraegung;
import de.statspez.pleditor.generator.meta.generated.MetaPLFunktion;
import de.statspez.pleditor.generator.meta.generated.MetaPLInitwert;
import de.statspez.pleditor.generator.meta.generated.MetaPLMaterial;
import de.statspez.pleditor.generator.meta.generated.MetaPLPruefung;
import de.statspez.pleditor.generator.meta.generated.MetaPLVariable;
import de.statspez.pleditor.generator.meta.generated.MetaStatspezObjekt;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaTBMaterialReferenz;

public class GenericSymbolDescriptorFactory
extends AbstractElementVisitor
implements SymbolDescriptorFactory {
    private GenericSymbolDescriptor currentDescriptor = null;

    @Override
    public SymbolDescriptor createSymbolDescriptor(MetaElement anElement) {
        this.currentDescriptor = null;
        anElement.accept(this);
        if (this.currentDescriptor == null) {
            throw new IllegalArgumentException("Erzeugung eines Symbol-Deskriptors fuer " + anElement.toString() + " nicht moeglich.");
        }
        return this.currentDescriptor;
    }

    @Override
    public void visitPLAuspraegung(MetaPLAuspraegung anApg) {
        MetaCustomAuspraegung apg = (MetaCustomAuspraegung)anApg;
        this.currentDescriptor = new GenericSymbolDescriptor();
        this.currentDescriptor.setIsClassification(true);
        this.currentDescriptor.setDisplayName(anApg.getName());
        if (apg.getMetaObjectContext() != null) {
            this.currentDescriptor.setContext(apg.getMetaObjectContext().getObjectPakage());
        }
        this.currentDescriptor.setDescription(apg.getLangtext());
    }

    @Override
    public void visitAuspraegungsgruppe(MetaAuspraegungsgruppe apg) {
        this.currentDescriptor = new GenericSymbolDescriptor();
        this.currentDescriptor.setIsClassification(true);
        this.currentDescriptor.setIsClassificationGroup(true);
        this.currentDescriptor.setDisplayName(apg.getName());
        if (apg.getMetaObjectContext() != null) {
            this.currentDescriptor.setContext(apg.getMetaObjectContext().getObjectPakage());
        }
        this.currentDescriptor.setDescription(apg.getBeschreibung());
    }

    @Override
    public void visitTBFeld(MetaTBFeld aFeld) {
        MetaCustomTBFeld feld = (MetaCustomTBFeld)aFeld;
        this.currentDescriptor = new GenericSymbolDescriptor();
        this.currentDescriptor.setIsTbField(true);
        this.currentDescriptor.setDisplayName(aFeld.getName());
        this.currentDescriptor.setDescription(aFeld.getBeschreibung());
        MetaStatspezObjekt klasse = aFeld.getKlasse();
        if (klasse instanceof MetaCustomMerkmal) {
            String merkmalType;
            MetaCustomMerkmal merkmal = (MetaCustomMerkmal)klasse;
            this.currentDescriptor.setFieldReferencesTb(false);
            this.setType(this.currentDescriptor, merkmal.getTyp());
            this.currentDescriptor.setMerkmal(merkmal.getName());
            this.currentDescriptor.setSpecification(merkmal.getWertebereich());
            switch (merkmal.getTyp()) {
                case 5: {
                    merkmalType = "Ganzzahl";
                    break;
                }
                case 1: {
                    merkmalType = "Kommazahl";
                    break;
                }
                case 2: {
                    merkmalType = "Zeichenkette";
                    break;
                }
                case 3: 
                case 4: {
                    merkmalType = "Datum";
                    break;
                }
                case 6: {
                    merkmalType = "Kategorie";
                    break;
                }
                default: {
                    merkmalType = null;
                }
            }
            String klasseWertebereichName = merkmal.getKlasseWertebereich() != null ? merkmal.getKlasseWertebereich().getName() : null;
            String description = GenericSymbolDescriptorFactory.generateDescriptionForMerkmalfield(aFeld.getBeschreibung(), merkmal.getName(), merkmalType, merkmal.getLaenge(), merkmal.getLeer(), klasseWertebereichName, merkmal.getMaske());
            this.currentDescriptor.setDescription(description);
        } else if (klasse instanceof MetaCustomThemenbereich) {
            MetaCustomThemenbereich tb = (MetaCustomThemenbereich)klasse;
            this.currentDescriptor.setFieldReferencesTb(true);
            this.currentDescriptor.setMerkmal(tb.getName());
        }
        if (feld.dimensions() != null) {
            this.currentDescriptor.setIsArray(true);
            this.currentDescriptor.setDimensions(feld.dimensions());
        }
        if (aFeld.getMetaObjectContext() != null) {
            this.currentDescriptor.setContext(aFeld.getMetaObjectContext().getObjectPakage());
        }
    }

    @Override
    public void visitPLInitwert(MetaPLInitwert anInitwert) {
        MetaCustomInitwert initwert = (MetaCustomInitwert)anInitwert;
        this.currentDescriptor = new GenericSymbolDescriptor();
        this.currentDescriptor.setIsInitwert(true);
        if (initwert.dimensions() != null) {
            this.currentDescriptor.setIsArray(true);
            this.currentDescriptor.setDimensions(initwert.dimensions());
        }
        this.setType(this.currentDescriptor, initwert.getTyp());
        this.currentDescriptor.setDisplayName(initwert.getName());
        this.currentDescriptor.setDescription(initwert.getBeschreibung());
        if (initwert.getMetaObjectContext() != null) {
            this.currentDescriptor.setContext(initwert.getMetaObjectContext().getObjectPakage());
        }
    }

    @Override
    public void visitPLPruefung(MetaPLPruefung pruefung) {
        assert (this.currentDescriptor == null);
        ((MetaCustomPruefung)pruefung).getMetaSpezifikation().accept(this);
        assert (this.currentDescriptor != null);
        this.currentDescriptor.setIsPruefung(true);
        this.currentDescriptor.setIsBoolean(true);
        this.currentDescriptor.setDisplayName(pruefung.getName());
        if (pruefung.getMetaObjectContext() != null) {
            this.currentDescriptor.setContext(pruefung.getMetaObjectContext().getObjectPakage());
        }
        this.currentDescriptor.setDescription(pruefung.getBeschreibung());
        this.currentDescriptor.setSpecification(((MetaCustomPruefung)pruefung).getPLSpezifikation());
    }

    @Override
    public void visitPLAblauf(MetaPLAblauf ablauf) {
        MetaCustomAblauf anAblauf = (MetaCustomAblauf)ablauf;
        assert (this.currentDescriptor == null);
        anAblauf.getMetaSpezifikation().accept(this);
        assert (this.currentDescriptor != null);
        this.currentDescriptor.setIsAblauf(true);
        this.currentDescriptor.setDisplayName(ablauf.getName());
        if (ablauf.getMetaObjectContext() != null) {
            this.currentDescriptor.setContext(ablauf.getMetaObjectContext().getObjectPakage());
        }
        this.currentDescriptor.setDescription(ablauf.getBeschreibung());
        this.currentDescriptor.setSpecification(ablauf.getSpezifikation());
        GenericSymbolDescriptor ablDesc = this.currentDescriptor;
        SymbolDescriptor[] params = new SymbolDescriptor[anAblauf.getThemenbereich().sizeOfInitialisierungswerte()];
        int i = 0;
        while (i < params.length) {
            params[i] = this.createSymbolDescriptor(anAblauf.getThemenbereich().getFromInitialisierungswerte(i));
            ++i;
        }
        ablDesc.setFunctionParameters(params);
        this.currentDescriptor = ablDesc;
    }

    @Override
    public void visitPLFunktion(MetaPLFunktion funktion) {
        assert (this.currentDescriptor == null);
        ((MetaCustomFunktion)funktion).getMetaSpezifikation().accept(this);
        assert (this.currentDescriptor != null);
        if (funktion instanceof MetaCustomFunktion && ((MetaCustomFunktion)funktion).getFunctionType() == 1) {
            this.currentDescriptor.setIsEigenschaft(true);
        }
        this.currentDescriptor.setIsFunction(true);
        this.currentDescriptor.setDisplayName(funktion.getName());
        if (funktion.getMetaObjectContext() != null) {
            this.currentDescriptor.setContext(funktion.getMetaObjectContext().getObjectPakage());
        }
        this.currentDescriptor.setDescription(funktion.getBeschreibung());
        this.currentDescriptor.setSpecification(funktion.getAnweisungen());
    }

    @Override
    public void visitProgram(MetaProgram program) {
        this.currentDescriptor = new GenericSymbolDescriptor();
        this.currentDescriptor.setHasGenericType(true);
        GenericSymbolDescriptor prgDesc = this.currentDescriptor;
        SymbolDescriptor[] params = new SymbolDescriptor[program.numberOfParameters()];
        int i = 0;
        while (i < params.length) {
            params[i] = this.createSymbolDescriptor(program.parameterAt(i));
            ++i;
        }
        prgDesc.setFunctionParameters(params);
        this.currentDescriptor = prgDesc;
    }

    @Override
    public void visitProgramParameter(MetaProgramParameter param) {
        this.currentDescriptor = new GenericSymbolDescriptor();
        this.currentDescriptor.setIsParameter(true);
        this.currentDescriptor.setDisplayName(param.name().value());
        this.currentDescriptor.setDescription("Funktionsparameter");
        this.currentDescriptor.setIsArray(param.isList());
        if (param.isList()) {
            this.currentDescriptor.setDimensions(param.dimensions());
        }
        this.currentDescriptor.setHasGenericType(true);
    }

    @Override
    public void visitPLVariable(MetaPLVariable aVariable) {
        MetaCustomVariable variable = (MetaCustomVariable)aVariable;
        this.currentDescriptor = new GenericSymbolDescriptor();
        this.currentDescriptor.setIsHilfsvariable(true);
        this.currentDescriptor.setDisplayName(aVariable.getName());
        this.currentDescriptor.setDescription(aVariable.getBeschreibung());
        if (aVariable.getMetaObjectContext() != null) {
            this.currentDescriptor.setContext(aVariable.getMetaObjectContext().getObjectPakage());
        }
        this.setType(this.currentDescriptor, variable.getTyp());
        if (variable.getListe()) {
            this.currentDescriptor.setIsArray(true);
            this.currentDescriptor.setDimensions(variable.dimensions());
        }
    }

    @Override
    public void visitPLMaterial(MetaPLMaterial aMaterial) {
        this.currentDescriptor = new GenericSymbolDescriptor();
        this.currentDescriptor.setIsMaterial(true);
        this.currentDescriptor.setHasGenericType(true);
        this.currentDescriptor.setDisplayName(aMaterial.getName());
        if (aMaterial.getMetaObjectContext() != null) {
            this.currentDescriptor.setContext(aMaterial.getMetaObjectContext().getObjectPakage());
        }
        this.currentDescriptor.setDescription(aMaterial.getBeschreibung());
    }

    @Override
    public void visitTBMaterialReferenz(MetaTBMaterialReferenz aReference) {
        aReference.getMaterialbeschreibung().accept(this);
        assert (this.currentDescriptor != null) : "SymbolDescriptor fuer referenziertes Material wurde nicht erzeugt";
        this.currentDescriptor.setIsReference(true);
    }

    public static String generateDescriptionForMerkmalfield(String fieldDescription, String merkmalName, String merkmalType, long merkmalLength, boolean merkmalLeerErlaubt, String merkmalKlasseWertebereichName, String merkmalMaske) {
        String ln = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        if (fieldDescription != null && fieldDescription.trim().length() > 0) {
            buffer.append(fieldDescription);
            buffer.append(ln);
            buffer.append(ln);
        }
        buffer.append("Merkmal: ");
        buffer.append(merkmalName);
        buffer.append(ln);
        if (merkmalType != null && merkmalType.trim().length() > 0) {
            buffer.append("Typ: ");
            buffer.append(merkmalType);
            buffer.append(ln);
        }
        buffer.append("Feldl\u00e4nge: ");
        buffer.append(merkmalLength);
        buffer.append(ln);
        if (merkmalLeerErlaubt) {
            buffer.append("Leer erlaubt");
        } else {
            buffer.append("Leer nicht erlaubt");
        }
        if (merkmalKlasseWertebereichName != null && merkmalKlasseWertebereichName.trim().length() > 0) {
            buffer.append(ln);
            buffer.append("Auspr\u00e4gungsgruppe: ");
            buffer.append(merkmalKlasseWertebereichName);
        }
        if (merkmalMaske != null && merkmalMaske.trim().length() > 0) {
            buffer.append(ln);
            buffer.append("Maske: ");
            buffer.append(merkmalMaske);
        }
        return buffer.toString();
    }

    private void setType(GenericSymbolDescriptor descriptor, int ilType) {
        switch (ilType) {
            case 1: 
            case 5: {
                descriptor.setIsNumeric(true);
                break;
            }
            case 2: {
                descriptor.setIsString(true);
                break;
            }
            case 7: {
                descriptor.setIsBoolean(true);
                break;
            }
            case 3: 
            case 4: {
                descriptor.setIsDate(true);
                break;
            }
            case 6: {
                descriptor.setIsCategory(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unbekannter Typ-Code der Zwischensprache: " + ilType);
            }
        }
    }
}

