/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.support;

import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.MetaCustomAblauf;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.generated.MetaPLAblauf;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import java.util.Iterator;
import java.util.Stack;

public class AblaufIterator
extends AbstractElementVisitor {
    private MetaElement metaElement;
    private CodeBlock myCode;
    private Stack hierachy = new Stack();

    public AblaufIterator(MetaElement metaElement) {
        this.metaElement = metaElement;
    }

    public void eachAblauf(CodeBlock code) {
        assert (this.metaElement != null);
        assert (code != null);
        this.myCode = code;
        this.metaElement.accept(this);
    }

    @Override
    public void visitPlausibilisierung(MetaPlausibilisierung plausi) {
        assert (plausi != null);
        assert (plausi instanceof MetaCustomPlausibilisierung);
        assert (((MetaCustomPlausibilisierung)plausi).rootThemenbereich() != null);
        MetaCustomPlausibilisierung customPlausi = (MetaCustomPlausibilisierung)plausi;
        customPlausi.rootThemenbereich().accept(this);
    }

    @Override
    public void visitThemenbereich(MetaThemenbereich tb) {
        assert (tb != null);
        Iterator it = tb.getAblaeufe();
        while (it.hasNext()) {
            ((MetaElement)it.next()).accept(this);
        }
        it = tb.getFelder();
        while (it.hasNext()) {
            ((MetaElement)it.next()).accept(this);
        }
    }

    @Override
    public void visitTBFeld(MetaTBFeld feld) {
        assert (feld != null);
        if (feld.getKlasse() instanceof MetaThemenbereich) {
            MetaThemenbereich refTb = (MetaThemenbereich)feld.getKlasse();
            this.hierachy.push(feld.getName());
            refTb.accept(this);
            this.hierachy.pop();
        }
    }

    @Override
    public void visitPLAblauf(MetaPLAblauf ablauf) {
        assert (ablauf != null);
        assert (ablauf instanceof MetaCustomAblauf);
        assert (this.myCode != null);
        this.myCode.doForAblauf((MetaCustomAblauf)ablauf, this.createTbHierachy());
    }

    private String createTbHierachy() {
        StringBuffer result = new StringBuffer();
        Iterator it = this.hierachy.iterator();
        while (it.hasNext()) {
            result.append((String)it.next());
            if (!it.hasNext()) continue;
            result.append(".");
        }
        return result.toString();
    }

    public static interface CodeBlock {
        public void doForAblauf(MetaCustomAblauf var1, String var2);
    }
}

