/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import mondrian.olap.Util;

public class ArraySortedSet<E extends Comparable<E>>
extends AbstractSet<E>
implements SortedSet<E>,
Serializable {
    private static final long serialVersionUID = -7613058579094914399L;
    private final E[] values;
    private final int start;
    private final int end;

    public ArraySortedSet(E[] values) {
        this((Comparable[])values, 0, values.length);
    }

    public ArraySortedSet(E[] values, int start, int end) {
        this.values = values;
        this.start = start;
        this.end = end;
    }

    @Override
    public Iterator<E> iterator() {
        return this.asList().iterator();
    }

    @Override
    public int size() {
        return this.end - this.start;
    }

    @Override
    public Comparator<? super E> comparator() {
        return null;
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        int to;
        int from = Util.binarySearch(this.values, (int)this.start, (int)this.end, fromElement);
        if (from < 0) {
            from = -(from + 1);
        }
        if ((to = Util.binarySearch(this.values, (int)from, (int)this.end, toElement)) < 0) {
            to = -(to + 1);
        }
        return this.subset(from, to);
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        int to = Util.binarySearch(this.values, (int)this.start, (int)this.end, toElement);
        if (to < 0) {
            to = -(to + 1);
        }
        return this.subset(this.start, to);
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        int from = Util.binarySearch(this.values, (int)this.start, (int)this.end, fromElement);
        if (from < 0) {
            from = -(from + 1);
        }
        return this.subset(from, this.end);
    }

    private SortedSet<E> subset(int from, int to) {
        if (from == this.start && to == this.end) {
            return this;
        }
        return new ArraySortedSet(this.values, from, to);
    }

    private List<E> asList() {
        List<E> list = Arrays.asList(this.values);
        if (this.start > 0 || this.end < this.values.length) {
            list = list.subList(this.start, this.end);
        }
        return list;
    }

    @Override
    public E first() {
        try {
            return this.values[this.start];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public E last() {
        try {
            return this.values[this.end - 1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public Object[] toArray() {
        if (this.start == 0 && this.end == this.values.length) {
            return (Object[])this.values.clone();
        }
        Object[] os = new Object[this.end - this.start];
        System.arraycopy(this.values, this.start, os, 0, this.end - this.start);
        return os;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size();
        T[] r = a.length >= size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        System.arraycopy(this.values, this.start, r, 0, this.end - this.start);
        if (r.length > size) {
            r[size] = null;
        }
        return r;
    }

    public ArraySortedSet<E> merge(ArraySortedSet<E> arrayToMerge) {
        assert (arrayToMerge != null);
        if (this.size() == 0) {
            return arrayToMerge;
        }
        if (arrayToMerge.size() == 0) {
            return this;
        }
        int p1 = 0;
        int p2 = 0;
        int m = 0;
        int k = this.size() + arrayToMerge.size();
        E[] data1 = this.values;
        E[] data2 = arrayToMerge.values;
        Comparable[] merged = (Comparable[])Util.genericArray(this.values[0].getClass(), k);
        while (p1 < this.size() && p2 < arrayToMerge.size()) {
            int compare = data1[p1].compareTo(data2[p2]);
            if (compare == 0) {
                merged[m++] = data1[p1++];
                ++p2;
                continue;
            }
            if (compare < 0) {
                merged[m++] = data1[p1++];
                continue;
            }
            merged[m++] = data2[p2++];
        }
        while (p1 < this.size()) {
            merged[m++] = data1[p1++];
        }
        while (p2 < arrayToMerge.size()) {
            merged[m++] = data2[p2++];
        }
        return new ArraySortedSet(merged, 0, m);
    }

    @Override
    public boolean contains(Object o) {
        return o != null && Util.binarySearch(this.values, (int)this.start, (int)this.end, (Comparable)((Comparable)o)) >= 0;
    }
}

