/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi.impl;

import java.sql.Connection;
import java.sql.SQLException;
import mondrian.spi.Dialect;
import mondrian.spi.impl.JdbcDialectFactory;
import mondrian.spi.impl.JdbcDialectImpl;

public class InformixDialect
extends JdbcDialectImpl {
    public static final JdbcDialectFactory FACTORY = new JdbcDialectFactory(InformixDialect.class, Dialect.DatabaseProduct.INFORMIX);

    public InformixDialect(Connection connection) throws SQLException {
        super(connection);
    }

    @Override
    public boolean allowsFromQuery() {
        return false;
    }

    @Override
    public String generateOrderItem(String expr, boolean nullable, boolean ascending, boolean collateNullsLast) {
        if (nullable) {
            return this.generateOrderByNullsIDS11(expr, ascending);
        }
        if (ascending) {
            return String.valueOf(expr) + " ASC";
        }
        return String.valueOf(expr) + " DESC";
    }

    @Override
    public boolean supportsGroupByExpressions() {
        return false;
    }

    String generateOrderByNullsIDS11(String expr, boolean ascending) {
        if (ascending) {
            return String.valueOf(expr) + " ASC";
        }
        return String.valueOf(expr) + " DESC";
    }
}

