/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mondrian.rolap.BitKey;
import mondrian.rolap.RolapStar;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.AndPredicate;
import mondrian.rolap.agg.ListPredicate;
import mondrian.rolap.agg.ValueColumnPredicate;
import mondrian.rolap.sql.SqlQuery;

public class OrPredicate
extends ListPredicate {
    public OrPredicate(List<StarPredicate> predicateList) {
        super(predicateList);
    }

    @Override
    public boolean evaluate(List<Object> valueList) {
        for (StarPredicate childPredicate : this.children) {
            if (!childPredicate.evaluate(valueList)) continue;
            return true;
        }
        return false;
    }

    @Override
    public StarPredicate or(StarPredicate predicate) {
        if (predicate instanceof OrPredicate && predicate.getConstrainedColumnBitKey().equals(this.getConstrainedColumnBitKey())) {
            ListPredicate that = (ListPredicate)predicate;
            ArrayList<StarPredicate> list = new ArrayList<StarPredicate>(this.children);
            list.addAll(that.children);
            return new OrPredicate(list);
        }
        ArrayList<StarPredicate> list = new ArrayList<StarPredicate>(this.children);
        list.add(predicate);
        return new OrPredicate(list);
    }

    @Override
    public StarPredicate and(StarPredicate predicate) {
        ArrayList<StarPredicate> list = new ArrayList<StarPredicate>();
        list.add(this);
        list.add(predicate);
        return new AndPredicate(list);
    }

    private void checkInListForPredicate(StarPredicate predicate, SqlQuery sqlQuery, Map<BitKey, List<StarPredicate>> predicateMap) {
        BitKey columnBitKey = this.getConstrainedColumnBitKey();
        BitKey inListRhsBitKey = predicate instanceof ValueColumnPredicate ? ((ValueColumnPredicate)predicate).checkInList(columnBitKey) : (predicate instanceof AndPredicate ? ((AndPredicate)predicate).checkInList(sqlQuery, columnBitKey) : columnBitKey.emptyCopy());
        List<StarPredicate> predicateGroup = predicateMap.get(inListRhsBitKey);
        if (predicateGroup == null) {
            predicateGroup = new ArrayList<StarPredicate>();
            predicateMap.put(inListRhsBitKey, predicateGroup);
        }
        predicateGroup.add(predicate);
    }

    private void checkInList(SqlQuery sqlQuery, Map<BitKey, List<StarPredicate>> predicateMap) {
        for (StarPredicate predicate : this.children) {
            this.checkInListForPredicate(predicate, sqlQuery, predicateMap);
        }
    }

    private void toInListSql(SqlQuery sqlQuery, StringBuilder buf, BitKey inListRhsBitKey, List<StarPredicate> predicateList) {
        boolean multiInList;
        HashMap<Integer, RolapStar.Column> columnMap = new HashMap<Integer, RolapStar.Column>();
        for (RolapStar.Column column : this.columns) {
            columnMap.put(column.getBitPosition(), column);
        }
        buf.append("(");
        boolean firstNullColumnPredicate = true;
        for (Integer colPos : this.getConstrainedColumnBitKey().andNot(inListRhsBitKey)) {
            if (firstNullColumnPredicate) {
                firstNullColumnPredicate = false;
            } else {
                buf.append(" and ");
            }
            String expr = ((RolapStar.Column)columnMap.get(colPos)).generateExprString(sqlQuery);
            buf.append(expr);
            buf.append(" is null");
        }
        if (inListRhsBitKey.isEmpty()) {
            return;
        }
        if (firstNullColumnPredicate) {
            firstNullColumnPredicate = false;
        } else {
            buf.append(" and ");
        }
        boolean bl = multiInList = inListRhsBitKey.toBitSet().cardinality() > 1;
        if (multiInList) {
            buf.append("(");
        }
        boolean firstColumn = true;
        for (Integer colPos : inListRhsBitKey) {
            if (firstColumn) {
                firstColumn = false;
            } else {
                buf.append(", ");
            }
            String expr = ((RolapStar.Column)columnMap.get(colPos)).generateExprString(sqlQuery);
            buf.append(expr);
        }
        if (multiInList) {
            buf.append(")");
        }
        buf.append(" in (");
        boolean firstPredicate = true;
        for (StarPredicate predicate : predicateList) {
            if (firstPredicate) {
                firstPredicate = false;
            } else {
                buf.append(", ");
            }
            if (predicate instanceof AndPredicate) {
                ((AndPredicate)predicate).toInListSql(sqlQuery, buf, inListRhsBitKey);
                continue;
            }
            assert (predicate instanceof ValueColumnPredicate);
            ((ValueColumnPredicate)predicate).toInListSql(sqlQuery, buf);
        }
        buf.append(")");
        buf.append(")");
    }

    @Override
    public void toSql(SqlQuery sqlQuery, StringBuilder buf) {
        LinkedHashMap<BitKey, List<StarPredicate>> predicateMap = new LinkedHashMap<BitKey, List<StarPredicate>>();
        boolean first = true;
        this.checkInList(sqlQuery, predicateMap);
        buf.append("(");
        for (BitKey columnKey : predicateMap.keySet()) {
            List predList = (List)predicateMap.get(columnKey);
            if (columnKey.isEmpty() || predList.size() <= 1) {
                for (StarPredicate pred : predList) {
                    if (first) {
                        first = false;
                    } else {
                        buf.append(" or ");
                    }
                    pred.toSql(sqlQuery, buf);
                }
                continue;
            }
            if (first) {
                first = false;
            } else {
                buf.append(" or ");
            }
            this.toInListSql(sqlQuery, buf, columnKey, predList);
        }
        buf.append(")");
    }

    @Override
    protected String getOp() {
        return "or";
    }
}

