/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.IntegerCalc;
import mondrian.calc.MemberCalc;
import mondrian.calc.impl.AbstractMemberCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.ReflectiveMultiResolver;

class LeadLagFunDef
extends FunDefBase {
    static final ReflectiveMultiResolver LagResolver = new ReflectiveMultiResolver("Lag", "<Member>.Lag(<Numeric Expression>)", "Returns a member further along the specified member's dimension.", new String[]{"mmmn"}, LeadLagFunDef.class);
    static final ReflectiveMultiResolver LeadResolver = new ReflectiveMultiResolver("Lead", "<Member>.Lead(<Numeric Expression>)", "Returns a member further along the specified member's dimension.", new String[]{"mmmn"}, LeadLagFunDef.class);

    public LeadLagFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
        final IntegerCalc integerCalc = compiler.compileInteger(call.getArg(1));
        final boolean lag = call.getFunName().equals("Lag");
        return new AbstractMemberCalc(call, new Calc[]{memberCalc, integerCalc}){

            @Override
            public Member evaluateMember(Evaluator evaluator) {
                Member member = memberCalc.evaluateMember(evaluator);
                int n = integerCalc.evaluateInteger(evaluator);
                if (lag) {
                    if (n == Integer.MIN_VALUE) {
                        ++n;
                    }
                    n = -n;
                }
                return evaluator.getSchemaReader().getLeadMember(member, n);
            }
        };
    }
}

