/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.sapinput.sap;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseFactoryInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.steps.sapinput.SapInputMeta;
import org.pentaho.di.trans.steps.sapinput.sap.SAPConnection;
import org.pentaho.di.trans.steps.sapinput.sap.SAPException;
import org.pentaho.di.trans.steps.sapinput.sap.SAPLibraryTester;
import org.pentaho.di.trans.steps.sapinput.sap.impl.SAPConnectionImpl;

public class SAPConnectionFactory
implements DatabaseFactoryInterface {
    public static SAPConnection create() throws SAPException {
        if (!SAPLibraryTester.isJCoLibAvailable()) {
            String message = BaseMessages.getString(SapInputMeta.class, (String)"SapInputDialog.JCoLibNotFound", (String[])new String[0]);
            throw new SAPException(message);
        }
        if (!SAPLibraryTester.isJCoImplAvailable()) {
            String message = BaseMessages.getString(SapInputMeta.class, (String)"SapInputDialog.JCoImplNotFound", (String[])new String[0]);
            throw new SAPException(message);
        }
        return new SAPConnectionImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConnectionTestReport(DatabaseMeta databaseMeta) throws KettleDatabaseException {
        StringBuffer report = new StringBuffer();
        try (SAPConnection sc = null;){
            sc = SAPConnectionFactory.create();
            sc.open(databaseMeta);
            report.append("Connecting to SAP ERP server [").append(databaseMeta.getName()).append("] succeeded without a problem.").append(Const.CR);
        }
        return report.toString();
    }
}

