/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.delay;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.delay.Delay;
import org.pentaho.di.trans.steps.delay.DelayData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class DelayMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = DelayMeta.class;
    private String timeout;
    private String scaletime;
    public static String DEFAULT_SCALE_TIME = "seconds";
    public String[] ScaleTimeCode = new String[]{"milliseconds", "seconds", "minutes", "hours"};

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("    " + XMLHandler.addTagValue((String)"timeout", (String)this.timeout));
        retval.append("    " + XMLHandler.addTagValue((String)"scaletime", (String)this.scaletime));
        return retval.toString();
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    public String getScaleTime() {
        return this.scaletime;
    }

    public void setScaleTimeCode(int ScaleTimeIndex) {
        switch (ScaleTimeIndex) {
            case 0: {
                this.scaletime = this.ScaleTimeCode[0];
                break;
            }
            case 1: {
                this.scaletime = this.ScaleTimeCode[1];
                break;
            }
            case 2: {
                this.scaletime = this.ScaleTimeCode[2];
                break;
            }
            case 3: {
                this.scaletime = this.ScaleTimeCode[3];
                break;
            }
            default: {
                this.scaletime = this.ScaleTimeCode[1];
            }
        }
    }

    public int getScaleTimeCode() {
        int retval = 1;
        if (this.scaletime == null) {
            return retval;
        }
        if (this.scaletime.equals(this.ScaleTimeCode[0])) {
            retval = 0;
        } else if (this.scaletime.equals(this.ScaleTimeCode[1])) {
            retval = 1;
        } else if (this.scaletime.equals(this.ScaleTimeCode[2])) {
            retval = 2;
        } else if (this.scaletime.equals(this.ScaleTimeCode[3])) {
            retval = 3;
        }
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.timeout = XMLHandler.getTagValue((Node)stepnode, (String)"timeout");
            this.scaletime = XMLHandler.getTagValue((Node)stepnode, (String)"scaletime");
            this.setScaleTimeCode(this.getScaleTimeCode());
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"DelayMeta.Exception.UnableToReadStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.timeout = "1";
        this.scaletime = DEFAULT_SCALE_TIME;
    }

    public String getTimeOut() {
        return this.timeout;
    }

    public void setTimeOut(String timeout) {
        this.timeout = timeout;
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.timeout = rep.getStepAttributeString(id_step, "timeout");
            this.scaletime = rep.getStepAttributeString(id_step, "scaletime");
            this.setScaleTimeCode(this.getScaleTimeCode());
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"DelayMeta.Exception.UnexpectedErrorReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "timeout", this.timeout);
            rep.saveStepAttribute(id_transformation, id_step, "scaletime", this.scaletime);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"DelayMeta.Exception.UnexpectedErrorSavingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        String error_message = "";
        if (Const.isEmpty((String)this.timeout)) {
            error_message = BaseMessages.getString(PKG, (String)"DelayMeta.CheckResult.TimeOutMissing", (String[])new String[0]);
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
        } else {
            error_message = BaseMessages.getString(PKG, (String)"DelayMeta.CheckResult.TimeOutOk", (String[])new String[0]);
            cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepMeta);
        }
        remarks.add((CheckResultInterface)cr);
        cr = prev == null || prev.size() == 0 ? new CheckResult(3, BaseMessages.getString(PKG, (String)"DelayMeta.CheckResult.NotReceivingFields", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"DelayMeta.CheckResult.StepRecevingData", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        cr = input.length > 0 ? new CheckResult(1, BaseMessages.getString(PKG, (String)"DelayMeta.CheckResult.StepRecevingData2", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"DelayMeta.CheckResult.NoInputReceivedFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new Delay(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new DelayData();
    }
}

