/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.pentaho.di.core.SwingUniversalImage;
import org.pentaho.di.core.SwingUniversalImageBitmap;
import org.pentaho.di.core.SwingUniversalImageSvg;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.svg.SvgSupport;
import org.pentaho.di.core.vfs.KettleVFS;

public class SwingSvgImageUtil {
    private static FileObject base;
    private static final String NO_IMAGE = "ui/images/no_image.svg";

    private static SwingUniversalImage getImageAsResourceInternal(String location) {
        SwingUniversalImage result = null;
        if (result == null) {
            result = SwingSvgImageUtil.loadFromCurrentClasspath(location);
        }
        if (result == null) {
            result = SwingSvgImageUtil.loadFromBasedVFS(location);
        }
        if (result == null) {
            result = SwingSvgImageUtil.loadFromSimpleVFS(location);
        }
        return result;
    }

    public static SwingUniversalImage getImageAsResource(String location) {
        SwingUniversalImage result = null;
        if (result == null && SvgSupport.isSvgEnabled()) {
            result = SwingSvgImageUtil.getImageAsResourceInternal(SvgSupport.toSvgName((String)location));
        }
        if (result == null) {
            result = SwingSvgImageUtil.getImageAsResourceInternal(SvgSupport.toPngName((String)location));
        }
        if (result == null && !location.equals(NO_IMAGE)) {
            result = SwingSvgImageUtil.getImageAsResource(NO_IMAGE);
        }
        return result;
    }

    private static SwingUniversalImage getUniversalImageInternal(ClassLoader classLoader, String filename) {
        SwingUniversalImage result = SwingSvgImageUtil.loadFromClassLoader(classLoader, filename);
        if (result == null && (result = SwingSvgImageUtil.loadFromClassLoader(classLoader, "/" + filename)) == null && (result = SwingSvgImageUtil.loadFromClassLoader(classLoader, "ui/images/" + filename)) == null) {
            result = SwingSvgImageUtil.getImageAsResourceInternal(filename);
        }
        return result;
    }

    public static SwingUniversalImage getUniversalImage(ClassLoader classLoader, String filename) {
        if (StringUtils.isBlank((String)filename)) {
            throw new RuntimeException("Filename not provided");
        }
        SwingUniversalImage result = null;
        if (SvgSupport.isSvgEnabled()) {
            result = SwingSvgImageUtil.getUniversalImageInternal(classLoader, SvgSupport.toSvgName((String)filename));
        }
        if (result == null) {
            result = SwingSvgImageUtil.getUniversalImageInternal(classLoader, SvgSupport.toPngName((String)filename));
        }
        if (result == null) {
            result = SwingSvgImageUtil.getImageAsResource(NO_IMAGE);
        }
        return result;
    }

    public static SwingUniversalImage getImage(String location) {
        return SwingSvgImageUtil.getImageAsResource(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SwingUniversalImage loadFromClassLoader(ClassLoader classLoader, String location) {
        InputStream s = classLoader.getResourceAsStream(location);
        if (s == null) {
            return null;
        }
        try {
            SwingUniversalImage swingUniversalImage = SwingSvgImageUtil.loadImage(s, location);
            return swingUniversalImage;
        }
        finally {
            IOUtils.closeQuietly((InputStream)s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SwingUniversalImage loadFromCurrentClasspath(String location) {
        InputStream s;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL res = cl.getResource(location);
        if (res == null) {
            return null;
        }
        try {
            s = res.openStream();
        }
        catch (IOException ex) {
            return null;
        }
        if (s == null) {
            return null;
        }
        try {
            SwingUniversalImage swingUniversalImage = SwingSvgImageUtil.loadImage(s, location);
            return swingUniversalImage;
        }
        finally {
            IOUtils.closeQuietly((InputStream)s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SwingUniversalImage loadFromBasedVFS(String location) {
        SwingUniversalImage swingUniversalImage;
        FileObject imageFileObject = KettleVFS.getInstance().getFileSystemManager().resolveFile(base, location);
        InputStream s = KettleVFS.getInputStream((FileObject)imageFileObject);
        if (s == null) {
            return null;
        }
        try {
            swingUniversalImage = SwingSvgImageUtil.loadImage(s, location);
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeQuietly((InputStream)s);
                throw throwable;
            }
            catch (FileSystemException ex) {
                return null;
            }
        }
        IOUtils.closeQuietly((InputStream)s);
        return swingUniversalImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SwingUniversalImage loadFromSimpleVFS(String location) {
        SwingUniversalImage swingUniversalImage;
        InputStream s = KettleVFS.getInputStream((String)location);
        if (s == null) {
            return null;
        }
        try {
            swingUniversalImage = SwingSvgImageUtil.loadImage(s, location);
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeQuietly((InputStream)s);
                throw throwable;
            }
            catch (KettleFileException kettleFileException) {
                return null;
            }
        }
        IOUtils.closeQuietly((InputStream)s);
        return swingUniversalImage;
    }

    private static SwingUniversalImage loadImage(InputStream in, String filename) {
        if (!SvgSupport.isSvgName((String)filename)) {
            try {
                return new SwingUniversalImageBitmap(ImageIO.read(in));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return new SwingUniversalImageSvg(SvgSupport.loadSvgImage((InputStream)in));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        try {
            base = KettleVFS.getInstance().getFileSystemManager().resolveFile(System.getProperty("user.dir"));
        }
        catch (FileSystemException e) {
            e.printStackTrace();
            base = null;
        }
    }
}

