/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.jdbc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.pentaho.di.core.jdbc.FieldVariableMapping;
import org.pentaho.di.core.sql.ServiceCacheMethod;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.core.xml.XMLInterface;
import org.pentaho.di.repository.ObjectId;
import org.w3c.dom.Node;

@Deprecated
public class TransDataService
implements XMLInterface {
    public static final String XML_TAG_VARIABLE_MAPS = "variable-maps";
    public static final String XML_TAG_VARIABLE_MAP = "variable-map";
    private String name;
    private String fileName;
    private ObjectId objectId;
    private String serviceStepName;
    private List<FieldVariableMapping> fieldVariableMappings;
    private boolean dual;
    private ServiceCacheMethod cacheMethod;

    public TransDataService() {
        this((String)null);
    }

    public TransDataService(String name) {
        this(name, null, null, null, null, ServiceCacheMethod.None);
    }

    public TransDataService(Node serviceNode) {
        this(XMLHandler.getTagValue(serviceNode, "name"), XMLHandler.getTagValue(serviceNode, "filename"), null, XMLHandler.getTagValue(serviceNode, "service_step"), TransDataService.extractFieldVariableMapping(serviceNode), ServiceCacheMethod.None);
    }

    public TransDataService(String name, String fileName, ObjectId objectId, String serviceStepName) {
        this(name, fileName, objectId, serviceStepName, new ArrayList<FieldVariableMapping>(), ServiceCacheMethod.None);
    }

    public TransDataService(String name, String fileName, ObjectId objectId, String serviceStepName, List<FieldVariableMapping> fieldVariableMappings, ServiceCacheMethod cacheMethod) {
        this.name = name;
        this.fileName = fileName;
        this.objectId = objectId;
        this.serviceStepName = serviceStepName;
        this.fieldVariableMappings = fieldVariableMappings;
        this.cacheMethod = cacheMethod;
    }

    private static List<FieldVariableMapping> extractFieldVariableMapping(Node serviceNode) {
        ArrayList<FieldVariableMapping> map = new ArrayList<FieldVariableMapping>();
        List<Node> nodes = XMLHandler.getNodes(XMLHandler.getSubNode(serviceNode, XML_TAG_VARIABLE_MAPS), XML_TAG_VARIABLE_MAP);
        for (Node node : nodes) {
            String field = XMLHandler.getTagValue(node, "field");
            String target = XMLHandler.getTagValue(node, "target");
            String variable = XMLHandler.getTagValue(node, "variable");
            FieldVariableMapping.MappingType mappingType = FieldVariableMapping.MappingType.getMappingType(XMLHandler.getTagValue(node, "type"));
            map.add(new FieldVariableMapping(field, target, variable, mappingType));
        }
        return map;
    }

    @Override
    public String getXML() {
        StringBuilder xml = new StringBuilder();
        xml.append(XMLHandler.addTagValue("name", this.name));
        xml.append(XMLHandler.addTagValue("filename", this.fileName));
        xml.append(XMLHandler.addTagValue("service_step", this.serviceStepName));
        xml.append(XMLHandler.openTag(XML_TAG_VARIABLE_MAPS));
        ArrayList<FieldVariableMapping> list = new ArrayList<FieldVariableMapping>(this.fieldVariableMappings);
        Collections.sort(list, new Comparator<FieldVariableMapping>(){

            @Override
            public int compare(FieldVariableMapping o1, FieldVariableMapping o2) {
                return o1.getFieldName().compareTo(o2.getFieldName());
            }
        });
        for (FieldVariableMapping mapping : list) {
            xml.append(XMLHandler.openTag(XML_TAG_VARIABLE_MAP));
            xml.append(XMLHandler.addTagValue("field", mapping.getFieldName()));
            xml.append(XMLHandler.addTagValue("variable", mapping.getVariableName()));
            xml.append(XMLHandler.addTagValue("type", mapping.getMappingType().name()));
            xml.append(XMLHandler.closeTag(XML_TAG_VARIABLE_MAP));
        }
        xml.append(XMLHandler.closeTag(XML_TAG_VARIABLE_MAPS));
        return xml.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getServiceStepName() {
        return this.serviceStepName;
    }

    public void setServiceStepName(String serviceStepName) {
        this.serviceStepName = serviceStepName;
    }

    public boolean isDual() {
        return this.dual;
    }

    public void setDual(boolean dual) {
        this.dual = dual;
    }

    public List<FieldVariableMapping> getFieldVariableMappings() {
        return this.fieldVariableMappings;
    }

    public void setFieldVariableMappings(List<FieldVariableMapping> fieldVariableMappings) {
        this.fieldVariableMappings = fieldVariableMappings;
    }

    public ObjectId getObjectId() {
        return this.objectId;
    }

    public void setObjectId(ObjectId objectId) {
        this.objectId = objectId;
    }

    public ServiceCacheMethod getCacheMethod() {
        return this.cacheMethod;
    }

    public void setCacheMethod(ServiceCacheMethod cacheMethod) {
        this.cacheMethod = cacheMethod;
    }
}

