/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.util.Stack;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.util.StyledTextListWriter;
import net.sf.jasperreports.export.pdf.PdfProducer;
import net.sf.jasperreports.export.pdf.PdfStructure;
import net.sf.jasperreports.export.pdf.PdfStructureEntry;
import net.sf.jasperreports.export.type.AccessibilityTagEnum;

public class JRPdfExporterTagHelper
implements StyledTextListWriter {
    public static final String PROPERTY_TAG_TABLE = "net.sf.jasperreports.export.pdf.tag.table";
    public static final String PROPERTY_TAG_TR = "net.sf.jasperreports.export.pdf.tag.tr";
    public static final String PROPERTY_TAG_TH = "net.sf.jasperreports.export.pdf.tag.th";
    public static final String PROPERTY_TAG_TD = "net.sf.jasperreports.export.pdf.tag.td";
    public static final String PROPERTY_TAG_L = "net.sf.jasperreports.export.pdf.tag.l";
    public static final String PROPERTY_TAG_LI = "net.sf.jasperreports.export.pdf.tag.li";
    public static final String PROPERTY_TAG_H1 = "net.sf.jasperreports.export.pdf.tag.h1";
    public static final String PROPERTY_TAG_H2 = "net.sf.jasperreports.export.pdf.tag.h2";
    public static final String PROPERTY_TAG_H3 = "net.sf.jasperreports.export.pdf.tag.h3";
    public static final String PROPERTY_TAG_H4 = "net.sf.jasperreports.export.pdf.tag.h4";
    public static final String PROPERTY_TAG_H5 = "net.sf.jasperreports.export.pdf.tag.h5";
    public static final String PROPERTY_TAG_H6 = "net.sf.jasperreports.export.pdf.tag.h6";
    public static final String PROPERTY_TAG_COLSPAN = "net.sf.jasperreports.export.pdf.tag.colspan";
    public static final String PROPERTY_TAG_ROWSPAN = "net.sf.jasperreports.export.pdf.tag.rowspan";
    public static final String TAG_START = "start";
    public static final String TAG_END = "end";
    public static final String TAG_FULL = "full";
    protected JRPdfExporter exporter;
    protected PdfProducer pdfProducer;
    protected PdfStructure pdfStructure;
    protected PdfStructureEntry allTag;
    protected Stack<PdfStructureEntry> tagStack;
    protected boolean isTagEmpty = true;
    protected int crtCrosstabRowY = -1;
    protected boolean insideCrosstabCellFrame;
    protected boolean isDataCellPrinted;
    protected boolean isTagged;
    protected String language;

    protected JRPdfExporterTagHelper(JRPdfExporter exporter) {
        this.exporter = exporter;
    }

    protected void setTagged(boolean isTagged) {
        this.isTagged = isTagged;
    }

    protected void setLanguage(String language) {
        this.language = language;
    }

    protected void setPdfProducer(PdfProducer pdfProducer) {
        this.pdfProducer = pdfProducer;
        this.pdfStructure = pdfProducer.getPdfStructure();
        if (this.isTagged) {
            pdfProducer.setTagged();
        }
    }

    protected void init() {
        if (this.isTagged) {
            this.allTag = this.pdfStructure.createAllTag(this.language);
            this.tagStack = new Stack();
            this.tagStack.push(this.allTag);
        }
    }

    protected void startPageAnchor() {
        if (this.isTagged) {
            this.pdfStructure.beginTag(this.allTag, "Anchor");
        }
    }

    protected void endPageAnchor() {
        if (this.isTagged) {
            this.pdfStructure.endTag();
        }
    }

    protected void startPage() {
        this.crtCrosstabRowY = -1;
        this.insideCrosstabCellFrame = false;
        this.isDataCellPrinted = false;
    }

    protected void endPage() {
        if (this.isTagged && this.crtCrosstabRowY >= 0) {
            this.tagStack.pop();
            this.tagStack.pop();
        }
    }

    protected void startElement(JRPrintElement element) {
        if (this.isTagged) {
            boolean isCellContentsFrame;
            JRPrintFrame frame = element instanceof JRPrintFrame ? (JRPrintFrame)element : null;
            boolean bl = isCellContentsFrame = frame != null && frame.getPropertiesMap().hasProperties() && frame.getPropertiesMap().getProperty("net.sf.jasperreports.crosstab.cell.type") != null;
            if (isCellContentsFrame) {
                this.insideCrosstabCellFrame = true;
                if (this.crtCrosstabRowY >= 0) {
                    if ("Data".equals(frame.getPropertiesMap().getProperty("net.sf.jasperreports.crosstab.cell.type"))) {
                        this.isDataCellPrinted = true;
                    }
                    if (this.crtCrosstabRowY != frame.getY()) {
                        this.tagStack.pop();
                        if (this.isDataCellPrinted && ("CrosstabHeader".equals(frame.getPropertiesMap().getProperty("net.sf.jasperreports.crosstab.cell.type")) || "ColumnHeader".equals(frame.getPropertiesMap().getProperty("net.sf.jasperreports.crosstab.cell.type")))) {
                            this.tagStack.pop();
                            this.createTableStartTag();
                            this.isDataCellPrinted = false;
                        }
                        this.createTrStartTag();
                        this.crtCrosstabRowY = frame.getY();
                    }
                } else {
                    this.createTableStartTag();
                    this.createTrStartTag();
                    this.crtCrosstabRowY = frame.getY();
                    this.isDataCellPrinted = false;
                }
            } else if (this.crtCrosstabRowY >= 0 && !this.insideCrosstabCellFrame) {
                this.tagStack.pop();
                this.tagStack.pop();
                this.crtCrosstabRowY = -1;
            }
            this.createStartTags(element);
        }
    }

    protected void endElement(JRPrintElement element) {
        if (this.isTagged) {
            boolean isCellContentsFrame;
            JRPrintFrame frame = element instanceof JRPrintFrame ? (JRPrintFrame)element : null;
            boolean bl = isCellContentsFrame = frame != null && frame.getPropertiesMap().hasProperties() && frame.getPropertiesMap().getProperty("net.sf.jasperreports.crosstab.cell.type") != null;
            if (isCellContentsFrame) {
                this.insideCrosstabCellFrame = false;
            }
            this.createEndTags(element);
        }
    }

    protected void startImage(JRPrintImage printImage) {
        if (this.isTagged) {
            PdfStructureEntry imageTag = this.pdfStructure.beginTag(this.allTag, "Image");
            if (printImage.getHyperlinkTooltip() != null) {
                imageTag.putString("Alt", printImage.getHyperlinkTooltip());
            }
        }
    }

    protected void endImage() {
        if (this.isTagged) {
            this.pdfStructure.endTag();
        }
    }

    protected void startText(boolean isHyperlink) {
        if (this.isTagged) {
            this.pdfStructure.beginTag(this.tagStack.peek(), isHyperlink ? "Link" : "Text");
        }
    }

    protected void startText(String text, boolean isHyperlink) {
        if (this.isTagged) {
            this.pdfStructure.beginTag(this.tagStack.peek(), isHyperlink ? "Link" : "Text", text);
        }
    }

    protected void endText() {
        if (this.isTagged) {
            this.pdfStructure.endTag();
            this.isTagEmpty = false;
        }
    }

    protected void createStartTags(JRPrintElement element) {
        if (element.hasProperties()) {
            String prop = element.getPropertiesMap().getProperty(PROPERTY_TAG_TABLE);
            if (TAG_START.equals(prop) || TAG_FULL.equals(prop)) {
                this.createTableStartTag();
            }
            if (TAG_START.equals(prop = element.getPropertiesMap().getProperty(PROPERTY_TAG_TR)) || TAG_FULL.equals(prop)) {
                this.createTrStartTag();
            }
            if (TAG_START.equals(prop = element.getPropertiesMap().getProperty(PROPERTY_TAG_TH)) || TAG_FULL.equals(prop)) {
                this.createThStartTag(element);
            }
            if (TAG_START.equals(prop = element.getPropertiesMap().getProperty(PROPERTY_TAG_TD)) || TAG_FULL.equals(prop)) {
                this.createTdStartTag(element);
            }
            if ("CrosstabHeader".equals(prop = element.getPropertiesMap().getProperty("net.sf.jasperreports.crosstab.cell.type")) || "ColumnHeader".equals(prop) || "RowHeader".equals(prop)) {
                this.createThStartTag(element);
            }
            if ("Data".equals(prop)) {
                this.createTdStartTag(element);
            }
            if (TAG_START.equals(prop = element.getPropertiesMap().getProperty(PROPERTY_TAG_L)) || TAG_FULL.equals(prop)) {
                this.createListStartTag();
            }
            if (TAG_START.equals(prop = element.getPropertiesMap().getProperty(PROPERTY_TAG_LI)) || TAG_FULL.equals(prop)) {
                this.createListItemStartTag(element);
            }
            this.createStartHeadingTags(element, PROPERTY_TAG_H1, AccessibilityTagEnum.H1);
            this.createStartHeadingTags(element, PROPERTY_TAG_H2, AccessibilityTagEnum.H2);
            this.createStartHeadingTags(element, PROPERTY_TAG_H3, AccessibilityTagEnum.H3);
            this.createStartHeadingTags(element, PROPERTY_TAG_H4, AccessibilityTagEnum.H4);
            this.createStartHeadingTags(element, PROPERTY_TAG_H5, AccessibilityTagEnum.H5);
            this.createStartHeadingTags(element, PROPERTY_TAG_H6, AccessibilityTagEnum.H6);
        }
    }

    protected void createStartHeadingTags(JRPrintElement element, String pdfTagProp, AccessibilityTagEnum accessibilityTag) {
        String accessibilityTagPropValue = element.getPropertiesMap().getProperty("net.sf.jasperreports.export.accessibility.tag");
        String pdfTagPropValue = element.getPropertiesMap().getProperty(pdfTagProp);
        if (accessibilityTag.getName().equals(accessibilityTagPropValue) || TAG_START.equals(pdfTagPropValue) || TAG_FULL.equals(pdfTagPropValue)) {
            PdfStructureEntry headingTag = this.pdfStructure.createTag(this.tagStack.peek(), accessibilityTag.name());
            headingTag.putArray("K");
            this.tagStack.push(headingTag);
            this.isTagEmpty = true;
        }
    }

    protected void createTableStartTag() {
        PdfStructureEntry tableTag = this.pdfStructure.createTag(this.allTag, "Table");
        tableTag.putArray("K");
        this.tagStack.push(tableTag);
    }

    protected void createTrStartTag() {
        PdfStructureEntry tableRowTag = this.pdfStructure.createTag(this.tagStack.peek(), "TR");
        tableRowTag.putArray("K");
        this.tagStack.push(tableRowTag);
    }

    protected void createThStartTag(JRPrintElement element) {
        PdfStructureEntry tableHeaderTag = this.pdfStructure.createTag(this.tagStack.peek(), "TH");
        tableHeaderTag.putArray("K");
        this.tagStack.push(tableHeaderTag);
        this.isTagEmpty = true;
        this.createSpanTags(element, tableHeaderTag);
    }

    protected void createTdStartTag(JRPrintElement element) {
        PdfStructureEntry tableCellTag = this.pdfStructure.createTag(this.tagStack.peek(), "TD");
        tableCellTag.putArray("K");
        this.tagStack.push(tableCellTag);
        this.isTagEmpty = true;
        this.createSpanTags(element, tableCellTag);
    }

    protected void createSpanTags(JRPrintElement element, PdfStructureEntry parentTag) {
        String rowSpanProp2;
        String colSpanProp2;
        Integer colSpan = null;
        try {
            colSpanProp2 = element.getPropertiesMap().getProperty(PROPERTY_TAG_COLSPAN);
            if (colSpanProp2 != null) {
                colSpan = Integer.valueOf(colSpanProp2);
            }
        }
        catch (NumberFormatException colSpanProp2) {
            // empty catch block
        }
        if (colSpan == null) {
            try {
                colSpanProp2 = element.getPropertiesMap().getProperty("net.sf.jasperreports.crosstab.cell.column.span");
                if (colSpanProp2 != null) {
                    colSpan = Integer.valueOf(colSpanProp2);
                }
            }
            catch (NumberFormatException colSpanProp3) {
                // empty catch block
            }
        }
        Integer rowSpan = null;
        try {
            rowSpanProp2 = element.getPropertiesMap().getProperty(PROPERTY_TAG_ROWSPAN);
            if (rowSpanProp2 != null) {
                rowSpan = Integer.valueOf(rowSpanProp2);
            }
        }
        catch (NumberFormatException rowSpanProp2) {
            // empty catch block
        }
        if (rowSpan == null) {
            try {
                rowSpanProp2 = element.getPropertiesMap().getProperty("net.sf.jasperreports.crosstab.cell.row.span");
                if (rowSpanProp2 != null) {
                    rowSpan = Integer.valueOf(rowSpanProp2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (colSpan != null && colSpan > 1 || rowSpan != null && rowSpan > 1) {
            parentTag.setSpan(colSpan == null ? 0 : colSpan, rowSpan == null ? 0 : rowSpan);
        }
    }

    protected void createListStartTag() {
        PdfStructureEntry listTag = this.pdfStructure.createTag(this.tagStack.peek(), "L");
        listTag.putArray("K");
        this.tagStack.push(listTag);
    }

    protected void createListItemStartTag(JRPrintElement element) {
        PdfStructureEntry listItemTag = this.pdfStructure.createTag(this.tagStack.peek(), "LI");
        listItemTag.putArray("K");
        this.tagStack.push(listItemTag);
        this.isTagEmpty = true;
    }

    protected void createEndTags(JRPrintElement element) {
        if (element.hasProperties()) {
            this.createEndHeadingTags(element, PROPERTY_TAG_H6, AccessibilityTagEnum.H6);
            this.createEndHeadingTags(element, PROPERTY_TAG_H5, AccessibilityTagEnum.H5);
            this.createEndHeadingTags(element, PROPERTY_TAG_H4, AccessibilityTagEnum.H4);
            this.createEndHeadingTags(element, PROPERTY_TAG_H3, AccessibilityTagEnum.H3);
            this.createEndHeadingTags(element, PROPERTY_TAG_H2, AccessibilityTagEnum.H2);
            this.createEndHeadingTags(element, PROPERTY_TAG_H1, AccessibilityTagEnum.H1);
            String prop = element.getPropertiesMap().getProperty(PROPERTY_TAG_LI);
            if (TAG_END.equals(prop) || TAG_FULL.equals(prop)) {
                if (this.isTagEmpty) {
                    this.pdfStructure.beginTag(this.tagStack.peek(), "Span");
                    this.pdfStructure.endTag();
                }
                this.tagStack.pop();
            }
            if (TAG_END.equals(prop = element.getPropertiesMap().getProperty(PROPERTY_TAG_L)) || TAG_FULL.equals(prop)) {
                this.tagStack.pop();
            }
            if ((prop = element.getPropertiesMap().getProperty("net.sf.jasperreports.crosstab.cell.type")) != null && ("CrosstabHeader".equals(prop) || "ColumnHeader".equals(prop) || "RowHeader".equals(prop) || "Data".equals(prop))) {
                if (this.isTagEmpty) {
                    this.pdfStructure.beginTag(this.tagStack.peek(), "Span");
                    this.pdfStructure.endTag();
                }
                this.tagStack.pop();
            }
            if (TAG_END.equals(prop = element.getPropertiesMap().getProperty(PROPERTY_TAG_TD)) || TAG_FULL.equals(prop)) {
                if (this.isTagEmpty) {
                    this.pdfStructure.beginTag(this.tagStack.peek(), "Span");
                    this.pdfStructure.endTag();
                }
                this.tagStack.pop();
            }
            if (TAG_END.equals(prop = element.getPropertiesMap().getProperty(PROPERTY_TAG_TH)) || TAG_FULL.equals(prop)) {
                if (this.isTagEmpty) {
                    this.pdfStructure.beginTag(this.tagStack.peek(), "Span");
                    this.pdfStructure.endTag();
                }
                this.tagStack.pop();
            }
            if (TAG_END.equals(prop = element.getPropertiesMap().getProperty(PROPERTY_TAG_TR)) || TAG_FULL.equals(prop)) {
                this.tagStack.pop();
            }
            if (TAG_END.equals(prop = element.getPropertiesMap().getProperty(PROPERTY_TAG_TABLE)) || TAG_FULL.equals(prop)) {
                this.tagStack.pop();
            }
        }
    }

    protected void createEndHeadingTags(JRPrintElement element, String pdfTagProp, AccessibilityTagEnum accessibilityTag) {
        String accessibilityTagPropValue = element.getPropertiesMap().getProperty("net.sf.jasperreports.export.accessibility.tag");
        String pdfTagPropValue = element.getPropertiesMap().getProperty(pdfTagProp);
        if (accessibilityTag.getName().equals(accessibilityTagPropValue) || TAG_END.equals(pdfTagPropValue) || TAG_FULL.equals(pdfTagPropValue)) {
            if (this.isTagEmpty) {
                this.pdfStructure.beginTag(this.tagStack.peek(), "Span");
                this.pdfStructure.endTag();
            }
            this.tagStack.pop();
        }
    }

    @Override
    public void startUl() {
        this.createListStartTag();
    }

    @Override
    public void endUl() {
        this.tagStack.pop();
    }

    @Override
    public void startOl(String type, int cutStart) {
        this.createListStartTag();
    }

    @Override
    public void endOl() {
        this.tagStack.pop();
    }

    @Override
    public void startLi(boolean noBullet) {
        this.createListItemStartTag(null);
    }

    @Override
    public void endLi() {
        if (this.isTagEmpty) {
            this.pdfStructure.beginTag(this.tagStack.peek(), "Span");
            this.pdfStructure.endTag();
        }
        this.tagStack.pop();
    }

    protected StyledTextListWriter getListWriter() {
        return this.isTagged ? this : null;
    }
}

