/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.font.TextAttribute;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRStyleContainer;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.util.JRTextAttribute;
import net.sf.jasperreports.engine.util.StyleResolver;

public class JRBaseFont
implements JRFont,
Serializable,
JRChangeEventsSupport,
JRCloneable {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_BOLD = "isBold";
    public static final String PROPERTY_FONT_NAME = "fontName";
    public static final String PROPERTY_FONT_SIZE = "fontSize";
    public static final String PROPERTY_ITALIC = "isItalic";
    public static final String PROPERTY_PDF_EMBEDDED = "isPdfEmbedded";
    public static final String PROPERTY_PDF_ENCODING = "pdfEncoding";
    public static final String PROPERTY_PDF_FONT_NAME = "pdfFontName";
    public static final String PROPERTY_REPORT_FONT = "reportFont";
    public static final String PROPERTY_STRIKE_THROUGH = "isStrikeThrough";
    public static final String PROPERTY_UNDERLINE = "isUnderline";
    protected JRStyleContainer styleContainer;
    protected JRStyle style;
    protected String styleNameReference;
    protected String fontName;
    protected Boolean isBold;
    protected Boolean isItalic;
    protected Boolean isUnderline;
    protected Boolean isStrikeThrough;
    protected Float fontsize;
    protected String pdfFontName;
    protected String pdfEncoding;
    protected Boolean isPdfEmbedded;
    private transient JRPropertyChangeSupport eventSupport;
    private int PSEUDO_SERIAL_VERSION_UID = 62100;
    private Integer fontSize;

    public JRBaseFont() {
    }

    public JRBaseFont(Map<AttributedCharacterIterator.Attribute, Object> attributes) {
        Boolean isPdfEmbeddedAttr;
        String pdfEncodingAttr;
        String pdfFontNameAttr;
        Object strikeThrough;
        Object underline;
        Float sizeAttr;
        Object italic;
        Object bold;
        String fontNameAttr = (String)attributes.get(TextAttribute.FAMILY);
        if (fontNameAttr != null) {
            this.setFontName(fontNameAttr);
        }
        if ((bold = attributes.get(TextAttribute.WEIGHT)) != null) {
            this.setBold(TextAttribute.WEIGHT_BOLD.equals(bold));
        }
        if ((italic = attributes.get(TextAttribute.POSTURE)) != null) {
            this.setItalic(TextAttribute.POSTURE_OBLIQUE.equals(italic));
        }
        if ((sizeAttr = (Float)attributes.get(TextAttribute.SIZE)) != null) {
            this.setFontSize(sizeAttr);
        }
        if ((underline = attributes.get(TextAttribute.UNDERLINE)) != null) {
            this.setUnderline(TextAttribute.UNDERLINE_ON.equals(underline));
        }
        if ((strikeThrough = attributes.get(TextAttribute.STRIKETHROUGH)) != null) {
            this.setStrikeThrough(TextAttribute.STRIKETHROUGH_ON.equals(strikeThrough));
        }
        if ((pdfFontNameAttr = (String)attributes.get(JRTextAttribute.PDF_FONT_NAME)) != null) {
            this.setPdfFontName(pdfFontNameAttr);
        }
        if ((pdfEncodingAttr = (String)attributes.get(JRTextAttribute.PDF_ENCODING)) != null) {
            this.setPdfEncoding(pdfEncodingAttr);
        }
        if ((isPdfEmbeddedAttr = (Boolean)attributes.get(JRTextAttribute.IS_PDF_EMBEDDED)) != null) {
            this.setPdfEmbedded(isPdfEmbeddedAttr);
        }
    }

    public JRBaseFont(JRStyleContainer styleContainer) {
        this.styleContainer = styleContainer;
    }

    public JRBaseFont(JRStyleContainer styleContainer, JRFont font) {
        this(styleContainer);
        if (font != null) {
            this.fontName = font.getOwnFontName();
            this.isBold = font.isOwnBold();
            this.isItalic = font.isOwnItalic();
            this.isUnderline = font.isOwnUnderline();
            this.isStrikeThrough = font.isOwnStrikeThrough();
            this.fontsize = font.getOwnFontsize();
            this.pdfFontName = font.getOwnPdfFontName();
            this.pdfEncoding = font.getOwnPdfEncoding();
            this.isPdfEmbedded = font.isOwnPdfEmbedded();
        }
    }

    public JRBaseFont(JRStyleContainer styleContainer, JRFont font, JRAbstractObjectFactory factory) {
        factory.put(font, this);
        this.styleContainer = styleContainer;
        this.style = factory.getStyle(font.getStyle());
        this.styleNameReference = font.getStyleNameReference();
        this.fontName = font.getOwnFontName();
        this.isBold = font.isOwnBold();
        this.isItalic = font.isOwnItalic();
        this.isUnderline = font.isOwnUnderline();
        this.isStrikeThrough = font.isOwnStrikeThrough();
        this.fontsize = font.getOwnFontsize();
        this.pdfFontName = font.getOwnPdfFontName();
        this.pdfEncoding = font.getOwnPdfEncoding();
        this.isPdfEmbedded = font.isOwnPdfEmbedded();
    }

    @Override
    public JRDefaultStyleProvider getDefaultStyleProvider() {
        return this.styleContainer == null ? null : this.styleContainer.getDefaultStyleProvider();
    }

    protected StyleResolver getStyleResolver() {
        if (this.getDefaultStyleProvider() != null) {
            return this.getDefaultStyleProvider().getStyleResolver();
        }
        return StyleResolver.getInstance();
    }

    @Override
    public JRStyle getStyle() {
        return this.style == null ? (this.styleContainer == null ? null : this.styleContainer.getStyle()) : this.style;
    }

    @Override
    public String getStyleNameReference() {
        return this.styleNameReference == null ? (this.styleContainer == null ? null : this.styleContainer.getStyleNameReference()) : this.styleNameReference;
    }

    @Override
    public String getFontName() {
        return this.getStyleResolver().getFontName(this);
    }

    @Override
    public String getOwnFontName() {
        return this.fontName;
    }

    @Override
    public void setFontName(String fontName) {
        String old = this.fontName;
        this.fontName = fontName;
        this.getEventSupport().firePropertyChange(PROPERTY_FONT_NAME, old, this.fontName);
    }

    @Override
    public boolean isBold() {
        return this.getStyleResolver().isBold(this);
    }

    @Override
    public Boolean isOwnBold() {
        return this.isBold;
    }

    @Override
    public void setBold(Boolean isBold) {
        Boolean old = this.isBold;
        this.isBold = isBold;
        this.getEventSupport().firePropertyChange(PROPERTY_BOLD, old, this.isBold);
    }

    @Override
    public boolean isItalic() {
        return this.getStyleResolver().isItalic(this);
    }

    @Override
    public Boolean isOwnItalic() {
        return this.isItalic;
    }

    @Override
    public void setItalic(Boolean isItalic) {
        Boolean old = this.isItalic;
        this.isItalic = isItalic;
        this.getEventSupport().firePropertyChange(PROPERTY_ITALIC, old, this.isItalic);
    }

    @Override
    public boolean isUnderline() {
        return this.getStyleResolver().isUnderline(this);
    }

    @Override
    public Boolean isOwnUnderline() {
        return this.isUnderline;
    }

    @Override
    public void setUnderline(Boolean isUnderline) {
        Boolean old = this.isUnderline;
        this.isUnderline = isUnderline;
        this.getEventSupport().firePropertyChange(PROPERTY_UNDERLINE, old, this.isUnderline);
    }

    @Override
    public boolean isStrikeThrough() {
        return this.getStyleResolver().isStrikeThrough(this);
    }

    @Override
    public Boolean isOwnStrikeThrough() {
        return this.isStrikeThrough;
    }

    @Override
    public void setStrikeThrough(Boolean isStrikeThrough) {
        Boolean old = this.isStrikeThrough;
        this.isStrikeThrough = isStrikeThrough;
        this.getEventSupport().firePropertyChange(PROPERTY_STRIKE_THROUGH, old, this.isStrikeThrough);
    }

    @Override
    public float getFontsize() {
        return this.getStyleResolver().getFontsize(this);
    }

    @Override
    public Float getOwnFontsize() {
        return this.fontsize;
    }

    @Override
    public void setFontSize(Float fontSize) {
        Float old = this.fontsize;
        this.fontsize = fontSize;
        this.getEventSupport().firePropertyChange(PROPERTY_FONT_SIZE, old, this.fontsize);
    }

    @Override
    public String getPdfFontName() {
        return this.getStyleResolver().getPdfFontName(this);
    }

    @Override
    public String getOwnPdfFontName() {
        return this.pdfFontName;
    }

    @Override
    public void setPdfFontName(String pdfFontName) {
        String old = this.pdfFontName;
        this.pdfFontName = pdfFontName;
        this.getEventSupport().firePropertyChange(PROPERTY_PDF_FONT_NAME, old, this.pdfFontName);
    }

    @Override
    public String getPdfEncoding() {
        return this.getStyleResolver().getPdfEncoding(this);
    }

    @Override
    public String getOwnPdfEncoding() {
        return this.pdfEncoding;
    }

    @Override
    public void setPdfEncoding(String pdfEncoding) {
        String old = this.pdfEncoding;
        this.pdfEncoding = pdfEncoding;
        this.getEventSupport().firePropertyChange(PROPERTY_PDF_ENCODING, old, this.pdfEncoding);
    }

    @Override
    public boolean isPdfEmbedded() {
        return this.getStyleResolver().isPdfEmbedded(this);
    }

    @Override
    public Boolean isOwnPdfEmbedded() {
        return this.isPdfEmbedded;
    }

    @Override
    public void setPdfEmbedded(Boolean isPdfEmbedded) {
        Boolean old = this.isPdfEmbedded;
        this.isPdfEmbedded = isPdfEmbedded;
        this.getEventSupport().firePropertyChange(PROPERTY_PDF_EMBEDDED, old, this.isPdfEmbedded);
    }

    @Override
    public Object clone() {
        JRBaseFont clone = null;
        try {
            clone = (JRBaseFont)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
        clone.eventSupport = null;
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JRPropertyChangeSupport getEventSupport() {
        JRBaseFont jRBaseFont = this;
        synchronized (jRBaseFont) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 50502) {
            this.fontsize = this.fontSize == null ? null : Float.valueOf(this.fontSize.floatValue());
            this.fontSize = null;
        }
    }
}

