/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.inspector.util;

import de.statspez.sdf.generator.meta.MetaCustomSDFMerkmal;

public class InspectionHelper {
    public static final char DEFAULT_DECIMAL_CHAR = ',';
    public static final char DEFAULT_THOUSEND_DIV_CHAR = '.';

    public static boolean isNumeric(String string) {
        boolean numeric;
        if (string != null && string.length() > 0) {
            numeric = true;
            char[] chars = string.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if (Character.isDigit(chars[i])) continue;
                numeric = false;
                break;
            }
        } else {
            numeric = false;
        }
        return numeric;
    }

    public static String getNormalizedValue(String value, MetaCustomSDFMerkmal feature, char decimalChar, char thousendDivChar) {
        String normalizedValue = value;
        if (normalizedValue != null && normalizedValue.length() > 0) {
            boolean number;
            boolean specialString = feature.getTyp() == 2 || feature.getTyp() == 3;
            boolean bl = number = feature.getTyp() == 4 || feature.getTyp() == 5 || feature.getTyp() == 7 || feature.getTyp() == 6;
            if (specialString || number) {
                StringBuffer buffer = new StringBuffer(normalizedValue.length());
                char[] chars = normalizedValue.toCharArray();
                boolean whitespace = false;
                block3: for (char c : chars) {
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            if (feature.getTyp() == 2) {
                                buffer.append(' ');
                                continue block3;
                            }
                            if (number && (decimalChar == c || thousendDivChar == c)) {
                                if (c == decimalChar) {
                                    buffer.append(',');
                                    continue block3;
                                }
                                if (c != thousendDivChar) continue block3;
                                buffer.append('.');
                                continue block3;
                            }
                            if (buffer.length() <= 0) continue block3;
                            whitespace = true;
                            continue block3;
                        }
                        default: {
                            if (whitespace) {
                                buffer.append(' ');
                                whitespace = false;
                            }
                            if (number && (decimalChar != ',' || thousendDivChar != '.')) {
                                if (c == decimalChar) {
                                    buffer.append(',');
                                    continue block3;
                                }
                                if (c == thousendDivChar) {
                                    buffer.append('.');
                                    continue block3;
                                }
                                buffer.append(c);
                                continue block3;
                            }
                            buffer.append(c);
                        }
                    }
                }
                normalizedValue = buffer.toString();
            }
        }
        return normalizedValue;
    }
}

