/*
 * Decompiled with CFR 0.152.
 */
package de.his.tools;

import de.his.tools.FileUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.IllegalDataException;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class XMLUtil {
    private static final String encoding = "UTF-8";
    private static Logger logger = Logger.getLogger(XMLUtil.class);
    private static String confroot = null;

    public static List<Element> getChildren(Element elem) {
        return elem.getChildren();
    }

    public static List<Element> getChildren(Element elem, String childrenName) throws NullPointerException {
        if (elem != null) {
            return elem.getChildren(childrenName);
        }
        return null;
    }

    public static boolean isActive(Element e) {
        String activeStr;
        boolean active = true;
        if (e != null && (activeStr = e.getAttributeValue("active")) != null && activeStr.toLowerCase().equals("n")) {
            active = false;
        }
        return active;
    }

    public static Element getElementFromFile(String fileName) {
        Element element = null;
        Document document = XMLUtil.getDocumentFromFile(fileName, true);
        if (document != null) {
            element = document.getRootElement();
        }
        return element;
    }

    protected static Document getDocumentFromFile(String fileName, boolean useChroot) {
        Document document = null;
        File file = new File(fileName);
        if ((!useChroot || FileUtil.checkChroot(confroot, fileName)) && file.isFile()) {
            SAXBuilder builder = new SAXBuilder();
            try {
                document = builder.build(file);
            }
            catch (JDOMException e) {
                logger.error((Object)("Fehler bei " + fileName + ": "), (Throwable)e);
            }
            catch (IllegalDataException e) {
                logger.error((Object)("Fehler bei " + fileName + ": "), (Throwable)e);
            }
            catch (IOException e) {
                logger.error((Object)("Fehler bei " + fileName + ": "), (Throwable)e);
            }
        }
        return document;
    }

    public static void setConfroot(String confroot) {
        XMLUtil.confroot = confroot;
    }

    public static Element parseXML(String xml) {
        if (xml == null) {
            return null;
        }
        Element res = null;
        SAXBuilder builder = new SAXBuilder(false);
        try {
            res = builder.build((Reader)new StringReader(xml)).getRootElement();
        }
        catch (JDOMException e) {
            logger.error((Object)e, (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e, (Throwable)e);
        }
        return res;
    }

    public static Element parseXML(Reader xml) {
        if (xml == null) {
            return null;
        }
        Element res = null;
        SAXBuilder builder = new SAXBuilder(false);
        try {
            res = builder.build(xml).getRootElement();
        }
        catch (JDOMException e) {
            logger.error((Object)e, (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e, (Throwable)e);
        }
        return res;
    }

    public static String dumpXML(Element element) {
        return XMLUtil.dumpXML(element, "    ", encoding);
    }

    public static String dumpXML(Element element, String indent, String charset) {
        String res = "";
        if (element != null) {
            Element ele = (Element)element.clone();
            Document doc = new Document(ele);
            try {
                Format format = Format.getPrettyFormat();
                format.setEncoding(charset);
                format.setIndent(indent);
                XMLOutputter out = new XMLOutputter(format);
                StringWriter sw = new StringWriter();
                BufferedWriter bw = new BufferedWriter(sw);
                out.output(doc, (Writer)bw);
                bw.close();
                res = sw.toString();
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        return res;
    }
}

