/*
 * Decompiled with CFR 0.152.
 */
package de.his.tools;

import de.his.otherlicence.md5crypt.MD5Crypt;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.apache.log4j.Logger;

public class MDFiveHash {
    private static final String MD_INSTANCE_NAME = "MD5";
    private static final String SALT_PREFIX = "$apr1$";
    private static final String SALT_CHARS = "./0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[64];
    private static Logger logger;

    public static String getHex(byte[] hash) {
        StringBuffer buf = new StringBuffer(hash.length * 2);
        for (int i = 0; i < hash.length; ++i) {
            if ((hash[i] & 0xFF) < 16) {
                buf.append("0");
            }
            buf.append(Long.toString(hash[i] & 0xFF, 16));
        }
        return buf.toString();
    }

    public static String hash(byte[] data) {
        return MDFiveHash.hash(data, 0, data.length);
    }

    public static String hash(byte[] data, int offset, int length) {
        byte[] result = EMPTY_BYTE_ARRAY;
        try {
            MessageDigest md = MessageDigest.getInstance(MD_INSTANCE_NAME);
            md.reset();
            md.update(data, offset, length);
            byte[] rslt = md.digest();
            result = rslt;
        }
        catch (Exception ee) {
            logger.error((Object)ee, (Throwable)ee);
        }
        return MDFiveHash.getHex(result);
    }

    public static String hash(String arg) {
        try {
            return MDFiveHash.hash(arg.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String hashWithSalt(String password) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        StringBuilder salt = new StringBuilder("");
        int step = SALT_CHARS.length();
        SecureRandom generator = new SecureRandom();
        for (int i = 0; i < 8; ++i) {
            int sign = generator.nextInt(step);
            salt.append(SALT_CHARS.substring(sign, sign + 1));
        }
        return MDFiveHash.hashWithSalt(password, salt.toString());
    }

    public static String hashWithSalt(String password, String salt) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        byte[] saltBytes = salt.getBytes("UTF-8");
        byte[] passwordBytes = password.getBytes("UTF-8");
        MD5Crypt md5Crypt = new MD5Crypt(SALT_PREFIX);
        return new String(md5Crypt.crypt(passwordBytes, saltBytes)).trim();
    }

    public static boolean compareSaltedHash(String hash, String password) {
        if (hash == null || hash.trim().equals("") || password == null || password.trim().equals("")) {
            return false;
        }
        if (hash.length() < SALT_PREFIX.length()) {
            return false;
        }
        String salt = hash.substring(SALT_PREFIX.length());
        int pos = salt.indexOf(36);
        if (pos < 0) {
            return false;
        }
        salt = salt.substring(0, pos);
        try {
            String newHash = MDFiveHash.hashWithSalt(password, salt);
            return newHash.equals(hash);
        }
        catch (Exception e) {
            logger.error((Object)"Fehler beim Hashen des Passworts: ", (Throwable)e);
            return false;
        }
    }

    static {
        for (int i = 0; i < EMPTY_BYTE_ARRAY.length; ++i) {
            MDFiveHash.EMPTY_BYTE_ARRAY[i] = 0;
        }
        logger = Logger.getLogger(MDFiveHash.class);
    }
}

