/*
 * Decompiled with CFR 0.152.
 */
package de.his.security.auth.plugin;

import de.his.security.auth.AuthenticationManagerConfig;
import de.his.security.auth.plugin.AuthenticationPlugin;
import de.his.tools.HttpClient;
import de.his.tools.StringUtil;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import net.sf.sojo.interchange.json.JsonParser;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class FacebookAuth
implements AuthenticationPlugin {
    private static Logger logger = Logger.getLogger(FacebookAuth.class);

    @Override
    public boolean init(AuthenticationManagerConfig authConfig, Element confElement) {
        logger.debug((Object)("AuthPlugin: " + this.getClass()));
        return true;
    }

    @Override
    public Properties authTest(Element confElement, Properties authProp, HttpServletRequest request, Properties userProp) {
        if (request == null) {
            return userProp;
        }
        String code = request.getParameter("code");
        if (code == null) {
            return userProp;
        }
        String redirectUrl = request.getRequestURL().toString();
        String accessToken = this.requestAccessToken(confElement, code, redirectUrl);
        userProp.putAll((Map<?, ?>)this.getUserInformation(confElement, accessToken));
        return userProp;
    }

    private String requestAccessToken(Element confElement, String code, String redirectUrl) {
        StringBuilder url = new StringBuilder();
        url.append("https://graph.facebook.com/oauth/access_token?client_id=");
        url.append(StringUtil.encodeURL(confElement.getChildTextTrim("appid")));
        url.append("'&client_secret=");
        url.append(StringUtil.encodeURL(confElement.getChildTextTrim("appsecret")));
        url.append("'&redirect_uri=");
        url.append(StringUtil.encodeURL(redirectUrl));
        url.append("'&code=");
        url.append(StringUtil.encodeURL(code));
        HttpClient client = new HttpClient(url.toString());
        String res = client.fetchString();
        return res.substring(res.indexOf("=") + 1);
    }

    private Map getUserInformation(Element confElement, String accessToken) {
        StringBuilder url = new StringBuilder();
        url.append("https://graph.facebook.com/me?fields=");
        url.append(StringUtil.encodeURL(confElement.getChildTextTrim("fields")));
        url.append("&access_token=");
        url.append(StringUtil.encodeURL(accessToken));
        HttpClient client = new HttpClient(url.toString());
        String res = client.fetchString();
        JsonParser parser = new JsonParser();
        Object result = parser.parse(res);
        return (Map)result;
    }
}

