/*
 * Decompiled with CFR 0.152.
 */
package de.his.security.auth.passwordevent;

import de.his.security.auth.AuthenticationManagerConfig;
import de.his.security.auth.passwordevent.PasswordEvent;
import de.his.security.auth.plugin.AuthenticationPlugin;
import de.his.tools.StringUtil;
import de.his.tools.SystemUtil;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class ExternalCommand
implements PasswordEvent,
AuthenticationPlugin {
    private static Logger logger = Logger.getLogger(ExternalCommand.class);

    @Override
    public boolean init(AuthenticationManagerConfig authConfig, Element confElement) {
        return true;
    }

    @Override
    public Properties authTest(Element confElement, Properties authProp, HttpServletRequest request, Properties userProp) {
        Properties prop = (Properties)authProp.clone();
        prop.putAll((Map<?, ?>)userProp);
        this.executeCommand(confElement, prop, new LinkedList<String>());
        return userProp;
    }

    @Override
    public void notify(Element pluginElement, Element notifyElement, Properties authProps, List<String> res) {
        this.executeCommand(notifyElement, authProps, res);
    }

    private void executeCommand(Element configuration, Properties authProps, List<String> res) {
        String command = configuration.getChildText("command");
        String input = configuration.getChildText("input");
        String charset = configuration.getChildText("charset");
        if (charset == null) {
            charset = "UTF-8";
        }
        try {
            Process process = Runtime.getRuntime().exec(StringUtil.argsubst(command, authProps));
            if (input != null) {
                String replacedInput = StringUtil.argsubst(input, authProps);
                process.getOutputStream().write(replacedInput.getBytes());
                process.getOutputStream().close();
            }
            SystemUtil.logOutput(process);
        }
        catch (IOException e) {
            logger.error((Object)e, (Throwable)e);
            res.add("password_fatal_external");
        }
        catch (InterruptedException e) {
            logger.error((Object)e, (Throwable)e);
            res.add("password_fatal_external");
        }
    }
}

