/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.servlets;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.sql.Connection;
import java.util.HashMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.config.DbFormsConfig;
import org.dbforms.config.DbFormsConfigRegistry;
import org.dbforms.event.WebEvent;
import org.dbforms.servlets.reports.JRDataSourceAbstract;
import org.dbforms.servlets.reports.ReportParameter;
import org.dbforms.servlets.reports.ReportServletAbstract;
import org.dbforms.servlets.reports.ReportWriter;
import org.dbforms.util.ParseUtil;
import org.dbforms.util.SqlUtil;
import org.dbforms.util.external.FileUtil;

public class JasperReportServlet
extends ReportServletAbstract {
    private static Log logCat = LogFactory.getLog((String)(class$org$dbforms$servlets$JasperReportServlet == null ? (class$org$dbforms$servlets$JasperReportServlet = JasperReportServlet.class$("org.dbforms.servlets.JasperReportServlet")) : class$org$dbforms$servlets$JasperReportServlet).getName());
    private static final String REPORTFILEEXTENSION = ".jrxml";
    private static final String REPORTNAMEPARAM = "reportname";
    private static final String REPORTTYPEPARAM = "reporttype";
    static /* synthetic */ Class class$org$dbforms$servlets$JasperReportServlet;

    protected String getReportFileExtension() {
        return REPORTFILEEXTENSION;
    }

    protected void compileReport(ServletContext context, String reportFile) throws Exception {
        logCat.info((Object)("=== user dir " + FileUtil.dirname(reportFile)));
        System.setProperty("user.dir", FileUtil.dirname(reportFile));
        File dir = FileUtil.getFile(FileUtil.dirname(reportFile));
        File[] list = dir.listFiles();
        for (int i = 0; i < list.length; ++i) {
            String s = FileUtil.removeExtension(list[i].getPath());
            String ext = "." + FileUtil.getExtension(list[i].getPath());
            if (!s.startsWith(reportFile) || !ext.equals(this.getReportFileExtension())) continue;
            File xmlFile = list[i];
            File jasperFile = FileUtil.getFile(s + ".jasper");
            if (jasperFile.exists() && xmlFile.lastModified() <= jasperFile.lastModified()) continue;
            this.compileJasper(context, xmlFile.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReportWriter processReport(String reportFileFullName, JRDataSourceAbstract dataSource, ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        ReportWriter res = new ReportWriter();
        try {
            DbFormsConfig config = null;
            try {
                config = DbFormsConfigRegistry.instance().lookup();
            }
            catch (Exception e) {
                logCat.error((Object)"processReport", (Throwable)e);
                throw new ServletException((Throwable)e);
            }
            try {
                JasperPrint jPrint = null;
                WebEvent webEvent = (WebEvent)request.getAttribute("webEvent");
                Connection con = null;
                con = webEvent != null && webEvent.getTable() == null ? config.getConnection() : config.getConnection(JasperReportServlet.getConnectionName(request));
                try {
                    ReportParameter repParam = new ReportParameter(context, request, dataSource.getAttributes(), con, FileUtil.dirname(reportFileFullName) + File.separator);
                    HashMap<String, ReportParameter> map = new HashMap<String, ReportParameter>();
                    map.put("PARAM", repParam);
                    jPrint = JasperFillManager.fillReport((String)(reportFileFullName + ".jasper"), map, (JRDataSource)dataSource);
                }
                catch (Exception e) {
                    logCat.error((Object)"processReport", (Throwable)e);
                }
                finally {
                    SqlUtil.closeConnection(con);
                }
                if (jPrint == null || jPrint.getPages().size() == 0) {
                    return null;
                }
                String outputFormat = ParseUtil.getParameter(request, REPORTTYPEPARAM, "PDF");
                String fName = "";
                if ("PDF".equals(outputFormat)) {
                    res.mimeType = "application/pdf";
                    res.data = this.exportToPDF(jPrint);
                    fName = FileUtil.filename(reportFileFullName) + ".pdf";
                } else if ("XLS".equals(outputFormat)) {
                    res.mimeType = "application/msexcel";
                    res.data = this.exportToXLS(jPrint);
                    fName = FileUtil.filename(reportFileFullName) + ".xls";
                } else if ("CSV".equalsIgnoreCase(outputFormat)) {
                    res.mimeType = "text/comma-separated-values";
                    res.data = this.exportToCSV(jPrint);
                    fName = FileUtil.filename(reportFileFullName) + ".csv";
                }
                res.fileName = ParseUtil.getParameter(request, REPORTNAMEPARAM, fName);
                jPrint = null;
                return res;
            }
            catch (JRException e) {
                logCat.error((Object)"processReport", (Throwable)e);
                this.handleException(request, response, (Exception)((Object)e));
                return null;
            }
        }
        catch (Exception e) {
            this.handleException(request, response, e);
            return null;
        }
    }

    private static String getConnectionName(HttpServletRequest request) {
        WebEvent webEvent = (WebEvent)request.getAttribute("webEvent");
        String res = null;
        if (webEvent != null && webEvent.getTable().getId() != -1) {
            res = ParseUtil.getParameter(request, "invname_" + webEvent.getTable().getId());
        }
        return res;
    }

    private void compileJasper(ServletContext context, String reportFile) throws Exception {
        logCat.info((Object)("=== start to compile " + reportFile));
        String classpath = (String)context.getAttribute("org.apache.catalina.jsp_classpath");
        logCat.info((Object)("=== used classpath " + classpath));
        System.setProperty("jasper.reports.compile.class.path", classpath);
        try {
            JasperCompileManager.compileReportToFile((String)reportFile);
        }
        catch (Exception e) {
            logCat.error((Object)"compile", (Throwable)e);
            throw e;
        }
    }

    private ByteArrayOutputStream exportToCSV(JasperPrint jasperPrint) throws JRException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JRCsvExporter exporter = new JRCsvExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)baos);
        exporter.exportReport();
        return baos;
    }

    private ByteArrayOutputStream exportToPDF(JasperPrint jasperPrint) throws JRException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JRPdfExporter exporter = new JRPdfExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)baos);
        exporter.exportReport();
        return baos;
    }

    private ByteArrayOutputStream exportToXLS(JasperPrint jasperPrint) throws JRException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JRXlsExporter exporter = new JRXlsExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)baos);
        exporter.exportReport();
        return baos;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

