/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.conprovider;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.conprovider.ConnectionProvider;
import org.dbforms.util.Util;

public class JakartaConnectionProvider
extends ConnectionProvider {
    protected static final String CP_PROPS_VALIDATION_QUERY = "validationQuery";
    protected static final String CP_PROPS_MAX_ACTIVE = "maxActive";
    protected static final String CP_PROPS_MAX_IDLE = "maxIdle";
    protected static final String CP_PROPS_MAX_WAIT = "maxWait";
    protected static final String CP_PROPS_USE_LOG = "useLog";
    private static Log logCat = LogFactory.getLog((Class)(class$org$dbforms$conprovider$JakartaConnectionProvider == null ? (class$org$dbforms$conprovider$JakartaConnectionProvider = JakartaConnectionProvider.class$("org.dbforms.conprovider.JakartaConnectionProvider")) : class$org$dbforms$conprovider$JakartaConnectionProvider));
    private BasicDataSource dataSource = null;
    static /* synthetic */ Class class$org$dbforms$conprovider$JakartaConnectionProvider;

    protected Connection getConnection() throws SQLException {
        logCat.debug((Object)("::getConnection - MaxActive = " + this.dataSource.getMaxActive()));
        logCat.debug((Object)("::getConnection - NumActive = " + this.dataSource.getNumActive()));
        logCat.debug((Object)("::getConnection - NumIdle   = " + this.dataSource.getNumIdle()));
        return this.dataSource.getConnection();
    }

    protected void init() throws Exception {
        String validationQuery;
        Properties props = null;
        this.dataSource = new BasicDataSource();
        this.dataSource.setDriverClassName(this.getPrefs().getJdbcDriver());
        this.dataSource.setUrl(this.getPrefs().getJdbcURL());
        this.dataSource.setUsername(this.getPrefs().getUser());
        this.dataSource.setPassword(this.getPrefs().getPassword());
        props = this.getPrefs().getProperties();
        if (props != null) {
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                this.dataSource.addConnectionProperty(key, props.getProperty(key));
                logCat.info((Object)("::init - dataSource property [" + key + "] = [" + props.getProperty(key) + "]"));
            }
        }
        if ((props = this.getPrefs().getPoolProperties()) == null) {
            props = new Properties();
        }
        if (!Util.isNull(validationQuery = props.getProperty(CP_PROPS_VALIDATION_QUERY, null))) {
            this.dataSource.setValidationQuery(validationQuery.trim());
        }
        this.dataSource.setMaxActive(Integer.parseInt(props.getProperty(CP_PROPS_MAX_ACTIVE, "20")));
        this.dataSource.setMaxIdle(Integer.parseInt(props.getProperty(CP_PROPS_MAX_IDLE, "5")));
        this.dataSource.setMaxWait(Long.parseLong(props.getProperty(CP_PROPS_MAX_WAIT, "-1")));
        String useLog = props.getProperty(CP_PROPS_USE_LOG, "false");
        if (!Util.isNull(useLog) && "true".equals(useLog.trim())) {
            logCat.info((Object)"::init - dataSource log activated");
            this.dataSource.setLogWriter((PrintWriter)new Log4jPrintWriter());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Log4jPrintWriter
    extends PrintWriter {
        private StringBuffer text = new StringBuffer("");

        public Log4jPrintWriter() {
            super(System.err);
        }

        public void close() {
            this.flush();
        }

        public void flush() {
            if (!this.text.toString().equals("")) {
                logCat.info((Object)this.text.toString());
                this.text.setLength(0);
            }
        }

        public void print(boolean b) {
            this.text.append(b);
        }

        public void print(char c) {
            this.text.append(c);
        }

        public void print(char[] s) {
            this.text.append(s);
        }

        public void print(double d) {
            this.text.append(d);
        }

        public void print(float f) {
            this.text.append(f);
        }

        public void print(int i) {
            this.text.append(i);
        }

        public void print(long l) {
            this.text.append(l);
        }

        public void print(Object obj) {
            this.text.append(obj);
        }

        public void print(String s) {
            this.text.append(s);
        }

        public void println() {
            this.flush();
        }

        public void println(boolean x) {
            this.text.append(x);
            this.flush();
        }

        public void println(char x) {
            this.text.append(x);
            this.flush();
        }

        public void println(char[] x) {
            this.text.append(x);
            this.flush();
        }

        public void println(double x) {
            this.text.append(x);
            this.flush();
        }

        public void println(float x) {
            this.text.append(x);
            this.flush();
        }

        public void println(int x) {
            this.text.append(x);
            this.flush();
        }

        public void println(long x) {
            this.text.append(x);
            this.flush();
        }

        public void println(Object x) {
            this.text.append(x);
            this.flush();
        }

        public void println(String x) {
            this.text.append(x);
            this.flush();
        }
    }
}

