/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.resource;

import de.destatis.core.resource.Resource;
import de.destatis.core.resource.ResourceException;
import de.statspez.sdf.generator.meta.generated.MetaSDFMetabeschreibung;
import de.statspez.sdf.generator.parser.SDFMetaParser;
import java.io.IOException;
import java.io.Reader;

public class SDFMetaResource
extends Resource {
    private MetaSDFMetabeschreibung sdfMetaBeschreibung;

    public SDFMetaResource(String resourceId, byte[] resourceData) {
        super(resourceId, resourceData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaSDFMetabeschreibung getSdfMetaBeschreibung() throws ResourceException {
        if (this.sdfMetaBeschreibung == null) {
            Reader reader = null;
            try {
                reader = this.getReader();
                SDFMetaParser parser = new SDFMetaParser();
                parser.setCheckNamespace(false);
                parser.setSDFGlobalNamespace(true);
                try {
                    MetaSDFMetabeschreibung tmpSdfMetaBeschreibung = parser.parse(reader);
                    String metaBeschreibungResourceId = tmpSdfMetaBeschreibung.getProzedurCode();
                    String resourceResourceId = this.getResourceId();
                    if (metaBeschreibungResourceId == null || !metaBeschreibungResourceId.equals(resourceResourceId)) {
                        throw new ResourceException("Inkonsistente Ressource! Die RessourceID '" + metaBeschreibungResourceId + "' der Metadatenbeschreibung passt nicht zur RessourceID '" + resourceResourceId + "' der Ressource.");
                    }
                    this.sdfMetaBeschreibung = tmpSdfMetaBeschreibung;
                }
                catch (Exception e) {
                    throw new ResourceException(e);
                }
                try {
                    reader.close();
                    reader = null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        return this.sdfMetaBeschreibung;
    }

    @Override
    protected String getEncoding() {
        return "ISO-8859-1";
    }
}

