/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map.editor.wizard;

import de.destatis.core.map.editor.util.SwingUtil;
import de.destatis.core.map.editor.util.ui.TableSorter;
import de.destatis.core.map.editor.wizard.AbstractStep;
import de.destatis.core.resource.util.DatMlRawVersion;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.SystemColor;
import java.text.Collator;
import java.util.List;
import java.util.Locale;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class SelectDatMlRawVersionStep
extends AbstractStep {
    private JTable datMlRawVersionTable;
    private List datMlRawVersionList = null;

    public SelectDatMlRawVersionStep() {
        super(new BorderLayout());
        TableSorter tableSorter = new TableSorter(new DatMlRawVersionTableModel());
        this.datMlRawVersionTable = new JTable(tableSorter);
        tableSorter.setTableHeader(this.datMlRawVersionTable.getTableHeader());
        tableSorter.setColumnComparator(String.class, Collator.getInstance(Locale.GERMAN));
        this.datMlRawVersionTable.getTableHeader().setReorderingAllowed(false);
        this.datMlRawVersionTable.setAutoResizeMode(4);
        this.datMlRawVersionTable.setGridColor(SystemColor.control);
        this.datMlRawVersionTable.setRowHeight(18);
        this.datMlRawVersionTable.getSelectionModel().setSelectionMode(0);
        this.datMlRawVersionTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SelectDatMlRawVersionStep.this.fireStateChanged();
            }
        });
        SwingUtil.removeUunnecessaryActionsFromTable(this.datMlRawVersionTable);
        JScrollPane scrollPane = new JScrollPane(this.datMlRawVersionTable);
        scrollPane.getViewport().setBackground(this.datMlRawVersionTable.getBackground());
        this.add((Component)scrollPane, "Center");
    }

    public void setDatMlRawVersions(List datMlRawVersions) {
        this.datMlRawVersionList = datMlRawVersions;
        ((AbstractTableModel)((TableSorter)this.datMlRawVersionTable.getModel()).getTableModel()).fireTableDataChanged();
    }

    @Override
    public String getInfo() {
        return "W\u00e4hlen Sie die DatML/RAW-Version aus, f\u00fcr welche das neue Mapping erstellt werden soll.";
    }

    @Override
    public String getTitle() {
        return "DatML/RAW-Version ausw\u00e4hlen";
    }

    @Override
    public boolean isComplete() {
        return this.datMlRawVersionTable.getSelectedRow() >= 0;
    }

    public DatMlRawVersion getSelectedMetaBeschreibung() {
        int selectedRow = this.datMlRawVersionTable.getSelectedRow();
        int modelIndex = ((TableSorter)this.datMlRawVersionTable.getModel()).modelIndex(selectedRow);
        DatMlRawVersion result = (DatMlRawVersion)this.datMlRawVersionList.get(modelIndex);
        return result;
    }

    private class DatMlRawVersionTableModel
    extends AbstractTableModel {
        private DatMlRawVersionTableModel() {
        }

        public Class getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return DatMlRawVersion.class;
                }
            }
            throw new IllegalArgumentException("column=" + columnIndex);
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "DatML/RAW-Version";
                }
            }
            throw new IllegalArgumentException("column=" + column);
        }

        @Override
        public int getRowCount() {
            return SelectDatMlRawVersionStep.this.datMlRawVersionList != null ? SelectDatMlRawVersionStep.this.datMlRawVersionList.size() : 0;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            DatMlRawVersion datMlRawVersion = this.getDatMlRawVersion(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return datMlRawVersion;
                }
            }
            throw new IllegalArgumentException("columnIndex=" + columnIndex);
        }

        private DatMlRawVersion getDatMlRawVersion(int row) {
            return (DatMlRawVersion)SelectDatMlRawVersionStep.this.datMlRawVersionList.get(row);
        }
    }
}

