/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map.editor.util;

import java.lang.reflect.Method;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public abstract class SetValueUndoableEdit
extends AbstractUndoableEdit {
    protected Object object;
    private Method setMethod;
    private Object oldValue;
    private Object newValue;

    public SetValueUndoableEdit(Object object, String setMethodName, Class valueClass, Object oldValue, Object newValue) {
        this.object = object;
        try {
            this.setMethod = this.object.getClass().getMethod(setMethodName, valueClass);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        try {
            this.setMethod.invoke(this.object, this.oldValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        try {
            this.setMethod.invoke(this.object, this.newValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

