/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map.editor.task;

import de.destatis.core.map.editor.IconFactory;
import de.destatis.core.map.editor.task.ProgressMonitor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class ProgressDialog
extends JDialog
implements ProgressMonitor {
    private JLabel taskTitleBar;
    private JLabel subTaskTitleBar;
    private JProgressBar progressBar;
    private boolean canceled;

    public ProgressDialog(Dialog parent, String taskTitle, boolean userCanCancel) {
        super(parent, "Fortschrittsanzeige", true);
        this.initUI(taskTitle, userCanCancel);
    }

    public ProgressDialog(Frame parent, String taskTitle, boolean userCanCancel) {
        super(parent, "Fortschrittsanzeige", true);
        this.initUI(taskTitle, userCanCancel);
    }

    private void initUI(String taskTitle, boolean userCanCancel) {
        this.canceled = false;
        this.taskTitleBar = new JLabel(taskTitle);
        this.taskTitleBar.setFont(this.taskTitleBar.getFont().deriveFont(1));
        this.subTaskTitleBar = new JLabel(" ");
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setBackground(Color.white);
        topPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, SystemColor.controlShadow));
        JPanel infoPanel = new JPanel(new BorderLayout(5, 5));
        infoPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        infoPanel.setOpaque(false);
        infoPanel.add((Component)this.taskTitleBar, "North");
        infoPanel.add((Component)this.subTaskTitleBar, "Center");
        topPanel.add((Component)infoPanel, "Center");
        topPanel.add((Component)new JLabel(IconFactory.getIcon("banner.png")), "East");
        this.getContentPane().add((Component)topPanel, "North");
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        this.progressBar.setMaximum(100);
        this.progressBar.setPreferredSize(new Dimension(400, 15));
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        contentPanel.add((Component)this.progressBar, "Center");
        this.getContentPane().add((Component)contentPanel, "Center");
        if (userCanCancel) {
            final JButton button = new JButton("Abbrechen");
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    button.setEnabled(false);
                    ProgressDialog.this.cancel();
                }
            });
            JPanel buttonPanel = new JPanel(new FlowLayout(2, 5, 0));
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 10, 5));
            buttonPanel.add(button);
            this.getContentPane().add((Component)buttonPanel, "South");
            this.enableEvents(201L);
        }
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void cancel() {
        this.canceled = true;
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public void started() {
        this.setVisible(true);
    }

    @Override
    public void processing(final String process) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ProgressDialog.this.subTaskTitleBar.setText(process);
            }
        };
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeLater(runnable);
            }
            catch (Exception exception) {}
        } else {
            runnable.run();
        }
    }

    @Override
    public void processed(final double percent) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (ProgressDialog.this.progressBar.isIndeterminate()) {
                    ProgressDialog.this.progressBar.setIndeterminate(false);
                }
                ProgressDialog.this.progressBar.setValue((int)Math.round(percent * 100.0));
            }
        };
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeLater(runnable);
            }
            catch (Exception e) {}
        } else {
            runnable.run();
        }
    }

    @Override
    public void finished() {
        this.processed(1.0);
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Thread.yield();
        this.setVisible(false);
    }

    @Override
    public void failed() {
        this.setVisible(false);
    }

    @Override
    protected void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.cancel();
        }
    }
}

