/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map;

import de.destatis.core.map.Binding;
import de.destatis.core.map.FieldSetBinding;
import de.destatis.core.map.editor.Icons;
import de.destatis.core.map.model.BindingGroupImpl;
import de.destatis.core.map.model.HelpFeatureConfigValue;
import de.destatis.core.map.model.SelectorBinding;
import java.util.Date;
import java.util.Iterator;

public class Mapping
extends BindingGroupImpl {
    private String name;
    private String customName;
    private HelpFeatureConfigValue helpFeatureConfig;
    private Date creationDate;

    public Mapping(String resourceId, String name) {
        super(resourceId);
        this.name = name;
        this.helpFeatureConfig = HelpFeatureConfigValue.getDefaultValue();
        this.setIcon(Icons.ICON_SURVEY);
        this.creationDate = new Date();
    }

    @Override
    public String getPrettyName() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public Date getCreationDate() {
        if (this.creationDate == null) {
            this.creationDate = new Date();
        }
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public HelpFeatureConfigValue getHelpFeatureConfig() {
        if (this.helpFeatureConfig == null) {
            this.helpFeatureConfig = HelpFeatureConfigValue.getDefaultValue();
        }
        return this.helpFeatureConfig;
    }

    public void setHelpFeatureConfig(HelpFeatureConfigValue helpFeatureConfig) {
        this.helpFeatureConfig = helpFeatureConfig;
    }

    public FieldSetBinding getFieldSetBindingWithName(String name) {
        FieldSetBinding result = null;
        Iterator it = this.getBindings();
        while (it.hasNext()) {
            Binding binding = (Binding)it.next();
            if (!(binding instanceof FieldSetBinding) || !name.equals(binding.getId())) continue;
            result = (FieldSetBinding)binding;
            break;
        }
        return result;
    }

    public SelectorBinding getSelectorBindingWithName(String name) {
        SelectorBinding result = null;
        Iterator it = this.getBindings();
        while (it.hasNext()) {
            Binding binding = (Binding)it.next();
            if (!(binding instanceof SelectorBinding) || !name.equals(binding.getId())) continue;
            result = (SelectorBinding)binding;
            break;
        }
        return result;
    }
}

