/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.connect;

import de.destatis.core.connect.IncompleteRequestException;
import de.destatis.core.connect.Request;
import de.destatis.core.connect.document.DatMLRawDocument;
import de.destatis.core.connect.util.Contract;

public class DataDelivery
extends Request {
    private DatMLRawDocument data = null;
    private String fileName;

    public DataDelivery() {
    }

    public DataDelivery(DatMLRawDocument data) {
        this(data, null);
    }

    public DataDelivery(DatMLRawDocument data, String fileName) {
        this.setFileName(fileName);
        this.setData(data);
    }

    public DatMLRawDocument getData() {
        return this.data;
    }

    public void setData(DatMLRawDocument data) {
        Contract.verify(data != null && data.isDocumentSet(), "Kein DatML/RAW-Dokument angegeben");
        this.data = data;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public void check() throws IncompleteRequestException {
        String message = null;
        if (this.data == null) {
            message = "Kein DatML/RAW-Dokument angegeben!";
        } else if (!this.data.isDocumentSet()) {
            message = "Das enthaltene DatML/RAW-Dokument ist leer!";
        }
        if (message != null) {
            throw new IncompleteRequestException(message);
        }
    }
}

