/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.registry.entities;

import com.atlassian.clover.api.registry.BranchInfo;
import com.atlassian.clover.api.registry.EntityContainer;
import com.atlassian.clover.api.registry.FileInfo;
import com.atlassian.clover.api.registry.SourceInfo;
import com.atlassian.clover.context.ContextSet;
import com.atlassian.clover.io.tags.TaggedDataInput;
import com.atlassian.clover.io.tags.TaggedDataOutput;
import com.atlassian.clover.io.tags.TaggedPersistent;
import com.atlassian.clover.lang.Languages;
import com.atlassian.clover.registry.CoverageDataProvider;
import com.atlassian.clover.registry.FixedSourceRegion;
import com.atlassian.clover.registry.entities.BasicBranchInfo;
import com.atlassian.clover.registry.entities.FullElementInfo;
import com.atlassian.clover.registry.entities.FullMethodInfo;
import com.atlassian.clover.spi.lang.LanguageConstruct;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullBranchInfo
extends FullElementInfo<BasicBranchInfo>
implements TaggedPersistent,
BranchInfo {
    private transient FullMethodInfo containingMethod;

    public FullBranchInfo(FullMethodInfo containingMethod, int relativeDataIndex, com.atlassian.clover.api.registry.ContextSet context, SourceInfo region, int complexity, boolean instrumented) {
        this(containingMethod, relativeDataIndex, context, region, complexity, instrumented, LanguageConstruct.Builtin.BRANCH);
    }

    public FullBranchInfo(FullMethodInfo containingMethod, int relativeDataIndex, com.atlassian.clover.api.registry.ContextSet context, SourceInfo region, int complexity, boolean instrumented, LanguageConstruct construct) {
        this(containingMethod, context, new BasicBranchInfo(region, relativeDataIndex, complexity, instrumented, construct));
    }

    private FullBranchInfo(FullMethodInfo containingMethod, com.atlassian.clover.api.registry.ContextSet context, BasicBranchInfo sharedInfo) {
        super(context, sharedInfo);
        this.containingMethod = containingMethod;
    }

    @Override
    public int getTrueHitCount() {
        return super.getHitCount();
    }

    @Override
    public int getFalseHitCount() {
        CoverageDataProvider data = this.getDataProvider();
        if (data == null) {
            return 0;
        }
        return data.getHitCount(this.getDataIndex() + 1);
    }

    @Override
    public EntityContainer getParent() {
        return this.containingMethod;
    }

    @Override
    public boolean isInstrumented() {
        return ((BasicBranchInfo)this.sharedInfo).isInstrumented();
    }

    public FullBranchInfo copy(FullMethodInfo method) {
        return new FullBranchInfo(method, this.context, (BasicBranchInfo)this.sharedInfo);
    }

    @Override
    public void setDataProvider(CoverageDataProvider data) {
        throw new UnsupportedOperationException("setDataProvider not supported on FullBranchInfo");
    }

    @Override
    public CoverageDataProvider getDataProvider() {
        return this.containingMethod.getDataProvider();
    }

    @Override
    public int getDataLength() {
        return 2;
    }

    void setContainingMethod(FullMethodInfo methodInfo) {
        this.containingMethod = methodInfo;
    }

    @Override
    @Nullable
    public FileInfo getContainingFile() {
        return this.containingMethod.getContainingFile();
    }

    public String toString() {
        return "FullBranchInfo{sharedInfo=" + this.sharedInfo + ", context=" + this.context + '}';
    }

    @Override
    public void write(TaggedDataOutput out) throws IOException {
        out.write(ContextSet.class, (ContextSet)this.context);
        out.writeInt(((BasicBranchInfo)this.sharedInfo).getRelativeDataIndex());
        out.writeInt(this.getComplexity());
        out.writeUTF(((BasicBranchInfo)this.sharedInfo).getConstruct().getId());
        out.writeBoolean(((BasicBranchInfo)this.sharedInfo).isInstrumented());
        FixedSourceRegion.writeRaw(this, out);
    }

    public static FullBranchInfo read(TaggedDataInput in) throws IOException {
        com.atlassian.clover.api.registry.ContextSet context = in.read(ContextSet.class);
        int relativeDataIndex = in.readInt();
        int complexity = in.readInt();
        LanguageConstruct construct = Languages.lookupConstruct(in.readUTF());
        boolean isInstrumented = in.readBoolean();
        FixedSourceRegion region = FixedSourceRegion.read(in);
        return new FullBranchInfo(null, relativeDataIndex, context, region, complexity, isInstrumented, construct);
    }
}

