/*
 * Decompiled with CFR 0.152.
 */
package de.superx.applet;

import de.memtext.dlg.OkCancelClearDlg;
import de.memtext.tree.KeyParentEqualException;
import de.memtext.tree.NoMainEntryException;
import de.memtext.util.DateUtils;
import de.memtext.util.WindowUtils;
import de.memtext.widgets.LabeledComboBox;
import de.memtext.widgets.TitlePanel;
import de.memtext.widgets.VerticalBox;
import de.memtext.widgets.WarningMessage;
import de.superx.applet.SichtApplet;
import de.superx.applet.SuperX;
import de.superx.common.DBServletException;
import de.superx.common.SelectableItem;
import de.superx.common.Sichtgruppe;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Date;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.TimeZone;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.tree.DefaultMutableTreeNode;

public class SxTreeDlg
extends OkCancelClearDlg {
    private JButton bStand;
    private JEditorPane erlPane = new JEditorPane("text/html", "");
    private JScrollPane erlScrollP;
    private Font fontBtns = new Font("SansSerif", 0, 10);
    boolean result;
    boolean isStandChanged;
    private LinkedList selections = new LinkedList();
    JLabel lblStand;
    private String standAmAnfang;
    JScrollPane treeScroll = new JScrollPane();
    private SxTreeDlgMouseListener mouseList = new SxTreeDlgMouseListener();
    private LabeledComboBox cbSichten;
    private Sichtgruppe sichtgruppe;
    private JPanel auswahlPanel;
    private SichtenChangeListener changeListener = new SichtenChangeListener();

    public SxTreeDlg(Frame parent, String name, Sichtgruppe sichtgruppe, String erl\u00e4uterung) throws SQLException, DBServletException, KeyParentEqualException, CloneNotSupportedException, NoMainEntryException {
        super(parent, "Auswahl " + name);
        this.selections.clear();
        Point parloc = parent.getLocation();
        this.setLocation(parloc.x + 30, parloc.y + 30);
        this.sichtgruppe = sichtgruppe;
        this.setNorth(new TitlePanel("Auswahl " + name));
        this.initCenter(erl\u00e4uterung);
        JButton btnSuchen = new JButton("Suchen");
        btnSuchen.setFont(this.fontBtns);
        btnSuchen.addActionListener(new SuchenListener());
        this.addAboveOK(btnSuchen);
        for (SichtApplet aSicht : sichtgruppe) {
            aSicht.addMouseListener(this.mouseList);
        }
        this.setSize(700, 500);
    }

    private void initCenter(String erl\u00e4uterung) throws SQLException, DBServletException, KeyParentEqualException, CloneNotSupportedException, NoMainEntryException {
        JSplitPane jsp = new JSplitPane(1);
        this.erlScrollP = new JScrollPane(this.erlPane);
        jsp.add(this.erlScrollP);
        this.erlPane.setText(erl\u00e4uterung);
        this.erlPane.setEditable(false);
        if (erl\u00e4uterung == null || erl\u00e4uterung.trim().equals("")) {
            this.erlScrollP.setVisible(false);
        }
        jsp.setDividerLocation(250);
        VerticalBox vbox = new VerticalBox();
        this.auswahlPanel = new JPanel();
        this.lblStand = new JLabel();
        this.lblStand.setFont(this.fontBtns);
        this.bStand = new JButton("anderer Stand");
        this.bStand.setFont(this.fontBtns);
        this.bStand.setDefaultCapable(false);
        this.bStand.addActionListener(new StandListener());
        this.auswahlPanel.add(this.lblStand);
        this.auswahlPanel.add(this.bStand);
        vbox.add(this.auswahlPanel);
        this.cbSichten = new LabeledComboBox("Sicht", this.sichtgruppe.getSichtenlist());
        this.cbSichten.addActionListener(this.changeListener);
        if (this.sichtgruppe.getSelectedSicht() != null) {
            this.cbSichten.setSelectedItem(this.sichtgruppe.getSelectedSicht());
        } else {
            this.cbSichten.setSelectedIndex(0);
            this.sichtgruppe.setSelectedSicht((SichtApplet)this.cbSichten.getSelectedItem());
            try {
                this.sichtgruppe.makeSureSelectedSichtIsOK();
            }
            catch (Exception e2) {
                throw new SQLException(e2.toString());
            }
        }
        this.auswahlPanel.add(this.cbSichten);
        if (this.sichtgruppe.size() < 2) {
            this.cbSichten.setVisible(false);
        }
        this.lblStand.setText("Stand: " + this.sichtgruppe.getSelectedSicht().getStand());
        this.standAmAnfang = this.sichtgruppe.getSelectedSicht().getStand();
        vbox.add(this.treeScroll);
        jsp.add(vbox);
        this.setCenter(jsp);
    }

    private void updateStandVisibility() {
        if (this.sichtgruppe.getSelectedSicht().isStandbuttonWanted()) {
            this.lblStand.setVisible(true);
            this.bStand.setVisible(true);
        } else {
            this.lblStand.setVisible(false);
            this.bStand.setVisible(false);
        }
    }

    public void standAendern() throws SQLException, DBServletException, KeyParentEqualException, CloneNotSupportedException, NoMainEntryException {
        String neuerStand = JOptionPane.showInputDialog(this, "Neues Datum eingeben:", "SuperX", 3);
        if (neuerStand == null) {
            return;
        }
        DateFormat df = DateFormat.getDateInstance(2);
        df.setTimeZone(TimeZone.getDefault());
        df.setLenient(false);
        String geprueft = null;
        Date adate = null;
        try {
            if (neuerStand.endsWith("00")) {
                switch (neuerStand.charAt(neuerStand.length() - 3)) {
                    case '-': 
                    case '.': 
                    case '/': {
                        neuerStand = String.valueOf(neuerStand.substring(0, neuerStand.length() - 2)) + "2000";
                    }
                }
            }
            java.util.Date date = df.parse(neuerStand);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            int year = calendar.get(1);
            if (year >= 0 && year < 30) {
                calendar.add(1, 2000);
            }
            if (year >= 30 && year < 100) {
                calendar.add(1, 1900);
            }
            adate = new Date(calendar.getTime().getTime());
            geprueft = df.format(adate);
        }
        catch (ParseException date) {
        }
        catch (IllegalArgumentException date) {
            // empty catch block
        }
        if (geprueft != null && adate != null && !SuperX.isZuk\u00fcnftigerStandErlaubt && DateUtils.isDateInFuture(adate)) {
            WarningMessage.show((Component)this, "Das Datum darf nicht in der Zukunft liegen", "SuperX");
            geprueft = null;
        }
        if (geprueft != null) {
            WindowUtils.setWaitCursor(this, true);
            this.lblStand.setText("Stand: " + neuerStand);
            try {
                this.sichtgruppe.setStand(neuerStand);
            }
            catch (Exception e2) {
                throw new SQLException(e2.toString());
            }
            WindowUtils.setWaitCursor(this, false);
            this.isStandChanged = true;
        } else {
            JOptionPane.showMessageDialog(null, "Ung\u00fcltige Eingabe!", "SuperX", 0);
        }
    }

    public LinkedList getSelections() {
        return this.selections;
    }

    private void suchen() {
        String such = JOptionPane.showInputDialog(null, "Suche:", "SuperX", 3);
        if (such == null || such.length() < 1) {
            return;
        }
        such = such.toLowerCase();
        SichtApplet sicht = (SichtApplet)this.sichtgruppe.getSelectedSicht();
        sicht.searchEntries(such);
    }

    @Override
    protected void performOk() {
        block5: {
            try {
                this.removeMouseListener(this.sichtgruppe, this.mouseList);
                SichtApplet sicht = (SichtApplet)this.sichtgruppe.getSelectedSicht();
                if (sicht.getSelectionCount() == 0) {
                    SelectableItem selectedItem = new SelectableItem("-1", "");
                    selectedItem.setAllowed(false);
                    this.selections.add(selectedItem);
                    break block5;
                }
                int i2 = 0;
                while (i2 < sicht.getSelectionCount()) {
                    DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)sicht.getSelectionPaths()[i2].getLastPathComponent();
                    if (!(selNode.getUserObject() instanceof SelectableItem)) {
                        this.performClear();
                        break;
                    }
                    SelectableItem selectedItem = (SelectableItem)selNode.getUserObject();
                    this.selections.add(selectedItem);
                    ++i2;
                }
            }
            catch (Exception e2) {
                WarningMessage.show((Component)this, "Fehler\n" + e2, "SuperX");
                e2.printStackTrace();
            }
        }
        this.setVisible(false);
        this.dispose();
    }

    @Override
    protected void performCancel() {
        this.removeMouseListener(this.sichtgruppe, this.mouseList);
        this.selections.clear();
        this.setVisible(false);
        this.dispose();
    }

    @Override
    protected void performClear() {
        this.removeMouseListener(this.sichtgruppe, this.mouseList);
        if (this.sichtgruppe != null) {
            this.sichtgruppe.getSelectedSicht().clearSelection();
        }
        SelectableItem selectedItem = new SelectableItem("null", "");
        selectedItem.setAllowed(false);
        this.selections.add(selectedItem);
        this.setVisible(false);
        this.dispose();
    }

    public void configure(String gew\u00fcnschterStand) {
        try {
            this.sichtgruppe.setStand(gew\u00fcnschterStand);
        }
        catch (Exception e2) {
            WarningMessage.show((Component)this, "Stand konnte nicht ge\u00e4ndert werden.\n" + e2, "SuperX");
            e2.printStackTrace();
        }
    }

    private void removeMouseListener(Sichtgruppe sichtgruppe, MouseListener mouseList) {
        for (SichtApplet aSicht : sichtgruppe) {
            try {
                aSicht.removeMouseListener(mouseList);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    private void setCursor(boolean b2) {
        WindowUtils.setWaitCursor(this, b2);
    }

    public boolean isStandChanged() {
        return this.isStandChanged;
    }

    class SichtenChangeListener
    implements ActionListener {
        SichtenChangeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            SxTreeDlg.this.setCursor(true);
            SichtApplet newSicht = (SichtApplet)SxTreeDlg.this.cbSichten.getSelectedItem();
            SxTreeDlg.this.sichtgruppe.setSelectedSicht(newSicht);
            try {
                SxTreeDlg.this.sichtgruppe.makeSureSelectedSichtIsOK();
                SxTreeDlg.this.treeScroll.setViewportView(newSicht);
            }
            catch (Exception e1) {
                WarningMessage.show(null, "Fehler.\n" + e2, "SuperX");
                e1.printStackTrace();
            }
            SxTreeDlg.this.updateStandVisibility();
            SxTreeDlg.this.setCursor(false);
        }
    }

    class StandListener
    implements ActionListener {
        StandListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                SxTreeDlg.this.standAendern();
            }
            catch (Exception e2) {
                WarningMessage.show(null, "Stand konnte nicht ge\u00e4ndert werden.\n" + e2, "SuperX");
                e2.printStackTrace();
            }
        }
    }

    class SuchenListener
    implements ActionListener {
        SuchenListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            SxTreeDlg.this.suchen();
        }
    }

    class SxTreeDlgMouseListener
    extends MouseAdapter {
        SxTreeDlgMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            e2.getClickCount();
        }
    }
}

