/*
 * Decompiled with CFR 0.152.
 */
package de.superx.util.jrcharts;

import de.superx.util.jrcharts.format.CustomCategoryItemLabelNumberFormat;
import de.superx.util.jrcharts.format.CustomCategoryItemLabelPercentFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.Range;
import org.jfree.ui.RectangleInsets;

public class CustomBaseChart {
    private final double top = 15.0;
    private final double bottom = 5.0;
    private final double left = 5.0;
    private final double right = 5.0;

    private void setCategoryItemVisible(CategoryItemRenderer renderer) {
        if (!renderer.getBaseItemLabelsVisible().booleanValue()) {
            renderer.setBaseItemLabelsVisible(Boolean.TRUE);
        }
    }

    public void setAxisLocaton(CategoryPlot categoryPlot) {
        categoryPlot.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
    }

    public void setCategoryItemLabelPercentFormat(CategoryPlot categoryPlot) {
        CategoryItemRenderer renderer = categoryPlot.getRenderer();
        this.setCategoryItemVisible(renderer);
        renderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new CustomCategoryItemLabelPercentFormat("", NumberFormat.getInstance()));
    }

    public void setCategoryItemLabelNumberFormat(CategoryPlot categoryPlot) {
        CategoryItemRenderer renderer = categoryPlot.getRenderer();
        this.setCategoryItemVisible(renderer);
        renderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new CustomCategoryItemLabelNumberFormat("", NumberFormat.getInstance()));
    }

    public void setRangeAxisPercentFormat(CategoryPlot categoryPlot) {
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        numberAxis.setTickUnit(new NumberTickUnit(0.1, (NumberFormat)new DecimalFormat("#0%")));
    }

    public void setRangeAxisMaxValue(CategoryPlot categoryPlot, double upperValue) {
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        Range range = numberAxis.getRange();
        numberAxis.setUpperBound(range.getUpperBound() + upperValue);
    }

    public void setInsets(CategoryPlot categoryPlot) {
        categoryPlot.setInsets(new RectangleInsets(15.0, 5.0, 5.0, 5.0));
    }

    public void setAxisTickMarks(CategoryPlot categoryPlot) {
        ValueAxis valueAxis = categoryPlot.getRangeAxis();
        valueAxis.setMinorTickCount(2);
        valueAxis.setMinorTickMarkOutsideLength(1.0f);
        valueAxis.setMinorTickMarksVisible(true);
        valueAxis.setTickMarkOutsideLength(2.5f);
    }
}

