/*
 * Decompiled with CFR 0.152.
 */
package de.superx.util;

import java.io.File;
import java.io.FilenameFilter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JasperUtils {
    static Logger logger = LoggerFactory.getLogger(JasperUtils.class);

    public static void main(String[] args) {
        if (args.length > 0) {
            JasperUtils.compileAllJRXMLFiles(args[0]);
        }
    }

    public static void compileAllJRXMLFiles(String folder) {
        JasperUtils.compileAllJRXMLFiles(new File(folder));
    }

    public static void compileAllJRXMLFiles(File folder) {
        File[] fileList;
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.toLowerCase().endsWith(".jrxml");
            }
        };
        for (File jrxmlFile : fileList = folder.listFiles(filter)) {
            String outfileName = jrxmlFile.getAbsolutePath().replaceAll(".jrxml$", ".jasper");
            File outfile = new File(outfileName);
            if (outfile.exists() && outfile.lastModified() > jrxmlFile.lastModified()) continue;
            try {
                JasperCompileManager.compileReportToFile((String)jrxmlFile.getAbsolutePath(), (String)outfile.getAbsolutePath());
            }
            catch (JRException e) {
                logger.error("Couldn't compile report " + String.valueOf(jrxmlFile), (Throwable)e);
            }
        }
    }
}

