/*
 * Decompiled with CFR 0.152.
 */
package de.superx.spring.service;

import de.superx.bianalysis.metadata.Identifier;
import de.superx.bianalysis.repository.dto.AttributeDto;
import de.superx.common.InvalidEntityException;
import de.superx.jdbc.entity.Entity;
import de.superx.jdbc.model.DynamicFieldType;
import de.superx.jdbc.model.TableRef;
import de.superx.jdbc.repository.BiaAdminCrudRepository;
import de.superx.rest.model.Item;
import de.superx.spring.service.BiaRepositoryService;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.relational.core.mapping.event.BeforeConvertCallback;
import org.springframework.data.repository.CrudRepository;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
class EntitySaveCallback
implements BeforeConvertCallback<Entity> {
    static Logger logger = Logger.getLogger(EntitySaveCallback.class);
    @Autowired
    BiaRepositoryService biaRepositoryService;

    EntitySaveCallback() {
    }

    public Entity onBeforeConvert(Entity entity) {
        Entity modifiedEntity = null;
        try {
            Entity unmodifiedEntity = this.getUnmodifiedEntity(entity);
            if (unmodifiedEntity != null && unmodifiedEntity.isReadOnly()) {
                throw new InvalidEntityException("Entity is read-only");
            }
            modifiedEntity = this.handleNewEntityWithoutId(entity);
            this.validateFields(modifiedEntity, unmodifiedEntity);
            modifiedEntity = entity.customSaveCallback();
        }
        catch (IllegalAccessException | IllegalArgumentException | SQLException e) {
            logger.error((Object)"Could not save Entity", (Throwable)e);
            throw new InvalidEntityException("Could not save Entity");
        }
        return modifiedEntity;
    }

    private void validateFields(Entity entity, Entity unmodifiedEntity) throws IllegalArgumentException, IllegalAccessException, SQLException {
        Field[] entityFields = entity.getClass().getDeclaredFields();
        ArrayList<String> messages = new ArrayList<String>();
        for (Field field : entityFields) {
            messages.add(this.validateRequired(field, entity));
            messages.add(this.validateTableRef(field, entity));
            messages.add(this.validateCellSpecificForeignKey(field, entity));
            messages.add(EntitySaveCallback.validateReadOnly(field, entity, unmodifiedEntity));
        }
        messages.removeIf(Objects::isNull);
        if (!messages.isEmpty()) {
            EntitySaveCallback.createInvalidEntityException(messages);
        }
    }

    private Entity getUnmodifiedEntity(Entity entity) throws IllegalArgumentException, IllegalAccessException {
        Optional unmodifiedEntity;
        BiaAdminCrudRepository<Entity> repository = this.biaRepositoryService.findBiaAdminCrudRepositoryFor(entity);
        Field idField = this.biaRepositoryService.getIdField(repository);
        Object id = null;
        id = idField.get(entity);
        if (id != null && (unmodifiedEntity = repository.findById(id)).isPresent()) {
            return (Entity)unmodifiedEntity.get();
        }
        return null;
    }

    private String validateRequired(Field field, Entity entity) throws IllegalArgumentException, IllegalAccessException, SQLException {
        if (entity.isFieldRequired(field, this.biaRepositoryService.getDataSource()) && field.get(entity) == null) {
            return "Benutzereingabe f\u00fcr Feld '" + field.getName() + "' ist erforderlich, aber es wurde keine angegeben.";
        }
        return null;
    }

    private String validateTableRef(Field field, Entity entity) throws IllegalArgumentException, IllegalAccessException {
        TableRef annotation = field.getAnnotation(TableRef.class);
        if (annotation != null && field.get(entity) != null) {
            String fieldName = EntitySaveCallback.getFieldName(field);
            Object value = field.get(entity);
            CrudRepository<Entity, Object> repository = this.biaRepositoryService.findCrudRepositoryFor(annotation.schema(), annotation.table());
            if (!repository.existsById(value)) {
                return "Key " + String.valueOf(value) + " in field " + fieldName + " does not exists.";
            }
        }
        return null;
    }

    private String validateCellSpecificForeignKey(Field field, Entity entity) throws IllegalArgumentException, IllegalAccessException {
        List<Item> items = entity.getCellSpecificItems(field.getName(), this.biaRepositoryService.getDataSource());
        if (!items.isEmpty()) {
            String fieldName = EntitySaveCallback.getFieldName(field);
            Object value = field.get(entity);
            if (value != null && !items.contains(new Item(value.toString()))) {
                return "Key " + String.valueOf(value) + " in field " + fieldName + " does not exists.";
            }
        }
        return null;
    }

    private static String getFieldName(Field field) {
        DynamicFieldType dynamicFieldType = field.getAnnotation(DynamicFieldType.class);
        if (dynamicFieldType != null && !dynamicFieldType.label().isEmpty()) {
            return dynamicFieldType.label();
        }
        return field.getName();
    }

    private static String validateReadOnly(Field field, Entity entity, Entity unmodifiedEntity) throws IllegalArgumentException, IllegalAccessException {
        DynamicFieldType annotation = field.getAnnotation(DynamicFieldType.class);
        if (annotation != null && annotation.readOnly() && unmodifiedEntity != null) {
            String fieldName = EntitySaveCallback.getFieldName(field);
            Object newValue = field.get(entity);
            Object oldValue = field.get(unmodifiedEntity);
            boolean oldValueIsEmptyString = false;
            if (oldValue instanceof String && !(oldValueIsEmptyString = oldValue.toString().trim().isEmpty())) {
                oldValue = oldValue.toString().trim();
            }
            if (entity instanceof AttributeDto) {
                return null;
            }
            if (field.getName().equals("defaultRelease") && newValue.equals("custom")) {
                return null;
            }
            if (newValue != null && !newValue.equals(oldValue)) {
                return "Field " + fieldName + " should not be changed.";
            }
            if (newValue == null && oldValue != null && !oldValueIsEmptyString) {
                return "Field " + fieldName + " should not be changed.";
            }
        }
        return null;
    }

    private static void createInvalidEntityException(ArrayList<String> messages) {
        Object exceptionMessage = "";
        for (String message : messages) {
            exceptionMessage = (String)exceptionMessage + "\n" + message;
        }
        throw new InvalidEntityException((String)exceptionMessage);
    }

    private Entity handleNewEntityWithoutId(Entity entity) throws IllegalArgumentException, IllegalAccessException {
        Entity modifiedEntity;
        BiaAdminCrudRepository<Entity> repository = this.biaRepositoryService.findBiaAdminCrudRepositoryFor(entity);
        Field idField = this.biaRepositoryService.getIdField(repository);
        Object idValue = idField.get(modifiedEntity = entity);
        if (idValue == null) {
            if (idField.getType().equals(Identifier.class)) {
                Identifier id = this.getNewCustomIdentifier(idField, repository);
                if (id != null) {
                    idField.set(modifiedEntity, id);
                    modifiedEntity.makeEditable();
                }
            } else {
                Integer id = this.getLastId(idField, repository);
                if (id != null) {
                    idField.set(modifiedEntity, id + 1);
                    modifiedEntity.makeEditable();
                }
            }
        }
        return modifiedEntity;
    }

    private Identifier getNewCustomIdentifier(Field idField, BiaAdminCrudRepository<Entity> repository) {
        String query = "WITH all_ids AS ( SELECT split_part(id, ':', 2) AS id_part FROM metadata.facttable WHERE default_release = 'custom' UNION ALL SELECT split_part(id, ':', 2) FROM metadata.dimension WHERE default_release = 'custom' UNION ALL SELECT split_part(id, ':', 2) FROM metadata.dimension_attribute WHERE default_release = 'custom' UNION ALL SELECT split_part(id, ':', 2) FROM metadata.measure WHERE default_release = 'custom' UNION ALL SELECT split_part(id, ':', 2) FROM metadata.attribute_group UNION ALL SELECT split_part(id, ':', 2) FROM metadata.measure_filter WHERE default_release = 'custom' ) SELECT MAX(CAST(id_part AS INTEGER)) AS max_int FROM all_ids;";
        JdbcTemplate jt = new JdbcTemplate(this.biaRepositoryService.getDataSource());
        int maxValue = 1;
        try {
            Integer maxCustomId = (Integer)jt.queryForObject(query, Integer.class);
            if (maxCustomId != null) {
                maxValue += maxCustomId.intValue();
            }
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            // empty catch block
        }
        return new Identifier("custom:" + maxValue);
    }

    private Integer getLastId(Field idField, BiaAdminCrudRepository<Entity> repository) {
        String idColumn = idField.getName();
        String tableName = this.biaRepositoryService.getTableName(repository);
        String query = "SELECT max(" + idColumn + ") AS maxId FROM " + tableName;
        JdbcTemplate jt = new JdbcTemplate(this.biaRepositoryService.getDataSource());
        return (Integer)jt.queryForObject(query, Integer.class);
    }
}

