/*
 * Decompiled with CFR 0.152.
 */
package de.superx.spring.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.superx.bianalysis.service.DbMetaAdapter;
import de.superx.dbt.DbtManager;
import de.superx.job.ActionNode;
import de.superx.job.ContainerNode;
import de.superx.job.ExecuteActionGroupAction;
import de.superx.job.ExecuteDbtAction;
import de.superx.job.ExecuteSQLFluffAction;
import de.superx.job.ExtractAction;
import de.superx.job.KettleAction;
import de.superx.job.LoadAction;
import de.superx.job.LoadEtlRoutinesAction;
import de.superx.job.LoadMondrianSchemaAction;
import de.superx.job.RemoveSpringBatchHistoryAction;
import de.superx.job.SqlAction;
import de.superx.job.SqlActionNoSxPool;
import de.superx.job.SqlScriptAction;
import de.superx.job.Timestamp;
import de.superx.job.TransferAction;
import de.superx.job.UnloadAction;
import de.superx.job.UnloadParams;
import de.superx.job.UpdateMetadataAction;
import de.superx.job.UpgradeDbFormsConfigAction;
import de.superx.rest.model.job.JobExecutionStatus;
import de.superx.spring.batch.His1DataSources;
import de.superx.spring.batch.job.BiJobLoggingListener;
import de.superx.spring.batch.job.JobUtils;
import de.superx.spring.batch.reader.JdbcExtractReader;
import de.superx.spring.batch.reader.JdbcUnloadReader;
import de.superx.spring.batch.tasklet.ActionGroupTasklet;
import de.superx.spring.batch.tasklet.ExecuteDbtTasklet;
import de.superx.spring.batch.tasklet.ExecuteKettleTasklet;
import de.superx.spring.batch.tasklet.ExecuteSQLFluffTasklet;
import de.superx.spring.batch.tasklet.ExecuteSqlScriptTasklet;
import de.superx.spring.batch.tasklet.ExecuteSqlTasklet;
import de.superx.spring.batch.tasklet.LoadEtlRoutinesTasklet;
import de.superx.spring.batch.tasklet.LoadMondrianSchemaTasklet;
import de.superx.spring.batch.tasklet.PgCopyLoadTasklet;
import de.superx.spring.batch.tasklet.RemoveSpringBatchHistoryTasklet;
import de.superx.spring.batch.tasklet.SqlScriptActionNoSxPoolTasklet;
import de.superx.spring.batch.tasklet.TaskletContext;
import de.superx.spring.batch.tasklet.UnloadParamReaderTasklet;
import de.superx.spring.batch.tasklet.UpdateMetadataTasklet;
import de.superx.spring.batch.tasklet.UpgradeDbConfigTasklet;
import de.superx.spring.batch.util.BatchUtils;
import de.superx.spring.batch.util.StepCounter;
import de.superx.spring.batch.util.SuperxRowMapper;
import de.superx.spring.batch.writer.TypeinferringJdbcBatchItemWriter;
import de.superx.spring.service.StepData;
import de.superx.util.PathAndFileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.csv.CSVFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.job.AbstractJob;
import org.springframework.batch.core.job.builder.FlowBuilder;
import org.springframework.batch.core.job.builder.FlowJobBuilder;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.job.builder.JobFlowBuilder;
import org.springframework.batch.core.job.flow.Flow;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.builder.JobStepBuilder;
import org.springframework.batch.core.step.builder.StepBuilder;
import org.springframework.batch.core.step.job.JobParametersExtractor;
import org.springframework.batch.core.step.tasklet.MethodInvokingTaskletAdapter;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.core.step.tasklet.TaskletStep;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.file.FlatFileItemReader;
import org.springframework.batch.item.file.FlatFileItemWriter;
import org.springframework.batch.item.file.transform.LineAggregator;
import org.springframework.batch.item.file.transform.PassThroughLineAggregator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.WritableResource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;

@Service
public class BatchJobDescriptionAdapter {
    private static final int CHUNK_SIZE = 1000;
    static Logger logger = LoggerFactory.getLogger(BatchJobDescriptionAdapter.class);
    @Autowired
    PlatformTransactionManager transactionManager;
    @Autowired
    JobLauncher jobLauncher;
    @Autowired
    JobExplorer jobExplorer;
    @Autowired
    JobLauncher syncJobLauncher;
    @Autowired
    JobRepository jobRepository;
    @Autowired
    JobRegistry jobRegistry;
    @Autowired
    DbtManager dbtManager;
    @Autowired
    DbMetaAdapter dbMetaAdapter;
    @Autowired
    private His1DataSources dataSources;
    private boolean logJobToFile = true;

    public Job transformToBatchJob(ContainerNode root, String dataSourceName, StepCounter stepCounter, final BiJobLoggingListener jobLoggingListener, TaskletContext taskletContext) {
        List<ActionNode> children = root.getActions();
        JobBuilder jb = new JobBuilder(root.name, this.jobRepository);
        if (jobLoggingListener != null && this.logJobToFile) {
            jb.listener((JobExecutionListener)jobLoggingListener);
            logger.info("Start conversion to batch job for " + root.name);
        }
        if (children != null && children.size() > 0) {
            int startIndex;
            Step startStep = null;
            ActionNode previousAction = null;
            for (startIndex = 0; startStep == null && startIndex < children.size(); ++startIndex) {
                previousAction = children.get(startIndex);
                startStep = this.createStep(previousAction, dataSourceName, stepCounter, taskletContext);
            }
            if (startStep == null) {
                return this.createDummyJob(this.jobRepository);
            }
            FlowBuilder fb = new FlowBuilder(root.name);
            fb.start(startStep);
            for (ActionNode child : children.subList(startIndex, children.size())) {
                Step step = this.createStep(child, dataSourceName, stepCounter, taskletContext);
                if (step != null) {
                    if (previousAction != null && previousAction instanceof ContainerNode && !((ContainerNode)previousAction).isIgnoreErrors()) {
                        fb.next(step);
                    } else {
                        fb.on("STOPPED").stop();
                        fb.on("*").to(step);
                    }
                }
                previousAction = child;
            }
            fb.on("STOPPED").stop();
            fb.on("*").end();
            Flow flow = (Flow)fb.build();
            JobFlowBuilder jfb = jb.start(flow);
            FlowJobBuilder job = (FlowJobBuilder)jfb.end();
            if (jobLoggingListener != null) {
                job = (FlowJobBuilder)job.listener(new JobExecutionListener(){

                    public void beforeJob(JobExecution jobExecution) {
                    }

                    public void afterJob(JobExecution jobExecution) {
                        if (jobExecution.getExitStatus().getExitCode().equals("STOPPED")) {
                            logger.warn("Jobexecution STOPPED! " + String.valueOf(jobExecution));
                        }
                        for (StepExecution se : jobExecution.getStepExecutions()) {
                            if (!se.getExitStatus().getExitCode().equals("FAILED")) continue;
                            jobExecution.setStatus(BatchStatus.FAILED);
                            jobExecution.setExitStatus(new ExitStatus(ExitStatus.FAILED.getExitCode()));
                            break;
                        }
                        Long jobInstanceId = jobExecution.getJobInstance().getInstanceId();
                        JdbcTemplate jt = new JdbcTemplate(BatchJobDescriptionAdapter.this.dataSources.get("eduetl"));
                        JobExecutionStatus jobExecutionStatus = JobUtils.getJobExecutionStatus(jobExecution, BatchJobDescriptionAdapter.this.jobExplorer);
                        ObjectMapper mapper = new ObjectMapper();
                        String statusJson = "{}";
                        try {
                            statusJson = mapper.writeValueAsString((Object)jobExecutionStatus);
                        }
                        catch (JsonProcessingException e) {
                            logger.error("Couldn't write JobExecutionStatus to JSON", (Throwable)e);
                        }
                        File logFile = jobLoggingListener.getLogFile();
                        logger.info("Logfile: " + logFile.getAbsolutePath());
                        Object log = "ERROR READING LOGFILE " + logFile.getAbsolutePath();
                        try {
                            log = Files.readString(logFile.toPath());
                        }
                        catch (IOException e) {
                            logger.error("Couldn't read logfile {}", (Object)logFile.getAbsolutePath());
                        }
                        try {
                            boolean entryAlreadyExists;
                            boolean bl = entryAlreadyExists = (Integer)jt.queryForObject("SELECT COUNT(*) FROM job_log WHERE job_instance_id=" + jobInstanceId, Integer.class) > 0;
                            if (entryAlreadyExists) {
                                jt.update("UPDATE JOB_LOG set log = ?, status = ? WHERE job_instance_id = ?", new Object[]{log, statusJson, jobInstanceId});
                            } else {
                                jt.update("INSERT INTO JOB_LOG (job_instance_id, log, status) VALUES(?, ?, ?)", new Object[]{jobInstanceId, log, statusJson});
                            }
                        }
                        catch (Exception e) {
                            logger.warn("Could not update job_log table:");
                        }
                    }
                });
            }
            return ((FlowJobBuilder)job.preventRestart()).build();
        }
        return this.createDummyJob(this.jobRepository);
    }

    Step createStep(ActionNode node, String dataSourceName, StepCounter stepCounter, TaskletContext taskletContext) {
        if (!node.active) {
            return null;
        }
        StepBuilder stepBuilder = new StepBuilder(node.name, this.jobRepository);
        StepData result = null;
        if (node instanceof ContainerNode) {
            final ContainerNode container = (ContainerNode)node;
            AbstractJob job = (AbstractJob)this.transformToBatchJob(container, dataSourceName, stepCounter, null, taskletContext);
            job.registerJobExecutionListener(new JobExecutionListener(){

                public void beforeJob(JobExecution jobExecution) {
                }

                public void afterJob(JobExecution jobExecution) {
                    ExitStatus exitStatus = ExitStatus.COMPLETED;
                    for (StepExecution childStepExecution : jobExecution.getStepExecutions()) {
                        if (!childStepExecution.getExitStatus().getExitCode().equals("FAILED")) continue;
                        exitStatus = ExitStatus.FAILED;
                        break;
                    }
                    logger.debug("Job finished: " + jobExecution.getJobInstance().getJobName() + " with status " + String.valueOf(exitStatus));
                    jobExecution.setExitStatus(exitStatus);
                }
            });
            JobStepBuilder jsb = stepBuilder.job((Job)job);
            if (container.hasParameters()) {
                JobParametersExtractor jpe = new JobParametersExtractor(){

                    public JobParameters getJobParameters(Job aJob, StepExecution stepExecution) {
                        JobParametersBuilder jpb = new JobParametersBuilder();
                        Map<String, String> params = container.getParameters();
                        for (String key : params.keySet()) {
                            jpb.addString(key, params.get(key));
                        }
                        return jpb.toJobParameters();
                    }
                };
                jsb.parametersExtractor(jpe);
            }
            return jsb.build();
        }
        if (node instanceof LoadAction) {
            result = this.createLoadStep(stepBuilder, (LoadAction)node);
        } else if (node instanceof KettleAction) {
            result = this.createKettleStep(stepBuilder, (KettleAction)node);
        } else if (node instanceof SqlAction) {
            SqlAction sqlAction = (SqlAction)node;
            String sqlActionDataSource = sqlAction.dataSource;
            String dbSystem = sqlAction.databaseSystem;
            if (dbSystem != null && dbSystem.equalsIgnoreCase("POSTGRES") && (sqlActionDataSource == null || sqlActionDataSource.isEmpty() || "eduetl".equals(sqlActionDataSource) || this.dataSources.containsKey(sqlActionDataSource) && dataSourceName.equals(sqlActionDataSource))) {
                result = this.createSqlStep(stepBuilder, sqlAction);
            }
        } else if (node instanceof SqlScriptAction) {
            SqlScriptAction sqlScriptAction = (SqlScriptAction)node;
            String dbSystem = sqlScriptAction.databaseSystem;
            if (dbSystem != null && dbSystem.equalsIgnoreCase("POSTGRES")) {
                result = this.createSqlScriptStep(stepBuilder, (SqlScriptAction)node);
            }
        } else if (node instanceof SqlActionNoSxPool) {
            SqlActionNoSxPool sqlScriptAction = (SqlActionNoSxPool)node;
            result = this.createSqlActionNoSxPool(stepBuilder, sqlScriptAction);
        } else if (node instanceof TransferAction) {
            result = this.createTransferStep(stepBuilder, (TransferAction)node);
        } else if (node instanceof UnloadAction) {
            UnloadAction unloadAction = (UnloadAction)node;
            if (unloadAction.dataSource == null || unloadAction.dataSource.isBlank()) {
                unloadAction.dataSource = dataSourceName;
            }
            if (unloadAction.dataSource.equals(dataSourceName) || "eduetl".equals(unloadAction.dataSource) || "eduetl".equals(unloadAction.sqlVarSource)) {
                String vers = this.getUnloadParamVersion(unloadAction.systemInfoId.toString());
                result = this.createUnloadStep(stepBuilder, unloadAction, vers);
            }
        } else if (node instanceof UnloadParams) {
            UnloadParams unloadParams = (UnloadParams)node;
            result = this.createUnloadParamsStep(stepBuilder, unloadParams.systemInfoId);
        } else if (node instanceof ExtractAction) {
            ExtractAction extractAction = (ExtractAction)node;
            result = this.createExtractStep(stepBuilder, extractAction);
        } else if (node instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)node;
            result = this.createTimestampStep(stepBuilder, timestamp.systemInfoId);
        } else if (node instanceof LoadEtlRoutinesAction) {
            LoadEtlRoutinesAction lera = (LoadEtlRoutinesAction)node;
            result = this.createLoadEtlRoutinesStep(stepBuilder, lera.component);
        } else if (node instanceof LoadMondrianSchemaAction) {
            result = this.createLoadMondrianSchemaStep(stepBuilder);
        } else if (node instanceof UpgradeDbFormsConfigAction) {
            UpgradeDbFormsConfigAction config = (UpgradeDbFormsConfigAction)node;
            result = this.createUpgradeDbFormsConfigStep(stepBuilder, config.component);
        } else if (node instanceof ExecuteDbtAction) {
            ExecuteDbtAction eda = (ExecuteDbtAction)node;
            result = this.createExecuteDbtStep(stepBuilder, eda.dbtProject, eda.select, eda.test);
        } else if (node instanceof UpdateMetadataAction) {
            UpdateMetadataAction umd = (UpdateMetadataAction)node;
            result = this.createUpdateMetadataStep(stepBuilder, umd.dbtProject);
        } else if (node instanceof ExecuteSQLFluffAction) {
            result = new StepData((Step)stepBuilder.tasklet((Tasklet)new ExecuteSQLFluffTasklet(this.dbtManager), this.transactionManager).build());
        } else if (node instanceof RemoveSpringBatchHistoryAction) {
            RemoveSpringBatchHistoryTasklet rsbht = new RemoveSpringBatchHistoryTasklet();
            rsbht.setJdbcTemplate(new JdbcTemplate(this.dataSources.get("eduetl")));
            result = new StepData((Step)stepBuilder.tasklet((Tasklet)rsbht, this.transactionManager).build());
        } else if (node instanceof ExecuteActionGroupAction) {
            result = new StepData((Step)stepBuilder.tasklet((Tasklet)new ActionGroupTasklet(this.dbMetaAdapter), this.transactionManager).build());
        } else {
            throw new RuntimeException("No ActionNode type for " + String.valueOf(node.getClass()));
        }
        if (result != null) {
            stepCounter.increment(result.stepCount == 0 ? 1 : result.stepCount);
            taskletContext.registerInternalProgress(result.internalProgress);
            return result.step;
        }
        return null;
    }

    private StepData createSqlActionNoSxPool(StepBuilder stepBuilder, SqlActionNoSxPool sqlScriptAction) {
        DataSource ds = this.dataSources.get(sqlScriptAction.database);
        if (ds == null) {
            logger.error("DataSource not found: " + sqlScriptAction.database);
            return null;
        }
        SqlScriptActionNoSxPoolTasklet tasklet = new SqlScriptActionNoSxPoolTasklet(ds);
        File file = new File(PathAndFileUtils.substituteParamStrings(sqlScriptAction.sqlScriptPath));
        EncodedResource res = new EncodedResource((Resource)new FileSystemResource(file));
        tasklet.setSqlScript(res);
        return new StepData((Step)stepBuilder.tasklet((Tasklet)tasklet, this.transactionManager).build());
    }

    private StepData createUpdateMetadataStep(StepBuilder stepBuilder, String dbtProject) {
        UpdateMetadataTasklet updateMetadataTasklet = new UpdateMetadataTasklet(dbtProject, this.dataSources.get("eduetl"));
        return new StepData((Step)stepBuilder.tasklet((Tasklet)updateMetadataTasklet, this.transactionManager).build());
    }

    private StepData createUpgradeDbFormsConfigStep(StepBuilder stepBuilder, String component) {
        UpgradeDbConfigTasklet upgradeDbConfig = new UpgradeDbConfigTasklet(component);
        return new StepData((Step)stepBuilder.tasklet((Tasklet)upgradeDbConfig, this.transactionManager).build());
    }

    private StepData createLoadMondrianSchemaStep(StepBuilder stepBuilder) {
        LoadMondrianSchemaTasklet loadMondrianSchema = new LoadMondrianSchemaTasklet();
        return new StepData((Step)stepBuilder.tasklet((Tasklet)loadMondrianSchema, this.transactionManager).build());
    }

    private StepData createLoadEtlRoutinesStep(StepBuilder stepBuilder, String component) {
        LoadEtlRoutinesTasklet loadEtlRoutines = new LoadEtlRoutinesTasklet(component);
        return new StepData((Step)stepBuilder.tasklet((Tasklet)loadEtlRoutines, this.transactionManager).build());
    }

    private StepData createUnloadParamsStep(StepBuilder stepBuilder, Integer systemInfoId) {
        DataSource ds = this.dataSources.get("eduetl");
        if (ds == null) {
            logger.error("DataSource not found: eduetl");
            return null;
        }
        UnloadParamReaderTasklet unloadReader = new UnloadParamReaderTasklet(systemInfoId, ds);
        return new StepData((Step)stepBuilder.tasklet((Tasklet)unloadReader, this.transactionManager).build());
    }

    private StepData createTimestampStep(StepBuilder stepBuilder, Integer systemInfoId) {
        DataSource ds = this.dataSources.get("eduetl");
        if (ds == null) {
            logger.error("DataSource not found: eduetl");
            return null;
        }
        String sql = String.format("update systeminfo s set datum = now() where s.tid = %d;", systemInfoId);
        ExecuteSqlTasklet tasklet = new ExecuteSqlTasklet(sql, ds);
        return new StepData((Step)stepBuilder.tasklet((Tasklet)tasklet, this.transactionManager).build());
    }

    private StepData createUnloadStep(StepBuilder stepBuilder, UnloadAction unloadAction, String paramCompVersion) {
        DataSource ds = this.dataSources.get(unloadAction.dataSource);
        if (ds == null) {
            logger.error("DataSource not found: " + unloadAction.dataSource);
            return null;
        }
        JdbcUnloadReader reader = new JdbcUnloadReader();
        if (unloadAction.sourceVersions != null && !unloadAction.sourceVersions.isEmpty()) {
            if (unloadAction.sourceVersions.contains(paramCompVersion)) {
                reader.setSourceVersions(unloadAction.sourceVersions);
            } else {
                return null;
            }
        }
        reader.setSql(unloadAction.sql);
        reader.setDataSource(ds);
        reader.setRowMapper(new SuperxRowMapper(SuperxRowMapper.format_ifx));
        FlatFileItemWriter unlWriter = new FlatFileItemWriter();
        unlWriter.setResource((WritableResource)new FileSystemResource(PathAndFileUtils.substituteParamStrings(unloadAction.unlFile)));
        unlWriter.setLineAggregator((LineAggregator)new PassThroughLineAggregator());
        return new StepData((Step)stepBuilder.chunk(1000, this.transactionManager).reader(reader).writer((ItemWriter)unlWriter).build());
    }

    private StepData createExtractStep(StepBuilder stepBuilder, ExtractAction extractAction) {
        DataSource ds = this.dataSources.get(extractAction.dataSource);
        if (ds == null) {
            logger.error("DataSource not found: " + extractAction.dataSource);
            return null;
        }
        JdbcExtractReader reader = new JdbcExtractReader(extractAction, this.dataSources.get(extractAction.dataSource));
        reader.setTargetDataSource(this.dataSources.get("eduetl"));
        CSVFormat format = CSVFormat.DEFAULT;
        reader.setRowMapper(new SuperxRowMapper(format));
        FlatFileItemWriter unlWriter = new FlatFileItemWriter();
        unlWriter.setResource((WritableResource)new FileSystemResource(PathAndFileUtils.substituteParamStrings(extractAction.unlFile)));
        unlWriter.setLineAggregator((LineAggregator)new LineAggregator<String>(){

            public String aggregate(String item) {
                String striped = item.replace("\n", "").replace("\r", "");
                if (striped.isBlank()) {
                    return "";
                }
                return striped;
            }
        });
        return new StepData((Step)stepBuilder.chunk(1000, this.transactionManager).reader(reader).writer((ItemWriter)unlWriter).build());
    }

    private StepData createTransferStep(StepBuilder stepBuilder, TransferAction transferAction) {
        DataSource ds = this.dataSources.get("eduetl");
        if (ds == null) {
            logger.error("DataSource not found: eduetl");
            return null;
        }
        ExecuteSqlTasklet transfer = new ExecuteSqlTasklet("truncate table " + transferAction.toTable + "; insert into " + transferAction.toTable + " select * from " + transferAction.fromTable, ds);
        return new StepData((Step)stepBuilder.tasklet((Tasklet)transfer, this.transactionManager).build());
    }

    private StepData createSqlScriptStep(StepBuilder stepBuilder, SqlScriptAction sqlScriptAction) {
        DataSource varDs;
        DataSource ds = this.dataSources.get(sqlScriptAction.dataSource);
        if (ds == null) {
            logger.error("DataSource not found: " + sqlScriptAction.dataSource);
            return null;
        }
        DataSource dataSource = varDs = sqlScriptAction.sqlVarDataSource != null && !sqlScriptAction.sqlVarDataSource.isEmpty() ? this.dataSources.get(sqlScriptAction.sqlVarDataSource) : ds;
        if (varDs == null) {
            logger.error("VarDataSource not found: " + sqlScriptAction.sqlVarDataSource);
            return null;
        }
        File scriptFile = new File(PathAndFileUtils.substituteParamStrings(sqlScriptAction.sqlScriptPath));
        if (!scriptFile.exists()) {
            logger.warn("SQL Skriptfile doesn't exist: " + sqlScriptAction.sqlScriptPath);
        }
        String dbDriver = null;
        try (Connection c = ds.getConnection();){
            dbDriver = c.getMetaData().getDriverName().toLowerCase();
        }
        catch (SQLException e) {
            logger.error("Couldn't get DriverName!", (Throwable)e);
            return null;
        }
        if (dbDriver.contains(sqlScriptAction.databaseSystem)) {
            ExecuteSqlScriptTasklet execSqlScript = new ExecuteSqlScriptTasklet((Resource)new FileSystemResource(scriptFile), ds, varDs);
            if (sqlScriptAction.limitDebugStmts > 0) {
                execSqlScript.setLimitDebugStmts(sqlScriptAction.limitDebugStmts);
                execSqlScript.setContinueOnError(false);
            }
            return new StepData((Step)stepBuilder.tasklet((Tasklet)execSqlScript, this.transactionManager).build());
        }
        return null;
    }

    private StepData createSqlStep(StepBuilder stepBuilder, SqlAction sqlAction) {
        DataSource varDs;
        DataSource ds = this.dataSources.get(sqlAction.dataSource);
        if (ds == null) {
            logger.error("DataSource not found: " + sqlAction.dataSource);
            return null;
        }
        DataSource dataSource = varDs = sqlAction.sqlVarDataSource != null && !sqlAction.sqlVarDataSource.isEmpty() ? this.dataSources.get(sqlAction.sqlVarDataSource) : ds;
        if (varDs == null) {
            logger.error("VarDataSource not found: " + sqlAction.sqlVarDataSource);
            return null;
        }
        ExecuteSqlTasklet execSql = new ExecuteSqlTasklet(sqlAction.sql, ds, varDs);
        return new StepData((Step)stepBuilder.tasklet((Tasklet)execSql, this.transactionManager).build());
    }

    private StepData createKettleStep(StepBuilder stepBuilder, KettleAction kettleAction) {
        File scriptFile = new File(PathAndFileUtils.substituteParamStrings(kettleAction.kettleJobPath));
        ExecuteKettleTasklet execKettleScript = new ExecuteKettleTasklet((Resource)new FileSystemResource(scriptFile));
        return new StepData((Step)stepBuilder.tasklet((Tasklet)execKettleScript, this.transactionManager).build());
    }

    private StepData createExecuteDbtStep(StepBuilder stepBuild, String dbtProject, String dbtSelect, boolean dbtTest) {
        ExecuteDbtTasklet execDbt = new ExecuteDbtTasklet(this.dbtManager, dbtProject, dbtSelect, dbtTest);
        return new StepData((Step)stepBuild.tasklet((Tasklet)execDbt, this.transactionManager).build());
    }

    private StepData createLoadStep(StepBuilder stepBuilder, LoadAction loadAction) {
        DataSource ds = this.dataSources.get(loadAction.database);
        if (ds == null) {
            logger.error("DataSource not found: " + loadAction.database);
            return null;
        }
        if (loadAction.checkEmpty && !BatchJobDescriptionAdapter.tableEmpty(loadAction.tableName, ds)) {
            logger.warn("Not executing " + loadAction.name + "  because table not empty and checkEmpty=true!");
            return null;
        }
        if (loadAction.usePostgresCopyApi) {
            PgCopyLoadTasklet upload = new PgCopyLoadTasklet((Resource)new FileSystemResource(PathAndFileUtils.substituteParamStrings(loadAction.unlFilePath)), loadAction.delimiter, loadAction.tableName, ds, loadAction.refresh, loadAction.isCsv);
            return new StepData((Step)stepBuilder.tasklet((Tasklet)upload, this.transactionManager).build());
        }
        FlatFileItemReader<String[]> csvReader = BatchUtils.createCsvReaderIfx(new File(PathAndFileUtils.substituteParamStrings(loadAction.unlFilePath)), loadAction.delimiter);
        TypeinferringJdbcBatchItemWriter dbTableWriter = new TypeinferringJdbcBatchItemWriter(ds, loadAction.tableName, loadAction.refresh);
        logger.info("\tdb table writer for " + loadAction.tableName);
        return new StepData((Step)stepBuilder.chunk(1000, this.transactionManager).reader(csvReader).writer((ItemWriter)dbTableWriter).build());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getUnloadParamVersion(String systeminfo_id) {
        String query = "SELECT param_val FROM unload_params WHERE param_id='VERSION' AND systeminfo_id=" + systeminfo_id + " LIMIT 1;";
        String versionComp = null;
        ResultSet rs = null;
        try (Connection con = this.dataSources.get("eduetl").getConnection();
             Statement st = con.createStatement();){
            rs = st.executeQuery(query);
            if (rs == null) {
                String string = versionComp;
                return string;
            }
            while (rs.next()) {
                versionComp = rs.getString(1);
            }
            return versionComp;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return versionComp;
    }

    private static boolean tableEmpty(String tableName, DataSource dataSource) {
        JdbcTemplate jt = new JdbcTemplate(dataSource);
        Boolean exists = (Boolean)jt.queryForObject("SELECT count(*) FROM information_schema.tables WHERE table_name = '" + tableName + "' LIMIT 1", Boolean.class);
        if (Boolean.FALSE.equals(exists)) {
            return true;
        }
        Integer rowCount = (Integer)jt.queryForObject("SELECT COUNT(*) FROM " + tableName, Integer.class);
        return rowCount.equals(0);
    }

    public void setLogJobToFile(boolean logJobToFile) {
        this.logJobToFile = logJobToFile;
    }

    private Job createDummyJob(JobRepository jobRepository) {
        MethodInvokingTaskletAdapter mita = new MethodInvokingTaskletAdapter();
        mita.setTargetObject((Object)System.out);
        mita.setTargetMethod("println");
        mita.setArguments(new Object[]{"dummy do nothing step"});
        TaskletStep dummyStep = new StepBuilder("dummy do nothing", jobRepository).tasklet((Tasklet)mita, this.transactionManager).build();
        Job job = new JobBuilder("dummyJob", jobRepository).start((Step)dummyStep).build();
        return job;
    }
}

