/*
 * Decompiled with CFR 0.152.
 */
package de.superx.spring.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import de.superx.bianalysis.metadata.Identifier;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.postgresql.util.PGobject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.jdbc.repository.config.AbstractJdbcConfiguration;
import org.springframework.data.jdbc.repository.config.EnableJdbcRepositories;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.dialect.PostgresDialect;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@EnableJdbcRepositories(basePackages={"de.superx.jdbc.repository", "de.superx.bianalysis.repository", "de.superx.bianalysis.service", "de.superx.bianalysis.rest"})
public class DataJdbcConfiguration
extends AbstractJdbcConfiguration {
    @Autowired
    DataSource dataSource;

    @Bean
    NamedParameterJdbcOperations operations() {
        return new NamedParameterJdbcTemplate(this.dataSource);
    }

    @Bean
    PlatformTransactionManager transactionManager() {
        return new DataSourceTransactionManager(this.dataSource);
    }

    @Bean
    public Dialect jdbcDialect(NamedParameterJdbcOperations operations) {
        return PostgresDialect.INSTANCE;
    }

    public List<?> userConverters() {
        return Arrays.asList(new BooleanToIntegerConverter(), new IntegerToBooleanConverter(), new IdentifierToString(), new StringToIdentifier(), new PGobjectToArrayNodeConverter(), new ArrayNodeToPGobjectConverter());
    }

    @WritingConverter
    public class BooleanToIntegerConverter
    implements Converter<Boolean, Integer> {
        public Integer convert(Boolean source) {
            if (source.booleanValue()) {
                return 1;
            }
            return 0;
        }
    }

    @ReadingConverter
    public class IntegerToBooleanConverter
    implements Converter<Integer, Boolean> {
        public Boolean convert(Integer source) {
            if (source.equals(1)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    }

    @WritingConverter
    public class IdentifierToString
    implements Converter<Identifier, String> {
        public String convert(Identifier id) {
            return id.composedId;
        }
    }

    @ReadingConverter
    public class StringToIdentifier
    implements Converter<String, Identifier> {
        public Identifier convert(String source) {
            return new Identifier(source);
        }
    }

    @ReadingConverter
    public class PGobjectToArrayNodeConverter
    implements Converter<Object, ArrayNode> {
        private final ObjectMapper mapper = new ObjectMapper();

        public ArrayNode convert(Object source) {
            if (source instanceof PGobject) {
                PGobject pgObject = (PGobject)source;
                String value = pgObject.getValue();
                if (value == null || value.trim().isEmpty()) {
                    return this.mapper.createArrayNode();
                }
                try {
                    JsonNode node = this.mapper.readTree(value);
                    return node.isArray() ? (ArrayNode)node : this.mapper.createArrayNode();
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to parse JSON", e);
                }
            }
            return this.mapper.createArrayNode();
        }
    }

    @WritingConverter
    public class ArrayNodeToPGobjectConverter
    implements Converter<ArrayNode, Object> {
        private final ObjectMapper mapper = new ObjectMapper();

        public Object convert(ArrayNode source) {
            if (source == null) {
                return null;
            }
            PGobject pgObject = new PGobject();
            pgObject.setType("jsonb");
            try {
                pgObject.setValue(this.mapper.writeValueAsString((Object)source));
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return pgObject;
        }
    }
}

