/*
 * Decompiled with CFR 0.152.
 */
package de.superx.spring.config;

import de.superx.rest.EtlJobApi;
import de.superx.servlet.SuperXManager;
import java.util.List;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class BiApplicationContextInit {
    Logger logger = Logger.getLogger(BiApplicationContextInit.class);
    private boolean dbFunctionsLoaded = false;

    @EventListener
    void contextRefreshedEvent(ContextRefreshedEvent cre) {
        ApplicationContext ctx = cre.getApplicationContext();
        DataSource ds = (DataSource)ctx.getBean(DataSource.class);
        if (SuperXManager.checkDatabaseEmpty(ds)) {
            this.logger.warn((Object)"eduetl db empty. Not installing module functions.");
            return;
        }
        this.logger.info((Object)"Installing module funtions:");
        if (!this.dbFunctionsLoaded) {
            EtlJobApi jobApi = (EtlJobApi)ctx.getBean(EtlJobApi.class);
            List<de.superx.rest.model.job.Component> components = jobApi.getAllComponentAndConnectorDetails();
            for (de.superx.rest.model.job.Component component : components) {
                if (!component.isInstalled()) continue;
                this.logger.info((Object)("Installing module funtions for " + component.getName()));
                jobApi.installModuleFunctions(component.getAbbreviation());
            }
            this.logger.info((Object)"Installing module funtions finished.");
            this.dbFunctionsLoaded = true;
        }
    }
}

