/*
 * Decompiled with CFR 0.152.
 */
package de.superx.spring.batch.util;

import de.superx.spring.batch.util.LastDelimiterRemovingLineMapper;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.springframework.batch.item.file.FlatFileItemReader;
import org.springframework.batch.item.file.LineMapper;
import org.springframework.batch.item.file.mapping.ArrayFieldSetMapper;
import org.springframework.batch.item.file.mapping.DefaultLineMapper;
import org.springframework.batch.item.file.mapping.FieldSetMapper;
import org.springframework.batch.item.file.separator.DefaultRecordSeparatorPolicy;
import org.springframework.batch.item.file.separator.RecordSeparatorPolicy;
import org.springframework.batch.item.file.separator.SimpleRecordSeparatorPolicy;
import org.springframework.batch.item.file.transform.DelimitedLineTokenizer;
import org.springframework.batch.item.file.transform.LineTokenizer;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class BatchUtils {
    public static FlatFileItemReader<String[]> createCsvReaderPg(File unloadFile, String delimiter) {
        FlatFileItemReader csvReader = new FlatFileItemReader();
        csvReader.setStrict(false);
        csvReader.setResource((Resource)new FileSystemResource(unloadFile));
        csvReader.setEncoding("UTF-8");
        csvReader.setRecordSeparatorPolicy((RecordSeparatorPolicy)new DefaultRecordSeparatorPolicy());
        DefaultLineMapper lineMapper = new DefaultLineMapper();
        DelimitedLineTokenizer tokenizer = new DelimitedLineTokenizer(delimiter);
        lineMapper.setLineTokenizer((LineTokenizer)tokenizer);
        lineMapper.setFieldSetMapper((FieldSetMapper)new ArrayFieldSetMapper());
        csvReader.setLineMapper((LineMapper)lineMapper);
        return csvReader;
    }

    public static FlatFileItemReader<String[]> createCsvReaderIfx(File unloadFile, final String delimiter) {
        FlatFileItemReader csvReader = new FlatFileItemReader();
        csvReader.setStrict(false);
        csvReader.setResource((Resource)new FileSystemResource(unloadFile));
        csvReader.setEncoding("UTF-8");
        csvReader.setRecordSeparatorPolicy((RecordSeparatorPolicy)new SimpleRecordSeparatorPolicy());
        LastDelimiterRemovingLineMapper lineMapper = new LastDelimiterRemovingLineMapper();
        DelimitedLineTokenizer tokenizer = new DelimitedLineTokenizer(delimiter){

            protected boolean isQuoteCharacter(char c) {
                return false;
            }

            protected List<String> doTokenize(String line) {
                String[] tokens = line.split("((?<!\\\\)(?:\\\\{2})*)" + Pattern.quote(delimiter), -1);
                return Arrays.asList(tokens);
            }
        };
        lineMapper.setLineTokenizer((LineTokenizer)tokenizer);
        lineMapper.setFieldSetMapper((FieldSetMapper)new ArrayFieldSetMapper());
        csvReader.setLineMapper((LineMapper)lineMapper);
        return csvReader;
    }
}

