/*
 * Decompiled with CFR 0.152.
 */
package de.superx.spring.batch.tasklet;

import java.sql.Connection;
import javax.sql.DataSource;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.jdbc.datasource.init.ScriptUtils;

public class SqlScriptActionNoSxPoolTasklet
implements Tasklet {
    private EncodedResource sqlScript;
    private DataSource dataSource;

    public SqlScriptActionNoSxPoolTasklet(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        try (Connection con = this.dataSource.getConnection();){
            String[] commentPrefixes = new String[]{"--", "{###"};
            ScriptUtils.executeSqlScript((Connection)con, (EncodedResource)this.sqlScript, (boolean)false, (boolean)false, (String[])commentPrefixes, (String)";", (String)"/*", (String)"*/");
        }
        return RepeatStatus.FINISHED;
    }

    public void setSqlScript(EncodedResource sqlScript) {
        this.sqlScript = sqlScript;
    }
}

