/*
 * Decompiled with CFR 0.152.
 */
package de.superx.spring.batch.tasklet;

import de.superx.dbt.DbtManager;
import de.superx.dbt.DbtUtils;
import de.superx.spring.batch.tasklet.InternalProgress;
import de.superx.util.PathAndFileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;

public class ExecuteSQLFluffTasklet
implements Tasklet,
InternalProgress {
    public String filesWithErrors;
    public String error;
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private DbtManager dbtManager;
    private final Path dbtProjectDir = Path.of(PathAndFileUtils.getWebinfPath(), "..", "dbt", "projects", "hisinone", "transform");
    private final Path sqlFluffDir = this.dbtProjectDir.resolve("models");
    private int progress = 0;

    public ExecuteSQLFluffTasklet(DbtManager dbtManager) {
        this.dbtManager = dbtManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        try {
            int sqlFluffStatus = this.runSQLFluffLint();
            if (sqlFluffStatus != 0) {
                ExitStatus exitStatus = ExitStatus.FAILED;
                Object message = "";
                if (sqlFluffStatus == 1) {
                    message = (String)message + "Linting failed for the following files: \n";
                    message = (String)message + this.filesWithErrors;
                } else {
                    message = sqlFluffStatus == 2 ? (String)message + this.error : (String)message + "Unknown exit code: " + sqlFluffStatus;
                }
                exitStatus = exitStatus.addExitDescription((String)message);
                contribution.setExitStatus(exitStatus);
            }
        }
        catch (Exception e) {
            ExitStatus exitStatus = ExitStatus.FAILED;
            String errorMsg = e.getMessage();
            exitStatus = exitStatus.addExitDescription(errorMsg);
            contribution.setExitStatus(exitStatus);
        }
        finally {
            this.filesWithErrors = "";
            this.error = "";
        }
        return RepeatStatus.FINISHED;
    }

    public int runSQLFluffLint() throws IOException, InterruptedException {
        this.dbtManager.init(this.dbtProjectDir, "");
        Path dbtBinDir = DbtUtils.getDbtBinaryFolder();
        String sqlFluffBin = dbtBinDir.toString() + File.separator + "sqlfluff";
        if (!SystemUtils.IS_OS_LINUX) {
            sqlFluffBin = sqlFluffBin + ".exe";
        }
        this.logger.info("sqlfluff bin: " + sqlFluffBin);
        ProcessBuilder builder = new ProcessBuilder(DbtUtils.getPython3ExecutableName(), sqlFluffBin, "lint", "--verbose", "--nocolor", "--disable-progress-bar").directory(this.dbtProjectDir.toFile());
        Map<String, String> env = builder.environment();
        env.put("COMP_RES_INSTALLED", "true");
        env.put("DBT_DB", "eduetl");
        env.putAll(this.dbtManager.getDbtEnvironment());
        Process process = builder.start();
        this.filesWithErrors = "";
        Process p = builder.start();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                this.logger.info(line);
                if (!line.contains(".sql")) continue;
                if (line.contains("FAIL")) {
                    this.filesWithErrors = this.filesWithErrors + line + "\n";
                }
                ++this.progress;
            }
        }
        this.error = "";
        try (InputStream es = process.getErrorStream();
             InputStreamReader esr = new InputStreamReader(es);
             BufferedReader errReader = new BufferedReader(esr);){
            String line;
            while ((line = errReader.readLine()) != null) {
                this.logger.error(line);
                this.error = this.error + line + "\n";
            }
        }
        int exitCode = p.waitFor();
        return exitCode;
    }

    private static boolean isBinaryAvailable(String binaryName) {
        ProcessBuilder pb = new ProcessBuilder(binaryName, "--version");
        try {
            Process process = pb.start();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public int getInternalTotalStepsCount() {
        int count = 0;
        try {
            count = (int)Files.walk(this.sqlFluffDir, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().endsWith(".sql")).count();
        }
        catch (IOException e) {
            this.logger.error("Couldn't count sql files in " + String.valueOf(this.sqlFluffDir), (Throwable)e);
        }
        return count;
    }

    @Override
    public int getInternalStepsExecutedCount() {
        return this.progress;
    }
}

