/*
 * Decompiled with CFR 0.152.
 */
package de.superx.spring.batch.tasklet;

import de.superx.conf.ApplicationConfig;
import de.superx.dbt.DbtManager;
import de.superx.dbt.DbtUtils;
import de.superx.servlet.SuperXManager;
import de.superx.spring.batch.tasklet.InternalProgress;
import java.nio.file.Path;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;

public class ExecuteDbtTasklet
implements Tasklet,
StepExecutionListener,
InternalProgress {
    static Logger logger = LoggerFactory.getLogger(ExecuteDbtTasklet.class);
    private static final long DBT_TIMEOUT_MILLISECONDS = ((Integer)ApplicationConfig.getWithType(ApplicationConfig.Key.dbt_job_execution_timeout_seconds)).longValue() * 1000L;
    private final String dbtProject;
    private final String dbtSelect;
    private final boolean dbtTest;
    private final Path dbtProjectDir;
    private int totalStepsExecuted = 0;
    private DbtManager manager;

    public ExecuteDbtTasklet(DbtManager manager, String dbtProject, String dbtSelect, boolean dbtTest) {
        this.manager = manager;
        this.dbtProject = dbtProject;
        this.dbtSelect = dbtSelect;
        this.dbtTest = dbtTest;
        this.dbtProjectDir = Path.of(SuperXManager.getWEB_INFPfad(), "..", "dbt", "projects", dbtProject, "transform");
    }

    public void beforeStep(StepExecution stepExecution) {
        try {
            DbtUtils.checkPythonCompatability();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        try {
            this.manager.init(this.dbtProjectDir, this.dbtSelect, this.dbtTest);
            Thread t = new Thread(this.manager);
            long startTime = System.currentTimeMillis();
            t.setName("DBT-" + startTime);
            t.start();
            while (t.isAlive()) {
                Thread.sleep(100L);
                if (System.currentTimeMillis() - startTime <= DBT_TIMEOUT_MILLISECONDS) continue;
                Process p = this.manager.getProcess();
                if (p != null) {
                    p.destroyForcibly();
                }
                throw new RuntimeException("DBT run timeout!");
            }
            if (!this.manager.isSuccess().isPresent() || this.manager.isSuccess().get() == Boolean.FALSE) {
                ExitStatus exitStatus = ExitStatus.FAILED;
                List<String> errors = this.manager.getErrorMessages();
                for (String error : errors) {
                    exitStatus = exitStatus.addExitDescription(error);
                }
                contribution.setExitStatus(exitStatus);
            }
        }
        catch (Exception e) {
            String errorMsg = e.getMessage();
            Throwable cause = e.getCause();
            if (cause != null) {
                errorMsg = cause.getMessage();
            } else {
                logger.warn("No cause given for exception!");
            }
            ExitStatus exitStatus = ExitStatus.FAILED;
            exitStatus = exitStatus.addExitDescription(errorMsg);
            contribution.setExitStatus(exitStatus);
        }
        this.totalStepsExecuted = this.manager.getModelCount();
        return RepeatStatus.FINISHED;
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        return null;
    }

    @Override
    public int getInternalStepsExecutedCount() {
        return this.totalStepsExecuted > 0 ? this.totalStepsExecuted : this.manager.getModelCount();
    }

    @Override
    public int getInternalTotalStepsCount() {
        this.manager.init(this.dbtProjectDir, this.dbtSelect, this.dbtTest);
        return this.manager.getNodeCount();
    }
}

