/*
 * Decompiled with CFR 0.152.
 */
package de.superx.spring.batch.reader;

import de.superx.job.ExtractAction;
import de.superx.util.PathAndFileUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.item.database.JdbcCursorItemReader;

public class JdbcExtractReader<T>
extends JdbcCursorItemReader<T>
implements StepExecutionListener {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ExtractAction extractAction;
    public String dropTableStmt = "DROP TABLE IF EXISTS %s.%s;";
    public String createTableStmt = "CREATE TABLE %s.%s (%s);";
    public String selectFromTableStmt = "SELECT %s from %s WHERE %s;";
    private List<String> colsToExclude = Arrays.asList("lock_version");
    private DataSource dataSource;
    private DataSource targetDataSource;

    public JdbcExtractReader(ExtractAction extractAction, DataSource dataSource) {
        this.extractAction = extractAction;
        this.dataSource = dataSource;
    }

    public void beforeStep(StepExecution stepExecution) {
        this.setDataSource(this.dataSource);
        String selectBody = "";
        String createBody = "";
        ArrayList<String> selectElements = new ArrayList<String>();
        ArrayList<String> createElements = new ArrayList<String>();
        try (Connection con = this.dataSource.getConnection();){
            String schema = con.getSchema();
            DatabaseMetaData dbm = con.getMetaData();
            try (ResultSet columns = dbm.getColumns(null, schema, this.extractAction.sourceTable, null);){
                while (columns.next()) {
                    String nullable;
                    String col = columns.getString("COLUMN_NAME");
                    String type = columns.getString("TYPE_NAME");
                    String string = nullable = columns.getString("IS_NULLABLE").equals("NO") ? "not null" : "";
                    if (this.colsToExclude.contains(col) || this.extractAction.extractionInclude != null && !this.extractAction.extractionInclude.isEmpty() && !this.extractAction.extractionInclude.contains(col)) continue;
                    selectElements.add(col);
                    createElements.add(String.format("%s %s %s", col, type, nullable));
                }
                selectBody = String.join((CharSequence)", ", selectElements);
                createBody = String.join((CharSequence)", ", createElements);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (createBody.isEmpty()) {
            this.logger.warn("Unable to extract Table '" + this.extractAction.sourceTable + "' because it does not exist.");
            this.createTableStmt = "";
            this.setSql("select");
            return;
        }
        this.createTableStmt = String.format(this.dropTableStmt, this.extractAction.stagingSchema, this.extractAction.stagingTable) + String.format(this.createTableStmt, this.extractAction.stagingSchema, this.extractAction.stagingTable, createBody);
        this.selectFromTableStmt = String.format(this.selectFromTableStmt, selectBody, this.extractAction.sourceTable, this.extractAction.extractionScript);
        this.setSql(this.selectFromTableStmt);
        this.logger.info(this.getSql());
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        try {
            String tablesDir = PathAndFileUtils.getUnloadPath("biad") + File.separator + "tables";
            Files.createDirectories(Paths.get(tablesDir, new String[0]), new FileAttribute[0]);
            String unloadPath = tablesDir + File.separator + this.extractAction.sourceTable + ".sql";
            Path path = Paths.get(unloadPath, new String[0]);
            Files.deleteIfExists(path);
            Files.write(path, this.createTableStmt.getBytes(), new OpenOption[0]);
        }
        catch (Exception e) {
            this.logger.error("Error creating table: " + this.extractAction.sourceTable);
            this.logger.error(this.createTableStmt);
            String errorMsg = e.getMessage();
            this.logger.error(errorMsg);
            ExitStatus exitStatus = ExitStatus.FAILED;
            exitStatus = exitStatus.addExitDescription(errorMsg);
            stepExecution.setExitStatus(exitStatus);
        }
        return ExitStatus.COMPLETED;
    }

    public void setTargetDataSource(DataSource targetDataSource) {
        this.targetDataSource = targetDataSource;
    }
}

