/*
 * Decompiled with CFR 0.152.
 */
package de.superx.spring;

import com.google.common.io.Files;
import de.superx.conf.ApplicationConfig;
import de.superx.servlet.LogInit;
import de.superx.servlet.SuperXManager;
import de.superx.util.XmlUtil;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.FilenameFilter;
import java.nio.file.Path;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.web.context.ConfigurableWebApplicationContext;

public class HisInOneConfiguration
implements ApplicationContextInitializer<ConfigurableWebApplicationContext> {
    private static Logger logger = LoggerFactory.getLogger(HisInOneConfiguration.class);
    private File superxPath;
    private File hisinonePath;

    public void initialize(ConfigurableWebApplicationContext applicationContext) {
        File webappDir = HisInOneConfiguration.getWebappDir();
        ServletContext context = applicationContext.getServletContext();
        this.superxPath = new File(context.getRealPath("/"));
        String webInfPath = this.superxPath.getAbsolutePath() + File.separator + "WEB-INF";
        File log4jPropertiesFile = new File(webInfPath + File.separator + "log4j.properties");
        String logDir = webInfPath + File.separator + "logs";
        LogInit.initLog4J(log4jPropertiesFile, logDir);
        if (webappDir == null || !webappDir.canRead()) {
            logger.error("Could not configure HISinOne BI!");
        } else {
            String applicationName = applicationContext.getApplicationName();
            logger.info("**** INIT {} WEBAPPLICATION in {} ****", (Object)applicationName, (Object)webappDir.getAbsolutePath());
            this.hisinonePath = HisInOneConfiguration.findHis1(webappDir);
            logger.info("**** superx path: {}", (Object)this.superxPath.getAbsolutePath());
            if (this.hisinonePath != null) {
                logger.info("**** hisinone path: {}", (Object)this.hisinonePath.getAbsolutePath());
            }
        }
        if (!SuperXManager.isDBPropsSet() || !this.configFileExists()) {
            IllegalStateException illegalStateExcpetion = new IllegalStateException("*** Stopping init of BI spring context because not configured yet! ***");
            illegalStateExcpetion.setStackTrace(new StackTraceElement[0]);
            throw illegalStateExcpetion;
        }
        ApplicationConfig.readApplicationProperties();
        HisInOneConfiguration.configSuperXDbformsXML("pg", this.superxPath.getAbsolutePath());
    }

    private static File getWebappDir() {
        try {
            MBeanServer mBeanServer = MBeanServerFactory.findMBeanServer(null).get(0);
            ObjectName name = new ObjectName("Catalina", "type", "Server");
            Server server = (Server)mBeanServer.getAttribute(name, "managedResource");
            Service service = server.findService("Catalina");
            Engine engine = service.getContainer();
            Host host = (Host)engine.findChild(engine.getDefaultHost());
            return host.getAppBaseFile();
        }
        catch (Exception e) {
            logger.error("Couldn't get Tomcat appBase!", (Throwable)e);
            return null;
        }
    }

    private static File findHis1(File webappPath) {
        File[] entries;
        for (File entry : entries = webappPath.listFiles()) {
            File[] content = entry.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String name) {
                    return "pub".equals(name);
                }
            });
            if (content == null || content.length != 1) continue;
            return entry;
        }
        return null;
    }

    private boolean configFileExists() {
        Path his1DbProperties = Path.of(this.superxPath.getAbsolutePath(), "WEB-INF", "conf", "his1_databases.properties");
        Path superxDbProperties = Path.of(this.superxPath.getAbsolutePath(), "WEB-INF", "db.properties");
        boolean his1DbPropertiesExists = his1DbProperties.toFile().exists();
        boolean superxDbPropertiesExists = superxDbProperties.toFile().exists();
        logger.info(his1DbProperties.toString() + " exists: " + his1DbPropertiesExists);
        logger.info(superxDbProperties.toString() + " exists: " + superxDbPropertiesExists);
        return his1DbPropertiesExists || superxDbPropertiesExists;
    }

    public static void configSuperXDbformsXML(String dbSystemShortcut, String superxPath) {
        logger.info("Run configSuperXDbformsXML(" + dbSystemShortcut + ")");
        String pathToWebInfFolder = superxPath + File.separator + "WEB-INF" + File.separator;
        File fdbforms = new File(pathToWebInfFolder + "dbforms-config.xml");
        String templateFileLocation = pathToWebInfFolder + "dbforms-config_" + dbSystemShortcut + ".xml";
        File fvorlage = new File(templateFileLocation);
        if (!fdbforms.exists()) {
            logger.info("dbforms-config.xml doesn't exist. Initially copying from " + templateFileLocation);
            if (fvorlage.exists()) {
                try {
                    Files.copy((File)fvorlage, (File)fdbforms);
                    logger.debug("dbforms-config.xml copied from " + templateFileLocation);
                }
                catch (Exception e) {
                    logger.error("Copying configure file " + templateFileLocation + " failed!", (Throwable)e);
                }
            } else {
                logger.error("Configure file " + templateFileLocation + " is missing!");
            }
        }
        try {
            logger.info("Checking dbforms-config.xml for directory fields.");
            Element root = XmlUtil.getRootElement(fdbforms);
            logger.info("DBForms-Config File: " + root.toString());
            List tables = root.getChildren("table");
            for (Element table : tables) {
                Element dirField = XmlUtil.getElementByAttribute(table, "field", "directory", null);
                if (dirField == null) continue;
                String directory = dirField.getAttributeValue("directory");
                File fdir = new File(directory);
                if (!fdir.isAbsolute()) {
                    dirField.setAttribute("directory", pathToWebInfFolder + directory);
                    continue;
                }
                if (fdir.exists()) continue;
                logger.error("Directory doesn't exist: " + fdir.getPath() + " Please check dbforms-config.xml!");
            }
            XmlUtil.writeDocumentToFile(root.getDocument(), fdbforms);
        }
        catch (Exception e) {
            logger.error("Couldn't check directory attributes of field tags in dbforms-config.xml", (Throwable)e);
        }
    }
}

