/*
 * Decompiled with CFR 0.152.
 */
package de.superx.spring;

import jakarta.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class CsRfRequestMatcher
implements RequestMatcher {
    private static Logger logger = LoggerFactory.getLogger(CsRfRequestMatcher.class);

    public boolean matches(HttpServletRequest request) {
        String url;
        boolean isXmlHttpRequest;
        String method = request.getMethod();
        String requestType = request.getHeader("X-Requested-With");
        boolean bl = isXmlHttpRequest = requestType != null && requestType.equals("XMLHttpRequest");
        if (isXmlHttpRequest || method.equals("OPTIONS")) {
            return false;
        }
        int queryPos = request.getRequestURL().indexOf("&");
        String string = url = queryPos == -1 ? request.getRequestURL().toString() : request.getRequestURL().toString().substring(0, queryPos);
        return (!method.equals("GET") || url.endsWith("/control")) && !url.endsWith("/SuperXmlAnmeldung") && !url.endsWith("/SuperXmlAbmeldung") && !url.endsWith("/xml/his1/index.jsp") && !url.endsWith("/SuperXmlPwChanger") && !url.contains("/ds/api/") && !url.contains("/rest/saiku/api/export");
    }

    public static boolean isTrustedOrigin(HttpServletRequest request) {
        String origin = request.getHeader("Origin");
        String host = request.getHeader("Host");
        logger.info("Origin: {} Host: {}", (Object)origin);
        if (origin == null) {
            return true;
        }
        return origin.endsWith("://" + host);
    }
}

