/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.memtext.baseobjects.coll.NamedObjectSet;
import de.memtext.util.DateUtils;
import de.superx.common.DBServletException;
import de.superx.servlet.SuperXManager;
import de.superx.servlet.SxPool;
import de.superx.servlet.SxSQL_Server;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import javax.xml.transform.TransformerConfigurationException;
import org.apache.commons.dbcp.PoolingDriver;
import org.apache.log4j.Logger;

public class SxPools
extends NamedObjectSet {
    private static Logger logger = Logger.getLogger(SuperXManager.class);
    private static final long serialVersionUID = 1L;
    private static NamedObjectSet pools = new NamedObjectSet();
    private static boolean hasMandanten = false;

    private SxPools() {
    }

    public static synchronized Connection getConnection(String poolname) throws SQLException {
        String pooldrv;
        if (pools.size() == 0) {
            IllegalStateException e = new IllegalStateException("Kein Datenbank-ConnectionPool gefunden.");
            e.printStackTrace();
            throw e;
        }
        if (!pools.containsItemWithName(poolname)) {
            throw new SQLException("Kein Datenbank-ConnectionPool f\u00fcr Mandant:" + poolname + " gefunden");
        }
        if (!SxSQL_Server.DEFAULT_MANDANTEN_ID.equals(poolname) && !"test".equals(poolname) && DriverManager.getDriver(pooldrv = "jdbc:apache:commons:dbcp:" + poolname) == null) {
            Object msg = "Kein Datenbank-ConnectionPool gefunden ";
            if (!poolname.equals(SxSQL_Server.DEFAULT_MANDANTEN_ID)) {
                msg = (String)msg + " f\u00fcr Mandant " + poolname;
            }
            throw new SQLException((String)msg);
        }
        return ((SxPool)pools.getByName(poolname)).getConnection();
    }

    public static boolean hasMandanten() {
        return hasMandanten;
    }

    public static int count() {
        return pools.size();
    }

    public static SxPool get(String poolname) {
        if (!pools.containsItemWithName(poolname)) {
            throw new IllegalStateException("Kein Datenbank-ConnectionPool (" + poolname + ") vorhanden");
        }
        return (SxPool)pools.getByName(poolname);
    }

    public static SxPool getDefault() throws SQLException, IOException, DBServletException {
        if (!pools.containsItemWithName(SxSQL_Server.DEFAULT_MANDANTEN_ID)) {
            SxPools.initDefaultOnly();
        }
        return (SxPool)pools.getByName(SxSQL_Server.DEFAULT_MANDANTEN_ID);
    }

    public static boolean hasPool(String poolname) {
        return pools != null && pools.containsItemWithName(poolname);
    }

    static void initDefaultOnly() throws SQLException, IOException, DBServletException {
        pools.add(new SxPool(SxSQL_Server.DEFAULT_MANDANTEN_ID, new Properties()));
    }

    public static void init() throws IOException {
        LinkedList<String> mandantenNamen = new LinkedList();
        String mandantenCfg = SuperXManager.getWEB_INFPfad() + File.separator + "mandanten.cfg";
        File mandantenFile = new File(mandantenCfg);
        if (!mandantenFile.exists()) {
            logger.debug((Object)(DateUtils.getTodayString() + " " + DateUtils.getNowString()));
            mandantenNamen.add(SxSQL_Server.DEFAULT_MANDANTEN_ID);
        } else {
            mandantenNamen = SxPools.readNamen(mandantenFile);
        }
        SxPools.init(mandantenNamen);
    }

    public static void initTesting(Properties dbProperties) {
        hasMandanten = false;
        System.out.print("Aufbau Datenbank-ConnectionPool f\u00fcr Tests");
        try {
            SxPool connectionPool = new SxPool("test", dbProperties);
            logger.debug((Object)"OK");
            logger.debug((Object)("           eingeschr\u00e4nkter Datenbankuser f\u00fcr Verbindung: " + connectionPool.isRestrictedConnection()));
            logger.debug((Object)("           public/private key" + (connectionPool.hasDSAHandler() ? " aktiv " : " nicht aktiv")));
            pools.add(connectionPool);
        }
        catch (Exception e) {
            logger.debug((Object)("ERROR: Aufbau Test-Verbindung f\u00fcr " + SxSQL_Server.DEFAULT_MANDANTEN_ID + " nicht erfolgreich (" + String.valueOf(e) + ")"));
        }
    }

    public static void initTesting(DataSource dataSource) {
        hasMandanten = false;
        System.out.print("Aufbau Datenbank-ConnectionPool f\u00fcr Tests");
        try {
            SxPool connectionPool = new SxPool("test", dataSource);
            logger.debug((Object)"OK");
            logger.debug((Object)("           eingeschr\u00e4nkter Datenbankuser f\u00fcr Verbindung: " + connectionPool.isRestrictedConnection()));
            logger.debug((Object)("           public/private key" + (connectionPool.hasDSAHandler() ? " aktiv " : " nicht aktiv")));
            pools.add(connectionPool);
            connectionPool.init();
        }
        catch (Exception e) {
            logger.debug((Object)("ERROR: Aufbau Test-Verbindung f\u00fcr " + SxSQL_Server.DEFAULT_MANDANTEN_ID + " nicht erfolgreich (" + String.valueOf(e) + ")"));
        }
    }

    private static List<String> readNamen(File mandantenFile) throws FileNotFoundException, IOException {
        String line;
        LinkedList<String> mandantenNamen = new LinkedList<String>();
        FileReader fr = new FileReader(mandantenFile);
        BufferedReader bfr = new BufferedReader(fr);
        while ((line = bfr.readLine()) != null) {
            mandantenNamen.add(line);
        }
        bfr.close();
        fr.close();
        return mandantenNamen;
    }

    public static void init(List<String> mandantenNamen) {
        hasMandanten = mandantenNamen.size() > 1;
        for (String name : mandantenNamen) {
            SxPools.createPoolFor(name);
        }
    }

    private static void createPoolFor(String mandantenName) {
        System.out.print("Aufbau Datenbank-ConnectionPool f\u00fcr " + mandantenName);
        try {
            SxPool connectionPool = new SxPool(mandantenName, new Properties());
            try (Connection con = connectionPool.getConnection();){
                System.out.println(" (" + con.getMetaData().getURL() + ") OK");
                logger.debug((Object)"OK");
                logger.debug((Object)("           eingeschr\u00e4nkter Datenbankuser f\u00fcr Verbindung: " + connectionPool.isRestrictedConnection()));
                logger.debug((Object)("           public/private key" + (connectionPool.hasDSAHandler() ? " aktiv " : " nicht aktiv")));
                pools.add(connectionPool);
            }
            catch (Exception e) {
                logger.debug((Object)("ERROR: Verbindung f\u00fcr " + mandantenName + " nicht erfolgreich (" + String.valueOf(e) + ")"));
            }
        }
        catch (DBServletException | IOException | SQLException e) {
            logger.debug((Object)("ERROR: Verbindung f\u00fcr " + mandantenName + " nicht erfolgreich (" + String.valueOf(e) + ")"));
        }
    }

    public static void closeAll() throws Exception {
        for (SxPool pool : pools) {
            pool.close();
        }
        pools.clear();
    }

    public static void main(String[] args) {
        try {
            SxPools.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void invalidate(String poolname, Connection con) throws DBServletException {
        if (!pools.containsItemWithName(poolname)) {
            throw new DBServletException("Kann Connection nicht invalidieren - kein Datenbank-ConnectionPool " + poolname + " gefunden.");
        }
        try {
            if (SxSQL_Server.DEFAULT_MANDANTEN_ID.equals(poolname) || "test".equals(poolname)) {
                SxPool pool = SxPools.get(poolname);
                pool.evictConnection(con);
                con.close();
            } else {
                PoolingDriver driver = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:" + poolname);
                driver.invalidateConnection(con);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DBServletException("Invalidating connection failed -" + String.valueOf(e));
        }
    }

    public static String getPoolFinRechteInfos() {
        StringBuffer result = new StringBuffer();
        for (SxPool aPool : pools) {
            result.append("Mandant: " + aPool.getName() + " - SxFinRechtevariante:" + aPool.getFinRightVariantName() + "<br>");
        }
        return result.toString();
    }

    public static void resetAllPools() throws TransformerConfigurationException, SQLException, DBServletException {
        for (SxPool aPool : pools) {
            try {
                aPool.init();
            }
            catch (Exception e) {
                logger.debug((Object)("ERROR: Datenreset f\u00fcr " + aPool.getName() + " fehlgeschlagen:" + String.valueOf(e)));
                e.printStackTrace();
            }
        }
        logger.debug((Object)(DateUtils.getNowString() + " Alle SuperX-Pools neu geladen"));
    }

    public static void clearLogFiles() throws IOException {
        for (SxPool aPool : pools) {
            aPool.clearLogFiles();
        }
    }
}

