/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.superx.common.DBServletException;
import de.superx.common.SuperX_el;
import de.superx.servlet.AbstractSuperXServlet;
import de.superx.servlet.SessionAttribute;
import de.superx.servlet.SuperXManager;
import de.superx.servlet.SuperXServletHelper;
import de.superx.servlet.SxPools;
import de.superx.servlet.SxSQL_Server;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class SuperXmlAbmeldung
extends AbstractSuperXServlet {
    private static final long serialVersionUID = 1L;

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.logoutOfSaiku(request);
        HttpSession session = request.getSession(false);
        String mandantenID = SxSQL_Server.DEFAULT_MANDANTEN_ID;
        if (session != null && session.getAttribute(SessionAttribute.MandantenID.toString()) != null) {
            mandantenID = (String)session.getAttribute(SessionAttribute.MandantenID.toString());
        }
        if (SxPools.get(mandantenID).isErweitertesProtokollWanted()) {
            SuperXmlAbmeldung.protokollieren(request, mandantenID);
        }
        SuperXServletHelper.removeCookie(request, response);
        if (session != null) {
            session.invalidate();
        }
        if (!SuperXManager.isHis1) {
            request.logout();
        }
        String redirect = null;
        redirect = SuperXManager.isHis1() ? "/" + SuperXManager.his1_refapp : "/superx/index.jsp?MandantenID=" + mandantenID;
        response.sendRedirect(redirect);
    }

    private static void protokollieren(HttpServletRequest request, String mandantenID) {
        String userid = "-1";
        HttpSession session = request.getSession(true);
        if (session.getAttribute(SessionAttribute.UserID.toString()) != null) {
            userid = session.getAttribute(SessionAttribute.UserID.toString()).toString();
        }
        SuperX_el aSuperX_el = new SuperX_el();
        SxSQL_Server aQuery = null;
        String client_ip = request.getRemoteAddr();
        String client_dns = request.getRemoteHost();
        Connection dbConnection = null;
        try {
            aQuery = new SxSQL_Server(mandantenID);
            dbConnection = SxPools.getConnection(mandantenID);
            Object sql = "insert into protokoll (proto_fkt_id, userinfo_id, ";
            sql = (String)sql + "ip_adresse, client_name, zeitpunkt) values (";
            sql = (String)sql + "4, " + userid + ", '" + client_ip;
            sql = (String)sql + "', '" + client_dns + "'";
            sql = SxPools.get(mandantenID).getSqlDialect().equals("Postgres") ? (String)sql + ", now());" : (String)sql + ", current);";
            aQuery.execute((String)sql, dbConnection, aSuperX_el);
            dbConnection.close();
        }
        catch (SQLException e) {
            try {
                SxPools.invalidate(mandantenID, dbConnection);
            }
            catch (DBServletException e1) {
                Logger.getLogger((String)("superx_" + mandantenID)).log((Priority)Level.ERROR, (Object)e1.toString());
                aSuperX_el.setError_String(e.getSQLState());
            }
            Logger.getLogger((String)("superx_" + mandantenID)).log((Priority)Level.ERROR, (Object)e.getSQLState());
            aSuperX_el.setError_String(e.getSQLState());
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    public String getServletInfo() {
        return "<i>SuperXmlAnmeldung-Servlet, v4</i>";
    }
}

