/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import com.google.common.io.ByteStreams;
import de.destatis.core.generator.SurveyDataDocumentGeneratorException;
import de.destatis.core.inspector.InspectionProblem;
import de.destatis.core.inspector.InspectionReport;
import de.destatis.core.inspector.ProblemPosition;
import de.superx.common.InvalidDataTypeException;
import de.superx.common.InvalidKeyException;
import de.superx.common.Maske;
import de.superx.servlet.RequestParameter;
import de.superx.servlet.ServletBasics;
import de.superx.servlet.SxPools;
import de.superx.stat.DistributionType;
import de.superx.stat.StatisticExport;
import de.superx.util.PathAndFileUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementCreatorFactory;

public class StatisticExporter {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private Maske maske;
    String plausiKategorie;
    static Logger logger = LoggerFactory.getLogger(StatisticExport.class);

    public StatisticExporter(HttpServletRequest request, HttpServletResponse response, Maske maske) {
        this.request = request;
        this.response = response;
        this.maske = maske;
    }

    public boolean xmlStatisticExport(String ausgabeFormat) throws IOException, InvalidKeyException, InvalidDataTypeException, SurveyDataDocumentGeneratorException {
        String dir = ServletBasics.getParamChecked(this.request, this.maske, RequestParameter.statdir.toString());
        String lieferung = ServletBasics.getParamChecked(this.request, this.maske, RequestParameter.Lieferung.toString());
        String semester = ServletBasics.getParamChecked(this.request, this.maske, RequestParameter.berichtssemester.toString());
        String inspectionLevel = ServletBasics.getParamChecked(this.request, this.maske, RequestParameter.Pr\u00fcfstufe.toString());
        this.plausiKategorie = ServletBasics.getParamChecked(this.request, this.maske, RequestParameter.Plausibilisierung.toString());
        String stand = ServletBasics.getParamChecked(this.request, this.maske, RequestParameter.stand.toString());
        String standort = ServletBasics.getParamChecked(this.request, this.maske, RequestParameter.Hochschulstandort.toString());
        String melderVorname = ServletBasics.getParamChecked(this.request, this.maske, RequestParameter.Vorname.toString());
        String melderName = ServletBasics.getParamChecked(this.request, this.maske, RequestParameter.Nachname.toString());
        String kennung = ServletBasics.getParamChecked(this.request, this.maske, RequestParameter.Kennung.toString());
        DistributionType distributionType = this.determineDistributionType(ausgabeFormat, lieferung);
        String where = null;
        if (standort != null && !standort.isEmpty()) {
            if (distributionType == DistributionType.GUEST_LISTENERS2019) {
                where = "ef002='" + standort + "'";
            } else if (distributionType == DistributionType.STUDENTS2016 || distributionType == DistributionType.EXAMINATIONS2016 || distributionType == DistributionType.EXAMINATIONS2016_SHORT) {
                where = "ef004='" + standort + "'";
            }
        }
        logger.info("Lieferungsart: " + lieferung);
        logger.info("Ausgabeformat: " + ausgabeFormat);
        logger.info("Plausi: " + this.plausiKategorie);
        String webinfPath = PathAndFileUtils.getWebinfPath();
        String statDir = webinfPath + File.separator + dir;
        logger.info("STAT DIR: " + statDir);
        StatisticExport statExport = new StatisticExport(distributionType, statDir, where);
        DataSource datasource = SxPools.get(this.maske.getMandantenId()).getDataSource();
        statExport.setDataSource(datasource);
        int offset = this.getOffset();
        if (!"1".equals(this.plausiKategorie) && offset == 0) {
            statExport.doPlausi(this.plausiKategorie);
        }
        if (ausgabeFormat.equals("text/html")) {
            return false;
        }
        StatisticExport.ExportFormat exportFormat = StatisticExport.ExportFormat.getForMimeType(ausgabeFormat);
        if (exportFormat == StatisticExport.ExportFormat.UNKNOWN) {
            throw new RuntimeException("Unbekanntes Ausgabeformat: " + ausgabeFormat);
        }
        statExport.setMelderName(melderName);
        statExport.setMelderVorname(melderVorname);
        statExport.setKennung(kennung);
        String shortDataSetFileNamePart = distributionType == DistributionType.EXAMINATIONS2016_SHORT ? "kurz_" : "";
        Object fileName = distributionType.getDescription() + "_statistik_" + shortDataSetFileNamePart + semester.replaceAll("\\/", "-") + "_" + stand + ".";
        fileName = ((String)fileName).replaceAll(" ", "_");
        if (exportFormat == StatisticExport.ExportFormat.ZIP) {
            fileName = this.createZipWithInspectorReport(inspectionLevel, statExport, (String)fileName);
        } else if ("2".equals(this.plausiKategorie) || "3".equals(this.plausiKategorie)) {
            fileName = this.createZipWithPlausis(statExport, exportFormat, (String)fileName);
        } else {
            fileName = (String)fileName + exportFormat.getExtension();
            Path tmp = Files.createTempFile("stat", "stud", new FileAttribute[0]);
            try (BufferedOutputStream tmpOut = new BufferedOutputStream(new FileOutputStream(tmp.toFile()));){
                statExport.getOutput(exportFormat.getMimeType(), tmpOut);
                this.outputToResponse((String)fileName, tmp.toFile());
            }
        }
        this.updateExportfileInDb(distributionType, datasource, (String)fileName);
        return true;
    }

    private void updateExportfileInDb(DistributionType distributionType, DataSource datasource, String fileName) {
        JdbcTemplate jt = new JdbcTemplate(datasource);
        String lieferungsArt = distributionType.getDescription().toLowerCase();
        if (distributionType == DistributionType.STUDENTS2016 || distributionType == DistributionType.EXAMINATIONS2016 || distributionType == DistributionType.EXAMINATIONS2016_SHORT) {
            lieferungsArt = "statistik2016";
        }
        String infoTable = distributionType == DistributionType.DOCTORAL_CANDIDATE ? "prom_stat_info" : "astat_info";
        String filenameUpdateSql = "update " + infoTable + " set exportfile=? where lieferungsart=?";
        PreparedStatementCreatorFactory pscf = new PreparedStatementCreatorFactory(filenameUpdateSql, new int[]{12, 12});
        PreparedStatementCreator psc = pscf.newPreparedStatementCreator(new Object[]{fileName, lieferungsArt});
        jt.update(psc);
    }

    private String createZipWithPlausis(StatisticExport statExport, StatisticExport.ExportFormat exportFormat, String fileName) throws IOException, SurveyDataDocumentGeneratorException, FileNotFoundException {
        Path tmp = Files.createTempFile("stat", "stud", new FileAttribute[0]);
        try (BufferedOutputStream tmpOut = new BufferedOutputStream(new FileOutputStream(tmp.toFile()));){
            statExport.getOutput(exportFormat.getMimeType(), tmpOut);
        }
        this.response.setHeader("Content-disposition", "attachment; filename=statistik.zip");
        this.response.setHeader("Cache-Control", "expires=0");
        Object resultFileName = fileName;
        try (ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)this.response.getOutputStream());){
            resultFileName = (String)resultFileName + exportFormat.getExtension();
            zipOutputStream.putNextEntry(new ZipEntry((String)resultFileName));
            BufferedInputStream tmpIn = new BufferedInputStream(new FileInputStream(tmp.toFile()));
            ByteStreams.copy((InputStream)tmpIn, (OutputStream)zipOutputStream);
            zipOutputStream.putNextEntry(new ZipEntry("plausi.csv"));
            statExport.readPlausiFromDb(this.plausiKategorie, zipOutputStream);
        }
        return resultFileName;
    }

    private String createZipWithInspectorReport(String inspectionLevel, StatisticExport statExport, String fileName) throws IOException, SurveyDataDocumentGeneratorException, FileNotFoundException {
        Path tmp = Files.createTempFile("stat", "stud", new FileAttribute[0]);
        try (BufferedOutputStream tmpOut = new BufferedOutputStream(new FileOutputStream(tmp.toFile()));){
            statExport.generate(tmpOut);
        }
        this.response.setHeader("Content-disposition", "attachment; filename=statistik.zip");
        this.response.setHeader("Cache-Control", "expires=0");
        Object resultFileName = fileName;
        try (ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)this.response.getOutputStream());){
            resultFileName = (String)resultFileName + "xml";
            ZipEntry entry = new ZipEntry((String)resultFileName);
            zipOutputStream.putNextEntry(entry);
            BufferedInputStream tmpIn = new BufferedInputStream(new FileInputStream(tmp.toFile()));
            ByteStreams.copy((InputStream)tmpIn, (OutputStream)zipOutputStream);
            if (inspectionLevel != null) {
                int inspectionLevelInt = Integer.parseInt(inspectionLevel);
                InspectionReport report = statExport.getInspectionReport(new BufferedInputStream(new FileInputStream(tmp.toFile())), inspectionLevelInt);
                entry = new ZipEntry("inspection_report.txt");
                zipOutputStream.putNextEntry(entry);
                List problems = report.getProblemList();
                for (InspectionProblem problem : problems) {
                    ProblemPosition position = problem.getPosition();
                    String line = String.format("Problem: Zeile %d, Spalte %d: %s\n", position.getLine(), position.getColumn(), problem.getComment());
                    zipOutputStream.write(line.getBytes());
                }
            }
        }
        return resultFileName;
    }

    private DistributionType determineDistributionType(String ausgabeFormat, String lieferung) {
        switch (lieferung.toLowerCase()) {
            case "2": {
                return DistributionType.STUDENTS2016;
            }
            case "3": {
                if (ausgabeFormat.endsWith("kurz")) {
                    return DistributionType.EXAMINATIONS2016_SHORT;
                }
                return DistributionType.EXAMINATIONS2016;
            }
            case "4": {
                return DistributionType.GUEST_LISTENERS2019;
            }
            case "5": {
                return DistributionType.DOCTORAL_CANDIDATE;
            }
        }
        return null;
    }

    private int getOffset() {
        String offs = ServletBasics.getParameter(this.request, RequestParameter.offset);
        int offset = offs == null || offs.isEmpty() ? 0 : Integer.parseInt(offs);
        return offset;
    }

    private void outputToResponse(String fileName, File tmpFile) throws IOException {
        this.response.setHeader("Content-disposition", "attachment; filename=" + fileName);
        this.response.setHeader("Cache-Control", "expires=0");
        BufferedInputStream tmpIn = new BufferedInputStream(new FileInputStream(tmpFile));
        ByteStreams.copy((InputStream)tmpIn, (OutputStream)this.response.getOutputStream());
    }
}

