/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.memtext.db.NichtAngemeldetException;
import de.memtext.tree.KeyParentEqualException;
import de.memtext.util.DateUtils;
import de.memtext.util.EqualsUtil;
import de.memtext.util.LogUtils;
import de.memtext.util.ServletHelper;
import de.memtext.util.StringUtils;
import de.superx.common.DBServletException;
import de.superx.common.InvalidKeyException;
import de.superx.common.SichtException;
import de.superx.common.SxUser;
import de.superx.servlet.AbstractSuperXServlet;
import de.superx.servlet.ServletUtils;
import de.superx.servlet.SuperXManager;
import de.superx.servlet.SuperXServletHelper;
import de.superx.servlet.SxPools;
import de.superx.util.SqlStringUtils;
import freemarker.template.TemplateException;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.dom4j.DocumentException;
import org.xml.sax.SAXException;

public class GxstageUserRights
extends AbstractSuperXServlet {
    private static final long serialVersionUID = 1L;
    private static final String VERSION = "1.0 2021-09-14";
    private static final Logger logger = Logger.getLogger((String)"gxstageuserrights");
    private static DateFormat timeFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm");
    private HashMap<String, String> hhprogListe = new HashMap();
    private HashMap<String, String> finanzstellenListe = new HashMap();
    private HashMap<String, String> fiposListe = new HashMap();
    private HashMap<String, String> fondsListe = new HashMap();
    private HashMap<String, String> projToInstListe = new HashMap();
    private HashMap<String, String> kostenstellenArtK = new HashMap();
    private HashMap<String, String> hhprog_zugeordneter_fonds = new HashMap();

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            String logfile = this.getLogDir() + "/gxstage_servlet.log";
            LogUtils.initRawFileDateTime("gxstageuserrights", logfile, 20000, 1, true, true);
        }
        catch (IOException e) {
            throw new IllegalStateException("Konnte gxstageServlet Logging nicht aufbauen", e);
        }
        logger.setLevel(Level.TRACE);
        logger.info((Object)"Starte Version 1.0 2021-09-14");
        System.out.println("Starte GxstageServlet 1.0 2021-09-14");
    }

    private String getLogDir() {
        Object targetDir = SuperXManager.getWEB_INFPfad() + File.separator + "logs";
        File f = new File((String)targetDir);
        if (!f.exists()) {
            f.mkdir();
        }
        if (System.getProperty("SX_LOG_TO_TMP") != null && System.getProperty("SX_LOG_TO_TMP").equalsIgnoreCase("true")) {
            targetDir = System.getProperty("java.io.tmpdir");
        }
        return targetDir;
    }

    public String getServletInfo() {
        return "GxstageUserRights";
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        GxstageUserRights.setEncoding(request);
        GxstageHelper n = new GxstageHelper(request, response);
        n.run(true);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    public void destroy() {
        Enumeration appenders = Logger.getLogger((String)logger.getName()).getAllAppenders();
        Iterator it = appenders.asIterator();
        while (it.hasNext()) {
            ((Appender)it.next()).close();
        }
    }

    static String getStackTrace(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    private class GxstageHelper
    extends SuperXServletHelper {
        private final SxUser user;
        private final DateFormat dfLong;

        public GxstageHelper(HttpServletRequest request, HttpServletResponse response) throws IOException {
            super(request, response);
            this.dfLong = new SimpleDateFormat("dd.MM.yyyy");
            this.user = (SxUser)request.getSession().getAttribute("user");
        }

        private String getNowString() {
            return StringUtils.replace(timeFormat.format(new java.util.Date()), " ", "<br/>");
        }

        private synchronized Date parseStrict(String dateStr) throws ParseException {
            java.util.Date dt = this.dfLong.parse(dateStr);
            return new Date(dt.getTime());
        }

        @Override
        protected void perform() throws SQLException, DBServletException, TransformerException, KeyParentEqualException, NichtAngemeldetException, IOException, ParseException, ParserConfigurationException, FactoryConfigurationError, SAXException, DocumentException, IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, CloneNotSupportedException, TemplateException, InvalidKeyException, SichtException, IOException, ServletException {
            String action;
            if (this.user == null) {
                throw new IllegalStateException("Kein user in der Session gefunden - bitte Browser neu starten!");
            }
            if (this.user.getMaskRights().indexOf("18004400") == -1) {
                throw new IllegalStateException("Keine Berechtigung gefunden");
            }
            this.userid = this.request.getSession().getAttribute("UserID").toString();
            if (GxstageUserRights.this.finanzstellenListe.size() == 0 || GxstageUserRights.this.hhprogListe.size() == 0 || GxstageUserRights.this.fiposListe.size() == 0 || GxstageUserRights.this.fondsListe.size() == 0) {
                String string = this.getkeys();
            }
            String result = "";
            switch (action = ServletHelper.getParameterString((ServletRequest)this.request, "action")) {
                case "getkeys": {
                    result = this.getkeys();
                    break;
                }
                case "getname": {
                    result = this.getName(ServletHelper.getParameterString((ServletRequest)this.request, "field"), ServletHelper.getParameterString((ServletRequest)this.request, "id"));
                    break;
                }
                case "delete": {
                    result = this.delete(ServletHelper.getParameterString((ServletRequest)this.request, "tid"));
                    break;
                }
                case "save": {
                    result = this.save();
                    break;
                }
                case "getinst": {
                    result = this.getInst();
                    break;
                }
                case "gethhprog_zugeordneter_fonds": {
                    result = this.getHHprogZugordneterFonds();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("GxstageUserRights Unknown action:" + action);
                }
            }
            this.turnCacheOff();
            logger.info((Object)result);
            this.sendBack(result, "text/json");
        }

        private String getHHprogZugordneterFonds() {
            String hhprog = "";
            String result = "";
            try {
                hhprog = this.getParam("hhprog");
            }
            catch (IllegalArgumentException e) {
                result = "clear";
            }
            if (GxstageUserRights.this.hhprog_zugeordneter_fonds.containsKey(hhprog)) {
                result = GxstageUserRights.this.hhprog_zugeordneter_fonds.get(hhprog);
            }
            return "{\"fonds\":\"" + result + "\"}";
        }

        private String getInst() {
            String hhprog = "";
            String result = "";
            try {
                hhprog = this.getParam("hhprog");
            }
            catch (IllegalArgumentException e) {
                result = "clear";
            }
            if (GxstageUserRights.this.projToInstListe.containsKey(hhprog)) {
                result = GxstageUserRights.this.projToInstListe.get(hhprog);
            }
            return "{\"inst\":\"" + result + "\"}";
        }

        private String adaptForJson(String input) {
            return StringUtils.replace(input, "\"", "\\\"");
        }

        private String getkeys() {
            String result = "FEHLER";
            try {
                Connection con = SxPools.get("default").getConnection();
                StringBuffer systemErrors = new StringBuffer();
                Statement stm = con.createStatement();
                this.initListe(GxstageUserRights.this.hhprogListe, stm, "select G.apnr, min(druck) from (select apnr,max(coalesce(d_akt_bis,'3000-01-01')) as max_gueltig from gxstage_cifx where key=3 group by apnr) R inner join gxstage_cifx G on G.apnr=R.apnr and coalesce(G.d_akt_bis,'3000-01-01')=R.max_gueltig and G.key=3 group by 1");
                GxstageUserRights.this.hhprogListe.put("0", "Alle PSP-Elemente");
                this.initListe(GxstageUserRights.this.finanzstellenListe, stm, "select G.apnr,min(druck) from (select apnr,max(coalesce(d_akt_bis,'3000-01-01')) as max_gueltig from gxstage_cifx where key=5 group by apnr) R inner join gxstage_cifx G on  G.apnr=R.apnr and coalesce(G.d_akt_bis,'3000-01-01')=R.max_gueltig and G.key=5 group by 1");
                GxstageUserRights.this.finanzstellenListe.put("0", "Alle Finanzstellen");
                this.initListe(GxstageUserRights.this.fondsListe, stm, "select G.ggnr,min(ggdruck) from (select ggnr,max(coalesce(key_bis,'3000-01-01')) as max_gueltig from gxstage_gege group by 1) R inner join gxstage_gege G on G.ggnr=R.ggnr and coalesce(G.key_bis,'3000-01-01')=R.max_gueltig group by 1");
                GxstageUserRights.this.fondsListe.put("0", "Alle Fonds");
                this.initListe(GxstageUserRights.this.fiposListe, stm, "select key,kbez from gxstage_fipos where variante=3");
                GxstageUserRights.this.fiposListe.put("0", "Alle Sachkonten");
                this.initListe(GxstageUserRights.this.projToInstListe, stm, "select distinct P.apnr as proj,F.verantw from (select apnr as finanzstelle,parent as verantw from gxstage_cifx where key=5) F inner join gxstage_cifx P on  key=3 and F.finanzstelle=P.intern_c where apnr is not null and verantw is not null");
                this.initListe(GxstageUserRights.this.kostenstellenArtK, stm, "SELECT distinct wert,bez_lang FROM gxmx_kostl  WHERE not ist_blatt");
                this.initListe(GxstageUserRights.this.hhprog_zugeordneter_fonds, stm, "select distinct prps_posid,prps_usr02 from gxstage_sap_sc04 where length(prps_posid)=10 and prps_usr02 is not null");
                result = "SUCCESS";
                stm.close();
                con.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
                logger.error((Object)("Fehler bei initialem Schl\u00fcsseleinlesen " + GxstageUserRights.getStackTrace(e)));
                result = this.adaptForJson("FEHLER " + String.valueOf(e));
            }
            return "{\"result\":\"" + result + "\"}";
        }

        private void initListe(HashMap<String, String> liste, Statement stm, String query) throws SQLException {
            ResultSet rs = stm.executeQuery(query);
            liste.clear();
            while (rs.next()) {
                liste.put(rs.getString(1), rs.getString(2));
            }
            rs.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String save() {
            Date befrDat = null;
            Connection con = null;
            Object result = "";
            String zeilennummer = "unbekannt";
            try {
                zeilennummer = this.getParam("zeilennummer");
                String anmerkung = this.getParam("anmerkung");
                String tid = this.getParam("tid");
                String befristung = this.getParam("befristung");
                String unterzeichner = this.getParam("unterzeichner");
                int unterzeichnerId = -1;
                String userparam = this.getParam("user");
                if (befristung != null && !befristung.equals("")) {
                    try {
                        befrDat = this.parseStrict(befristung);
                    }
                    catch (ParseException e) {
                        logger.debug((Object)("wrong input:" + befristung));
                        throw new IllegalArgumentException("Befristungsdatum im Format dd.mm.jjjj angeben");
                    }
                }
                con = SxPools.get(this.getMandantenID()).getConnection();
                if (unterzeichner != null && !unterzeichner.trim().equals("")) {
                    unterzeichnerId = this.getUserId(con, unterzeichner);
                }
                int userparamInt = this.getUserId(con, userparam);
                if (tid != null && !tid.equals("")) {
                    result = this.updateDatensatz(con, tid, anmerkung, userparamInt, unterzeichnerId, befrDat);
                } else {
                    String rolle = this.getParam("rolle");
                    String hhprog = this.getParam("hhprog");
                    String finanzstelle = this.getParam("finanzstelle");
                    String fonds = this.getParam("fonds");
                    String fipos = this.getParam("fipos");
                    String startjahr = this.getParam("startjahr");
                    boolean zugeordneterFondsWanted = true;
                    String paramZugeordneterFondsWanted = this.getParam("zugeordneterFondsWanted");
                    if (paramZugeordneterFondsWanted != null && paramZugeordneterFondsWanted.toLowerCase().contentEquals("false")) {
                        zugeordneterFondsWanted = false;
                    }
                    this.checkRollenRegeln(rolle, hhprog, finanzstelle, fonds, zugeordneterFondsWanted);
                    if (this.alreadyExists(con, rolle, userparamInt, finanzstelle, hhprog, fonds, fipos, unterzeichnerId)) {
                        String msg = "Zeile " + zeilennummer + " Es existiert bereits ein Datensatz mit gleicher Kombination aus Rolle, User, PSP-Element, Kostenstelle, Fonds, Sachkonto";
                        if (this.isUnterzeichnerCheckWanted(rolle)) {
                            msg = msg + " und Unterzeichner";
                        }
                        result = "{\"result\":\"FEHLER " + msg + "\"}";
                    } else {
                        result = this.insertDatensatz(con, tid, anmerkung, rolle, userparamInt, finanzstelle, hhprog, fonds, fipos, startjahr, unterzeichnerId, befrDat);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)("Fehler beim Speichern: " + GxstageUserRights.getStackTrace(e)));
                String msg = e.getLocalizedMessage();
                if (msg.indexOf("duplicate key value violates unique constraint") > -1) {
                    msg = " Es existiert bereits ein Datensatz mit gleicher Kombination aus Rolle, User, PSP-Element, Kostenstelle, Fonds, Sachkonto und Unterzeichner";
                }
                msg = StringUtils.replace(msg, "\"", "'");
                result = "{\"result\":\"FEHLER Zeile " + zeilennummer + " " + msg + "\"}";
            }
            finally {
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            return result;
        }

        private void checkRollenRegeln(String rolle, String hhprog, String finanzstelle, String fonds, boolean zugeordneterFondsWanted) {
            StringBuffer errorMessages = new StringBuffer();
            switch (rolle.toUpperCase()) {
                case "UAH": {
                    if (!GxstageUserRights.this.kostenstellenArtK.containsKey(finanzstelle)) {
                        errorMessages.append("NNNBei Rolle UAH muss Finanzstelle ART=K sein (meist Endung auf 00000)");
                    }
                    if (!hhprog.equals("1*,2*,5*,6*,7*,9999")) {
                        errorMessages.append("NNNBei Rolle UAH muss PSP=1*,2*,5*,6*,7*,9999 sein.");
                    }
                    if (fonds.equals("-1060")) break;
                    errorMessages.append("NNNBei Rolle UAH muss Fonds -1060 sein.");
                    break;
                }
                case "AOB": 
                case "LB": {
                    if (hhprog.length() == 10) {
                        if (!finanzstelle.contentEquals(GxstageUserRights.this.projToInstListe.get(hhprog))) {
                            errorMessages.append("NNNBei Rolle " + rolle + " und PSP " + hhprog + " muss die der verantwortlichen \u00fcbergeordnete Finanzstelle eingetragen sein. (" + GxstageUserRights.this.projToInstListe.get(hhprog) + ")");
                        }
                        if (zugeordneterFondsWanted && !fonds.contentEquals(GxstageUserRights.this.hhprog_zugeordneter_fonds.get(hhprog))) {
                            errorMessages.append("NNNBei Rolle " + rolle + " und PSP " + hhprog + " muss der Fonds " + GxstageUserRights.this.hhprog_zugeordneter_fonds.get(hhprog) + " sein.");
                        }
                    }
                    if (!hhprog.contentEquals("9999")) break;
                    if (GxstageUserRights.this.kostenstellenArtK.containsKey(finanzstelle)) {
                        errorMessages.append("NNNBei Rolle " + rolle + " und PSP=9999 darf Finanzstelle nicht ART=K sein (meist Endung auf 00000)");
                    }
                    boolean isFondsOk = false;
                    switch (fonds) {
                        case "1000": 
                        case "1002": 
                        case "1020": 
                        case "1030": 
                        case "1175": 
                        case "1188": {
                            isFondsOk = true;
                        }
                    }
                    if (isFondsOk) break;
                    errorMessages.append("NNNBei " + rolle + " mit PSP-Element-Dummy 9999 muss genau einer der Fonds 1000, 1002, 1020, 1030, 1175 oder 1188 ausgew\u00e4hlt werden.");
                    break;
                }
                case "BKU": {
                    if (!GxstageUserRights.this.kostenstellenArtK.containsKey(finanzstelle)) {
                        errorMessages.append("NNNBei Rolle BKU muss Finanzstelle ART=K sein (meist Endung auf 0000)");
                    }
                    if (!hhprog.equals("9999")) {
                        errorMessages.append("NNNBei Rolle BKU muss PSP=9999 sein.");
                    }
                    boolean isFondsOk = false;
                    switch (fonds) {
                        case "1000,1002,1020,1030,1175,1188": 
                        case "1000": 
                        case "1002": 
                        case "1020": 
                        case "1030": 
                        case "1000,1002": 
                        case "1000,1020": 
                        case "1000,1030": {
                            isFondsOk = true;
                        }
                    }
                    if (isFondsOk) break;
                    errorMessages.append("NNNBei Rolle BKU nur spezielle Fonds erlaubt");
                }
            }
            if (errorMessages.length() > 0) {
                throw new IllegalArgumentException("Ung\u00fcltige Eingabe " + String.valueOf(errorMessages));
            }
        }

        private boolean alreadyExists(Connection con, String rolle, int userparamInt, String finanzstelle, String hhprog, String fonds, String fipos, int unterzeichnerId) throws SQLException {
            boolean result = false;
            Object sql = "select count(*) from gxstage_user_rights where status=1 and upper(rolle)=? and userinfo_id=? and finanzstelle=? and hhprog=? and fonds=? and fipos=? ";
            if (this.isUnterzeichnerCheckWanted(rolle)) {
                sql = (String)sql + "and unterzeichner=?";
            }
            PreparedStatement pst = con.prepareStatement((String)sql);
            pst.setString(1, rolle.toUpperCase());
            pst.setInt(2, userparamInt);
            pst.setString(3, finanzstelle);
            pst.setString(4, hhprog);
            pst.setString(5, fonds);
            pst.setString(6, fipos);
            if (this.isUnterzeichnerCheckWanted(rolle)) {
                pst.setInt(7, unterzeichnerId);
            }
            ResultSet rs = pst.executeQuery();
            int count = 0;
            while (rs.next()) {
                count = rs.getInt(1);
            }
            rs.close();
            pst.close();
            if (count > 0) {
                result = true;
            }
            return result;
        }

        private boolean isUnterzeichnerCheckWanted(String rolle) {
            return rolle.toUpperCase().contentEquals("LB");
        }

        private String insertDatensatz(Connection con, String tid, String anmerkung, String rolle, int userparamInt, String finanzstelle, String hhprog, String fonds, String fipos, String startjahr, int unterzeichnerId, Date befrDat) throws SQLException {
            Object result = "";
            PreparedStatement pst = con.prepareStatement("insert into gxstage_user_rights (userinfo_id, \n       finanzstelle, \n       hhprog, \n       fonds, \n       fipos, \n      startjahr,  unterzeichner, \n       erfasst_am, \n       erfasst_durch, \n       anmerkung, \n       status, \n       rolle, \n       befristung) values (?,?,?,?,?,?,?,now()," + this.userid + ",?,1,?,?) returning tid");
            pst.setInt(1, userparamInt);
            pst.setString(2, finanzstelle);
            pst.setString(3, hhprog);
            pst.setString(4, fonds);
            pst.setString(5, fipos);
            if (startjahr == null) {
                pst.setNull(6, 0);
            } else {
                pst.setInt(6, Integer.parseInt(startjahr));
            }
            pst.setInt(7, unterzeichnerId);
            pst.setString(8, anmerkung);
            pst.setString(9, rolle);
            pst.setDate(10, befrDat);
            ResultSet rs = pst.executeQuery();
            int newTid = -1;
            while (rs.next()) {
                newTid = rs.getInt(1);
            }
            rs.close();
            pst.close();
            result = "{\"result\":\"" + (String)result + "\",\"tid\":\"" + newTid + "\",\"erfasst_am\":\"" + this.getNowString() + "\",\"erfasst_name\":\"" + this.user.getName() + "\"}";
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String updateDatensatz(Connection con, String tid, String anmerkung, int userparamInt, int unterzeichnerId, Date befrDat) throws SQLException {
            Object result = "";
            if (this.hasUserBefristungOrUnterzeichnerChanged(con, tid, userparamInt, unterzeichnerId, befrDat)) {
                try {
                    con.setAutoCommit(false);
                    String sql = " insert into gxstage_user_rights ( \n       userinfo_id, \n       finanzstelle, \n       hhprog, \n       fonds, \n       fipos, startjahr,\n       unterzeichner, \n       erfasst_am, \n       erfasst_durch, \n       aktualisiert_am, \n       aktualisiert_durch, \n ersetzt_tid,       anmerkung, \n       status, \n       rolle, \n       befristung \n)  select      ?, \n       finanzstelle, \n       hhprog, \n       fonds, \n       fipos,startjahr, \n      ?, \n       erfasst_am, \n       erfasst_durch, \n       aktualisiert_am, \n       aktualisiert_durch, " + tid + ", ?, \n       1, \n       rolle, \n       ? \nFROM gxstage_user_rights where tid=? returning tid";
                    PreparedStatement pst = con.prepareStatement(sql);
                    pst.setInt(1, userparamInt);
                    pst.setInt(2, unterzeichnerId);
                    pst.setString(3, anmerkung);
                    pst.setDate(4, befrDat);
                    pst.setInt(5, Integer.parseInt(tid));
                    ResultSet rs = pst.executeQuery();
                    int newTid = -1;
                    while (rs.next()) {
                        newTid = rs.getInt(1);
                    }
                    rs.close();
                    pst.close();
                    pst = con.prepareStatement("update gxstage_user_rights set status=2,aktualisiert_am=now(),aktualisiert_durch=" + this.userid + " where tid=?");
                    pst.setInt(1, Integer.parseInt(tid));
                    pst.executeUpdate();
                    con.commit();
                    String oldRowInfo = this.getRowInfo(con, tid);
                    result = "{\"result\":\"" + (String)result + "\",\"ersetzt_tid\":\"" + tid + "\",\"newtid\":\"" + newTid + "\",\"aktualisiert_am\":\"" + this.getNowString() + "\",\"aktualisiert_name\":\"" + this.user.getName() + "\", " + oldRowInfo + "}";
                }
                catch (SQLException e) {
                    logger.error((Object)("Fehler beim Aktualisieren von Datensatz: " + GxstageUserRights.getStackTrace(e)));
                    result = "{\"result\":\"" + this.adaptForJson("FEHLER " + String.valueOf(e)) + "\"}";
                    try {
                        con.rollback();
                    }
                    catch (SQLException e1) {
                        throw new SQLException(e1.getLocalizedMessage());
                    }
                }
                finally {
                    con.setAutoCommit(true);
                }
            } else {
                PreparedStatement pst = con.prepareStatement("update gxstage_user_rights set anmerkung=?, aktualisiert_am=now(),aktualisiert_durch=" + this.userid + " where tid=?");
                pst.setString(1, anmerkung);
                pst.setInt(2, Integer.parseInt(tid));
                pst.executeUpdate();
                pst.close();
                result = "{\"result\":\"" + (String)result + "\",\"aktualisiert_am\":\"" + this.getNowString() + "\",\"aktualisiert_name\":\"" + this.user.getName() + "\"}";
            }
            return result;
        }

        private String getRowInfo(Connection con, String tid) throws SQLException {
            Statement stm = con.createStatement();
            String sql = "insert into gxstage_tmp_edit (bearbeiter_id, gxstage_user_rights_tid) values (" + String.valueOf(this.user.getId()) + "," + tid + ")";
            stm.execute(sql);
            sql = "SELECT sp_gxstage_rights_edit(" + String.valueOf(this.user.getId()) + "," + tid + ");";
            stm.execute(sql);
            String sql2 = "SELECT tid, \n       userinfo_id,userkennung,username, \n       finanzstelle, finanzstelle_name,\n       hhprog,hhprog_name, \n       fonds, fonds_name,\n       fipos,startjahr,befristung, \n       rolle, \n       unterzeichner,unterzeichner_name, \n       erfasst_am, \n       erfasst_durch,erfasser_name, \n       aktualisiert_am, \n       aktualisiert_durch,aktualisiert_name, \n       anmerkung, \n       status_name \nFROM tmp_rights where 1=1 order by username asc,hhprog,finanzstelle,fonds,status";
            ResultSet rs = stm.executeQuery(sql2);
            StringBuffer result = new StringBuffer("\"oldrowinfo\":[ ");
            while (rs.next()) {
                result.append("\"" + rs.getInt("tid") + "\",");
                result.append("\"" + rs.getString("rolle") + "\",");
                result.append("\"" + rs.getString("userkennung") + "\",");
                result.append("\"" + rs.getString("username") + "\",");
                result.append("\"" + rs.getString("hhprog") + "\",");
                result.append("\"" + rs.getString("hhprog_name") + "\",");
                result.append("\"" + rs.getString("finanzstelle") + "\",");
                result.append("\"" + rs.getString("finanzstelle_name") + "\",");
                result.append("\"" + rs.getString("fonds") + "\",");
                result.append("\"" + rs.getString("fonds_name") + "\",");
                result.append("\"" + rs.getString("fipos") + "\",");
                Object jahr = "";
                int startjahr = rs.getInt("startjahr");
                if (startjahr > 0) {
                    jahr = "" + startjahr;
                }
                result.append("\"" + (String)jahr + "\",");
                String befristung = "";
                Date befr = rs.getDate("befristung");
                if (befr != null) {
                    befristung = DateUtils.format(befr);
                }
                result.append("\"" + befristung + "\",");
                String unterzeichner = rs.getString("unterzeichner_name");
                if (unterzeichner == null) {
                    unterzeichner = "";
                }
                result.append("\"" + unterzeichner + "\",");
                Timestamp erfasst_am = rs.getTimestamp("erfasst_am");
                result.append("\"" + rs.getString("erfasser_name") + "<br>" + StringUtils.replace(timeFormat.format(erfasst_am), " ", "<br>") + "\",");
                Timestamp aktualisiert_am = rs.getTimestamp("aktualisiert_am");
                result.append("\"" + rs.getString("aktualisiert_name") + "<br>" + StringUtils.replace(timeFormat.format(aktualisiert_am), " ", "<br>") + "\",");
                result.append("\"" + rs.getString("status_name") + "\",");
                result.append("\"" + this.adaptForJson(rs.getString("anmerkung")) + "\"");
            }
            result.append(" ]");
            rs.close();
            stm.executeUpdate("drop table tmp_rights");
            stm.close();
            return result.toString();
        }

        private boolean hasUserBefristungOrUnterzeichnerChanged(Connection con, String tid, int userparamInt, int unterzeichnerId, Date befrDat) throws SQLException {
            boolean result = false;
            PreparedStatement pst = con.prepareStatement("select userinfo_id,unterzeichner,befristung from gxstage_user_rights where tid=?");
            pst.setInt(1, Integer.parseInt(tid));
            ResultSet rs = pst.executeQuery();
            while (rs.next()) {
                if (rs.getInt("userinfo_id") != userparamInt) {
                    result = true;
                }
                if (rs.getInt("unterzeichner") != unterzeichnerId) {
                    result = true;
                }
                if (EqualsUtil.areEqual(rs.getDate("befristung"), befrDat)) continue;
                result = true;
            }
            rs.close();
            pst.close();
            return result;
        }

        private String getParam(String param) {
            String result = "";
            if (param.contentEquals("anmerkung")) {
                result = this.request.getParameter("anmerkung");
                result = result.replace(';', ',');
            } else {
                result = ServletHelper.getParameterString((ServletRequest)this.request, param);
                if (result != null && !param.contentEquals("user") && !param.contentEquals("unterzeichner")) {
                    result = StringUtils.replace(result, " ", "");
                }
                block11 : switch (param) {
                    case "user": {
                        break;
                    }
                    case "befristung": {
                        if (result == null || result.contentEquals("")) break;
                        if (!result.matches("\\d{2}\\.\\d{2}\\.\\d{4}")) {
                            throw new IllegalArgumentException("Befristung: Ungueltiges Datumsformat dd.MM.jjjj benutzen");
                        }
                        try {
                            Date test = this.parseStrict(result);
                            if (test.before(new java.util.Date())) {
                                throw new IllegalArgumentException("Befristungen muessen in der Zukunft liegen");
                            }
                            break;
                        }
                        catch (ParseException e) {
                            logger.debug((Object)result);
                            throw new IllegalArgumentException("Befristung: Ungueltiges Datumsformat dd.MM.jjjj benutzen");
                        }
                        catch (NumberFormatException e) {
                            logger.debug((Object)result);
                            throw new IllegalArgumentException("Befristung: Ungueltiges Datumsformat dd.MM.jjjj benutzen");
                        }
                    }
                    case "finanzstelle": {
                        if (!(result.indexOf("-") == -1 & result.indexOf("*") == -1) || this.mapContainsAllKeys(GxstageUserRights.this.finanzstellenListe, result)) break;
                        throw new IllegalArgumentException("Kostenstelle ung\u00fcltig");
                    }
                    case "hhprog": {
                        if (!(result.indexOf("-") == -1 & result.indexOf("*") == -1) || this.mapContainsAllKeys(GxstageUserRights.this.hhprogListe, result)) break;
                        throw new IllegalArgumentException("PSP-Element ung\u00fcltig");
                    }
                    case "fipos": {
                        if (!(result.indexOf("-") == -1 & result.indexOf("*") == -1) || this.mapContainsAllKeys(GxstageUserRights.this.fiposListe, result)) break;
                        throw new IllegalArgumentException("Sachkonto ung\u00fcltig");
                    }
                    case "fonds": {
                        if (!(result.indexOf("-") == -1 & result.indexOf("*") == -1) || this.mapContainsAllKeys(GxstageUserRights.this.fondsListe, result)) break;
                        throw new IllegalArgumentException("Fonds ung\u00fcltig");
                    }
                    case "startjahr": {
                        if (result == null || result.contentEquals("")) {
                            result = null;
                            break;
                        }
                        if (result.matches("\\d{4}")) break;
                        throw new IllegalArgumentException("Startjahr: Vierstellige Jahreszahl eingeben");
                    }
                    case "rolle": {
                        switch (result = result.toUpperCase()) {
                            case "AOB": 
                            case "LB": 
                            case "BKU": 
                            case "UAH": 
                            case "VERW": {
                                break block11;
                            }
                        }
                        throw new IllegalArgumentException("Rolle ung\u00fcltig");
                    }
                }
            }
            return result;
        }

        private boolean mapContainsAllKeys(HashMap<String, String> map, String keylist) {
            boolean result = true;
            StringTokenizer st = new StringTokenizer(keylist, ",");
            while (st.hasMoreTokens()) {
                if (map.containsKey(st.nextToken())) continue;
                result = false;
            }
            return result;
        }

        private int getUserId(Connection con, String name) throws SQLException {
            PreparedStatement pst2 = con.prepareStatement("select tid from userinfo  where lower(name)=? or lower(benutzer)=?");
            pst2.setString(1, name.toLowerCase());
            pst2.setString(2, name.toLowerCase());
            ResultSet rs = pst2.executeQuery();
            int userid = -1;
            while (rs.next()) {
                userid = rs.getInt(1);
            }
            rs.close();
            pst2.close();
            if (userid == -1) {
                throw new IllegalArgumentException("User unbekannt");
            }
            return userid;
        }

        private String delete(String param) {
            Object result = "FEHLER";
            try {
                Connection con = SxPools.get(this.getMandantenID()).getConnection();
                PreparedStatement pst = con.prepareStatement("update gxstage_user_rights set status=3,aktualisiert_am=now(),aktualisiert_durch=" + this.userid + " where tid=?");
                pst.setInt(1, Integer.parseInt(param));
                int rowsUpdated = pst.executeUpdate();
                result = rowsUpdated != 1 ? "FEHLER - tid " + param + " nicht gefunden" : "SUCCESS";
                pst.close();
                con.close();
            }
            catch (Exception e) {
                logger.error((Object)("Fehler beim markieren von Datensatz als gel\u00f6scht: " + GxstageUserRights.getStackTrace(e)));
                result = "FEHLER " + String.valueOf(e);
            }
            result = ((String)result).equals("SUCCESS") ? "{\"result\":\"SUCCESS\",\"aktualisiert_am\":\"" + this.getNowString() + "\",\"aktualisiert_name\":\"" + this.user.getName() + "\"}" : "{\"result\":\"" + (String)result + "\"}";
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getName(String param, String id) {
            Object result = "UNBEKANNT";
            Object query = "";
            int keyCount = 2;
            boolean isSQLNeeded = false;
            switch (param) {
                case "hhprog": {
                    result = GxstageUserRights.this.hhprogListe.get(id);
                    break;
                }
                case "finanzstelle": {
                    result = GxstageUserRights.this.finanzstellenListe.get(id);
                    break;
                }
                case "fonds": {
                    result = GxstageUserRights.this.fondsListe.get(id);
                    break;
                }
                case "fipos": {
                    result = GxstageUserRights.this.fiposListe.get(id);
                    break;
                }
                case "unterzeichner": 
                case "user": {
                    query = "select trim(name) from userinfo where lower(name)=? or lower(benutzer)=?";
                    id = id.toLowerCase();
                    isSQLNeeded = true;
                    break;
                }
                default: {
                    query = "select 'Unbekannter param:" + param + "' from xdummy where ?=?";
                }
            }
            if (isSQLNeeded) {
                Connection con = null;
                try {
                    con = SxPools.get(this.getMandantenID()).getConnection();
                    PreparedStatement pst = con.prepareStatement((String)query);
                    pst.setString(1, id.trim());
                    if (keyCount > 1) {
                        pst.setString(2, id.trim());
                    }
                    ResultSet rs = pst.executeQuery();
                    int i = 0;
                    while (rs.next()) {
                        result = rs.getString(1);
                        ++i;
                    }
                    rs.close();
                    pst.close();
                    if (i > 1) {
                        result = "FEHLER: Eingabe nicht eindeutig";
                    }
                    if (((String)result).length() > 15) {
                        result = ((String)result).substring(0, 14) + "..";
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("Fehler beim Lesen von Bezeichnung (getName) f\u00fcr Feld " + param + " Eingabe:" + id + " SQL:" + (String)query + " " + GxstageUserRights.getStackTrace(e)));
                    result = "FEHLER: " + e.toString();
                    e.printStackTrace();
                }
                finally {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            if (result == null) {
                result = "UNBEKANNT";
            }
            if (!((String)result).startsWith("FEHLER") && ((String)result).length() > 15) {
                result = ((String)result).substring(0, 14) + "..";
            }
            result = "{\"name\":\"" + this.adaptForJson((String)result) + "\"}";
            return result;
        }

        public void sendNotAuthorized() throws IOException {
            this.response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
            PrintWriter p = this.response.getWriter();
            String msg = ServletUtils.getJSONErrorText(this.userid, this.getDesiredLocale());
            logger.debug((Object)msg);
            p.print(msg);
            p.close();
        }
    }
}

