/*
 * Decompiled with CFR 0.152.
 */
package de.superx.saiku;

import de.superx.common.SxUser;
import de.superx.saiku.SuperxSaikuConnectionManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.saiku.service.util.security.authorisation.AuthorisationPredicate;
import org.saiku.web.service.SessionService;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.web.context.request.RequestContextHolder;

public class SuperxSaikuSessionService
extends SessionService {
    public static Logger logger = Logger.getLogger(SuperxSaikuSessionService.class);
    public static final String VIEW_OLAP_RIGHT = "RIGHT_CS_BIA_OLAP_CREATE_TABLES";
    public static final String ADMIN_RIGHT = "RIGHT_CS_BIA_STANDARDREPORTS_ADMIN";
    public static final String STANDARDREPORTS_RIGHT = "RIGHT_CS_BIA_STANDARDREPORTS_VIEW_REPORTS";
    public static final String ROLE_BI_ADMIN = "ROLE_BI_ADMIN";
    public static final String ROLE_BI_SPECIALIST = "ROLE_BI_SPECIALIST";
    Map<SxUser, Map<String, Object>> sessionHolder = new HashMap<SxUser, Map<String, Object>>();
    private transient AuthenticationManager authenticationManager;
    private transient AuthorisationPredicate authorisationPredicate;
    private transient SuperxSaikuConnectionManager connectionManager;
    private Boolean anonymous = Boolean.FALSE;

    public void setConnectionManager(SuperxSaikuConnectionManager cm) {
        this.connectionManager = cm;
    }

    public void setAuthorisationPredicate(AuthorisationPredicate authorisationPredicate) {
        this.authorisationPredicate = authorisationPredicate;
    }

    public void setAllowAnonymous(Boolean allow) {
        this.anonymous = allow;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void authenticate(HttpServletRequest req, String username, String password) {
        SxUser sxUser = SuperxSaikuSessionService.getSuperxUserFromSession(req);
        SxUser principal = null;
        String credentials = null;
        if (sxUser == null) throw new RuntimeException("SuperX-Session Authentication failed for: " + username);
        if (sxUser.getHis1Rights().isEmpty()) {
            throw new RuntimeException("SuperX Authentication failed. Missing rights!");
        }
        principal = sxUser;
        credentials = sxUser.getPassword();
        try {
            PreAuthenticatedAuthenticationToken token = new PreAuthenticatedAuthenticationToken((Object)principal, (Object)credentials);
            token.setDetails((Object)principal);
            Authentication authentication = this.authenticationManager.authenticate((Authentication)token);
            logger.info((Object)("Logging in with " + String.valueOf(authentication.getPrincipal())));
            SecurityContextHolder.getContext().setAuthentication(authentication);
        }
        catch (BadCredentialsException bd) {
            throw new RuntimeException("Authentication failed for: " + username, bd);
        }
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (this.authorisationPredicate.isAuthorised(auth)) {
            Object p = auth.getPrincipal();
            int hc = p.hashCode();
            if (this.sessionHolder.containsKey(p)) return;
            this.createSession(auth, username, password);
            return;
        } else {
            logger.info((Object)(username + " failed authorisation. Rejecting login"));
            throw new RuntimeException("Authorisation failed for: " + username);
        }
    }

    public Map<String, Object> getSession() {
        Object p;
        if (SecurityContextHolder.getContext() != null && SecurityContextHolder.getContext().getAuthentication() != null && this.sessionHolder.containsKey(p = SecurityContextHolder.getContext().getAuthentication().getPrincipal())) {
            HashMap<String, Object> r = new HashMap<String, Object>();
            r.putAll(this.sessionHolder.get(p));
            r.remove("password");
            return r;
        }
        return new HashMap<String, Object>();
    }

    public Map<String, Object> getAllSessionObjects() {
        Object p;
        if (SecurityContextHolder.getContext() != null && SecurityContextHolder.getContext().getAuthentication() != null && this.sessionHolder.containsKey(p = SecurityContextHolder.getContext().getAuthentication().getPrincipal())) {
            HashMap<String, Object> r = new HashMap<String, Object>();
            r.putAll(this.sessionHolder.get(p));
            return r;
        }
        return new HashMap<String, Object>();
    }

    public Map<String, Object> login(HttpServletRequest req, String username, String password) {
        if (this.authenticationManager != null) {
            this.authenticate(req, username, password);
        }
        if (SecurityContextHolder.getContext() != null && SecurityContextHolder.getContext().getAuthentication() != null) {
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            if (this.authorisationPredicate.isAuthorised(auth)) {
                Object p = auth.getPrincipal();
                return this.sessionHolder.get(p);
            }
            logger.info((Object)(username + " failed authorisation. Rejecting login"));
            throw new RuntimeException("Authorisation failed for: " + username);
        }
        return new HashMap<String, Object>();
    }

    private void createSession(Authentication auth, String username, String password) {
        boolean isAnonOk;
        if (auth == null || !auth.isAuthenticated()) {
            return;
        }
        boolean isAnonymousUser = auth instanceof AnonymousAuthenticationToken;
        SxUser p = (SxUser)auth.getPrincipal();
        String authUser = p.getUsername();
        Integer orgunit = p.getHisInOneOrgUnitLidOfRole();
        if (authUser == null) {
            throw new RuntimeException("No username found for: " + username);
        }
        boolean isAnonymous = isAnonymousUser || StringUtils.equals((CharSequence)"anonymousUser", (CharSequence)authUser);
        boolean bl = isAnonOk = !isAnonymous || isAnonymous && this.anonymous != false;
        if (isAnonOk && auth.isAuthenticated() && p != null && !this.sessionHolder.containsKey(p)) {
            HashMap<String, Object> session = new HashMap<String, Object>();
            if (isAnonymous) {
                logger.debug((Object)"Creating Session for Anonymous User");
            }
            if (StringUtils.isNotBlank((CharSequence)username)) {
                session.put("username", username);
                session.put("userinfo_id", p.getId());
                session.put("useruuid", p.getUUID());
            } else {
                session.put("username", authUser);
            }
            if (StringUtils.isNotBlank((CharSequence)password)) {
                session.put("password", password);
            }
            session.put("sessionid", UUID.randomUUID().toString());
            session.put("authid", RequestContextHolder.currentRequestAttributes().getSessionId());
            ArrayList<String> roles = new ArrayList<String>();
            for (GrantedAuthority ga : SecurityContextHolder.getContext().getAuthentication().getAuthorities()) {
                roles.add(ga.getAuthority());
            }
            session.put("roles", roles);
            session.put("rights", p.getHis1Rights());
            session.put("orgunit", orgunit);
            this.sessionHolder.put(p, session);
        }
    }

    public void logout(HttpServletRequest httpServletRequest) {
        Object p;
        this.connectionManager.removeConnection("BI");
        if (SecurityContextHolder.getContext() != null && SecurityContextHolder.getContext().getAuthentication() != null && this.sessionHolder.containsKey(p = SecurityContextHolder.getContext().getAuthentication().getPrincipal())) {
            this.sessionHolder.remove(p);
        }
        SecurityContextHolder.clearContext();
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public static SxUser getSuperxUserFromSession(HttpServletRequest httpServletRequest) {
        SxUser result = null;
        HttpSession session = httpServletRequest.getSession();
        if (session != null) {
            result = (SxUser)session.getAttribute("user");
        }
        return result;
    }
}

