/*
 * Decompiled with CFR 0.152.
 */
package de.superx.rest.util;

import de.superx.common.Field;
import de.superx.common.FieldContainer;
import de.superx.rest.model.FieldType;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class RequestWrapper {
    public static final SimpleDateFormat ISO_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat GERMAN_DATE_FORMAT = new SimpleDateFormat("dd.MM.yyy");

    public static HttpServletRequest wrapHttpServletRequest(final Map<String, String> params, HttpServletRequest inRequ, final FieldContainer fieldContainer) {
        HttpServletRequestWrapper request = new HttpServletRequestWrapper(inRequ){
            Map<String, String[]> parameterMap;
            {
                super(arg0);
                this.parameterMap = new HashMap<String, String[]>();
            }

            public String getParameter(String name) {
                if (this.isDateParam(name)) {
                    return this.adjustFormat(name);
                }
                return (String)params.get(name);
            }

            private boolean isDateParam(String name) {
                for (Field field : fieldContainer) {
                    if (field.getFieldType() != FieldType.DatePicker || !field.getName().equals(name)) continue;
                    return true;
                }
                return false;
            }

            private String adjustFormat(String name) {
                String dateString = (String)params.get(name);
                if (dateString != null) {
                    try {
                        Date date = ISO_DATE_FORMAT.parse(dateString);
                        String newDateString = GERMAN_DATE_FORMAT.format((Object)date);
                        return newDateString;
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
                return dateString;
            }

            public Enumeration<String> getParameterNames() {
                return new Enumeration<String>(){
                    Iterator<String> paramsIterator;
                    {
                        this.paramsIterator = params.keySet().iterator();
                    }

                    @Override
                    public boolean hasMoreElements() {
                        return this.paramsIterator.hasNext();
                    }

                    @Override
                    public String nextElement() {
                        return this.paramsIterator.next();
                    }
                };
            }

            public Map<String, String[]> getParameterMap() {
                if (!params.isEmpty() && this.parameterMap.isEmpty()) {
                    for (String key : params.keySet()) {
                        this.parameterMap.put(key, new String[]{(String)params.get(key)});
                    }
                }
                return this.parameterMap;
            }

            public String[] getParameterValues(String name) {
                String[] stringArray;
                if (params.containsKey(name)) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = this.getParameter(name);
                } else {
                    stringArray = null;
                }
                return stringArray;
            }
        };
        return request;
    }
}

